/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.image;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import thunderheadeng.image.FileImageCreator;
import thunderheadeng.image.IImage;
import thunderheadeng.image.IImageCreator;
import thunderheadeng.image.Image;
import thunderheadeng.io.FileSystem;

public class ImageManager {
    private static final Map<String, WeakReference<Image>> s_imageCache = new HashMap<String, WeakReference<Image>>();

    public static final IImage getImage(String id) {
        int fsOptions = 3;
        int creatorOptions = 2;
        return ImageManager.getImage(id, fsOptions, creatorOptions);
    }

    public static final IImage getImage(String id, int fsOptions, int imageOptions) {
        return ImageManager.getImage(id, new FileImageCreator(FileSystem.INSTANCE, imageOptions, fsOptions));
    }

    public static final IImage getImage(String id, IImageCreator creator) {
        IImage image;
        WeakReference<Image> imageref = s_imageCache.get(id);
        IImage iImage = image = imageref != null ? (IImage)imageref.get() : null;
        if (image == null && creator != null && (image = creator.create(id)) != null) {
            s_imageCache.put(id, new WeakReference<IImage>(image));
        }
        return image;
    }

    public static void registerImage(String id, Image img) {
        if (!s_imageCache.containsKey(id)) {
            s_imageCache.put(id, new WeakReference<Image>(img));
        }
    }
}

