/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.image;

import java.io.IOException;
import thunderheadeng.image.IImage;
import thunderheadeng.io.streamsrc.IStreamSrc;

public class HashableImage
implements IImage {
    public final IImage image;

    public HashableImage(IImage image) {
        this.image = image;
    }

    public boolean equals(Object obj) {
        return HashableImage.equalsImpl(this, obj);
    }

    public static boolean equalsImpl(HashableImage img, Object obj) {
        if (img == obj) {
            return true;
        }
        if (!(obj instanceof IImage)) {
            return false;
        }
        IImage i2 = (IImage)obj;
        return img.getWidth() == i2.getWidth() && img.getHeight() == i2.getHeight() && HashableImage.getFileSize(img, 0) == HashableImage.getFileSize(i2, 0);
    }

    public int hashCode() {
        return (int)HashableImage.getFileSize(this, 0) + this.getWidth() + this.getHeight();
    }

    private static long getFileSize(IImage image, int streamOptions) {
        try {
            return image.getSource().getSize(streamOptions);
        }
        catch (IOException e) {
            return 0L;
        }
    }

    @Override
    public String getFilename() {
        return this.image.getFilename();
    }

    @Override
    public int getHeight() {
        return this.image.getHeight();
    }

    @Override
    public int getWidth() {
        return this.image.getWidth();
    }

    @Override
    public boolean hasTransparency() {
        return this.image.hasTransparency();
    }

    @Override
    public int getBitsPerPixel() {
        return this.image.getBitsPerPixel();
    }

    @Override
    public IStreamSrc getSource() {
        return this.image.getSource();
    }

    @Override
    public HashableImage makeHashable() {
        return this;
    }
}

