/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui.wizard;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import javax.swing.ButtonGroup;
import javax.swing.UIManager;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.wizard.AWizardCard;
import thunderheadeng.gui.wizard.WizardDlg;

public class ExampleWizard {
    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        WizardDlg<Object> dlg = new WizardDlg<Object>(null, "Choose Your Adventure!", "You face a troll.", new Choice());
        dlg.doModal();
    }

    public static class Flee
    extends AWizardCard<Object> {
        private static final long serialVersionUID = 449096105726273041L;

        public Flee() {
            super("You have chosen run from the troll.");
            this.setLayout(new GridBagLayout());
            guiPanel p = new guiPanel();
            GridBagUtil.add(this, p, 0, 0, 1, 1, 12, 12, 12, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.addGlue(this);
            p.setLayout(new GridBagLayout());
            GridBagUtil.add(p, new guiLabel("You are overtaken by the troll. There's more screaming. You die."), 0, 0, 2, 1, 12, 12, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.addGlue(p);
        }

        @Override
        public boolean isActionEnabled(Object data, int action) {
            switch (action) {
                case 4: {
                    return true;
                }
                case 0: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void initFrom(Object data) {
        }

        @Override
        public void saveTo(Object data) {
        }

        @Override
        public void cancel() {
        }

        @Override
        public AWizardCard<Object> getNext() {
            return null;
        }
    }

    public static class Fight
    extends AWizardCard<Object> {
        private static final long serialVersionUID = -4032304161614697839L;

        public Fight() {
            super("You have chosen to fight the troll.");
            this.setLayout(new GridBagLayout());
            guiPanel p = new guiPanel();
            GridBagUtil.add(this, p, 0, 0, 1, 1, 12, 12, 12, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.addGlue(this);
            p.setLayout(new GridBagLayout());
            GridBagUtil.add(p, new guiLabel("You die suddenly. With squashing."), 0, 0, 2, 1, 12, 12, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.addGlue(p);
        }

        @Override
        public boolean isActionEnabled(Object data, int action) {
            switch (action) {
                case 4: {
                    return true;
                }
                case 0: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void initFrom(Object data) {
        }

        @Override
        public void saveTo(Object data) {
        }

        @Override
        public void cancel() {
        }

        @Override
        public AWizardCard<Object> getNext() {
            return null;
        }
    }

    public static class Choice
    extends AWizardCard<Object> {
        private static final long serialVersionUID = 3296886986308005746L;
        private guiRadioButton d_fight;
        private guiRadioButton d_flee;

        public Choice() {
            super("It's a really really big troll, too.");
            this.setLayout(new GridBagLayout());
            guiPanel p = new guiPanel();
            GridBagUtil.add(this, p, 0, 0, 1, 1, 12, 12, 12, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.addGlue(this);
            this.d_fight = new guiRadioButton("Attack the troll bare-handed!");
            this.d_flee = new guiRadioButton("Run away. Run fast and far (with screaming).");
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.d_fight);
            bg.add(this.d_flee);
            p.setLayout(new GridBagLayout());
            GridBagUtil.add(p, new guiLabel("What will you do?"), 0, 0, 2, 1, 12, 12, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(p, this.d_fight, 0, 1, 1, 1, 12, 30, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(p, this.d_flee, 0, 2, 1, 1, 0, 30, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.addGlue(p);
        }

        @Override
        public Dimension getPreferredSize() {
            return Choice.getMaxDimension(super.getPreferredSize(), new Fight().getPreferredSize(), new Flee().getPreferredSize());
        }

        @Override
        public boolean isActionEnabled(Object data, int action) {
            switch (action) {
                case 1: {
                    return this.d_fight.isSelected() || this.d_flee.isSelected();
                }
                case 0: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void initFrom(Object data) {
        }

        @Override
        public void saveTo(Object data) {
        }

        @Override
        public void cancel() {
        }

        @Override
        public AWizardCard<Object> getNext() {
            if (this.d_fight.isSelected()) {
                return new Fight();
            }
            if (this.d_flee.isSelected()) {
                return new Flee();
            }
            return null;
        }
    }
}

