/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui.video;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.Intl;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.InvisibleSplitPane;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiSliderVal;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.Global;
import thunderheadeng.util.IntVR;
import thunderheadeng.util.theUtil;
import thunderheadeng.video.IVideoCompressor;
import thunderheadeng.video.IVideoCompressors;

public class VideoCompressorPnl
extends guiPanel {
    private final JList<IVideoCompressor> d_compressorsList;
    private final guiSliderVal d_quality;
    private final guiLabel d_defQualityLbl;
    private final guiCheckBox d_dataRateCB;
    private final ValueField<UnitDouble> d_dataRateFld;
    private final guiCheckBox d_keyframeCB;
    private final ValueField<Integer> d_keyframeFld;
    private final guiLabel d_defKeyframeLbl;
    private final JButton d_configureBtn;
    private final JButton d_aboutBtn;
    private IVideoCompressor d_selCompressor;

    public VideoCompressorPnl(IVideoCompressors.Type type, List<IVideoCompressor> compressors, IUnitSrc datarateUnit) {
        ArrayList<IVideoCompressor> clist = new ArrayList<IVideoCompressor>(compressors);
        clist.sort((c1, c2) -> c1.get(IVideoCompressor.DESCRIPTION).compareToIgnoreCase(c2.get(IVideoCompressor.DESCRIPTION)));
        this.d_compressorsList = new JList<IVideoCompressor>(theUtil.toArray(clist, IVideoCompressor.class));
        this.d_compressorsList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                IVideoCompressor c = (IVideoCompressor)value;
                this.setText(c.get(IVideoCompressor.DESCRIPTION));
                return this;
            }
        });
        this.d_compressorsList.setSelectionMode(0);
        this.d_compressorsList.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.syncSelection();
        });
        JScrollPane compressorSP = new JScrollPane(this.d_compressorsList);
        compressorSP.setPreferredSize(new Dimension(200, 100));
        this.d_quality = new guiSliderVal();
        guiLabel defQualityLbl = new guiLabel(Intl.intl("Default Quality:"));
        this.d_defQualityLbl = new guiLabel("");
        this.group(IVideoCompressor.QUALITY, new JComponent[]{this.d_quality, defQualityLbl, this.d_defQualityLbl});
        this.d_dataRateCB = new guiCheckBox(Intl.intl("Specify target data rate:"));
        this.d_dataRateFld = ValueFields.udFld(datarateUnit, UnitDoubleVR.above(0.0, SI.BIT.divide((Unit)SI.SECOND), false));
        this.group(IVideoCompressor.DATARATE, new JComponent[]{this.d_dataRateCB, this.d_dataRateFld});
        this.d_keyframeCB = new guiCheckBox(Intl.intl("Keyframe interval:"));
        this.d_keyframeFld = ValueFields.intFld(IntVR.above(1, true));
        guiLabel framesLbl = new guiLabel(Intl.intl("frames"));
        guiLabel defKeyframeLbl = new guiLabel(Intl.intl("Default Keyframe Interval:"));
        this.d_defKeyframeLbl = new guiLabel("");
        this.group(IVideoCompressor.KEYFRAME_INTERVAL, new JComponent[]{this.d_keyframeCB, this.d_keyframeFld, framesLbl, defKeyframeLbl, this.d_defKeyframeLbl});
        this.d_configureBtn = new JButton(Intl.intl("Configure..."));
        this.d_configureBtn.addActionListener(e -> this.d_selCompressor.showPropsDlg(this));
        this.d_aboutBtn = new JButton(Intl.intl("About..."));
        this.d_aboutBtn.addActionListener(e -> this.d_selCompressor.showAboutDlg(this));
        guiUtil.link((AbstractButton)this.d_dataRateCB, this.d_dataRateFld);
        guiUtil.link((AbstractButton)this.d_keyframeCB, this.d_keyframeFld, framesLbl);
        guiPanel defPnl = new guiPanel();
        defPnl.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY), BorderFactory.createEmptyBorder(12, 12, 12, 12)));
        GridBagHelper gb = new GridBagHelper(defPnl);
        gb.addRow(defQualityLbl, this.d_defQualityLbl);
        gb.addRow(defKeyframeLbl, this.d_defKeyframeLbl);
        gb.finalizeRows();
        guiPanel btnPnl = new guiPanel();
        gb = new GridBagHelper(btnPnl);
        gb.add(this.d_configureBtn, this.d_aboutBtn);
        gb.finalizeRows();
        guiPanel qualityRow = new guiPanel();
        gb = new GridBagHelper(qualityRow);
        gb.addRow(Intl.intl("Quality:"), this.d_quality, 1.0, 0);
        guiPanel infoPnl = new guiPanel();
        gb = new GridBagHelper(infoPnl);
        gb.addRow(qualityRow, 1.0, 0);
        gb.addRow(this.d_dataRateCB, this.d_dataRateFld, 1.0);
        gb.addRow(this.d_keyframeCB, this.d_keyframeFld, 1.0, framesLbl);
        gb.addFilledRow(defPnl);
        gb.addRow(new Object[]{btnPnl, GridBagHelper.Anchor.CENTER, 0.0, 0});
        gb.finalizeRows();
        infoPnl.setMinimumSize(infoPnl.getPreferredSize());
        InvisibleSplitPane split = new InvisibleSplitPane(1, compressorSP, infoPnl);
        this.setLayout(new BorderLayout());
        this.add((Component)split, "Center");
        if (!clist.isEmpty()) {
            this.d_compressorsList.setSelectedIndex(0);
        } else {
            this.setEnabled(false);
        }
    }

    private void syncSelection() {
        IVideoCompressor compressor = this.d_compressorsList.getSelectedValue();
        if (compressor != null && compressor != this.d_selCompressor) {
            if (this.d_selCompressor != null) {
                this.save(this.d_selCompressor);
            }
            this.d_selCompressor = compressor;
            this.syncCompressor(compressor);
        }
    }

    private void syncCompressor(IVideoCompressor compressor) {
        this.syncButtons(compressor);
        boolean hasQuality = compressor.isSupported(IVideoCompressor.QUALITY);
        this.setGroupEnabled(IVideoCompressor.QUALITY, hasQuality);
        if (hasQuality) {
            this.d_quality.setValue((float)compressor.get(IVideoCompressor.QUALITY).abs().get(Unit.ONE));
            this.d_defQualityLbl.setText(Global.format(compressor.getDefault(IVideoCompressor.QUALITY).abs().convert(NonSI.PERCENT)));
        } else {
            this.d_quality.setValue(1.0f);
            this.d_defQualityLbl.setText("");
        }
        boolean hasKeyframe = compressor.isSupported(IVideoCompressor.KEYFRAME_INTERVAL);
        this.setGroupEnabled(IVideoCompressor.KEYFRAME_INTERVAL, hasKeyframe);
        if (hasKeyframe) {
            int kf = compressor.get(IVideoCompressor.KEYFRAME_INTERVAL);
            this.d_keyframeCB.setSelected(kf >= 0);
            this.d_keyframeFld.setValue(Math.abs(kf));
            this.d_defKeyframeLbl.setText(Integer.toString(Math.abs(compressor.getDefault(IVideoCompressor.KEYFRAME_INTERVAL))));
        } else {
            this.d_keyframeCB.setSelected(false);
            this.d_keyframeFld.setValue(null);
            this.d_defKeyframeLbl.setText("");
        }
        boolean hasDatarate = compressor.isSupported(IVideoCompressor.DATARATE);
        this.setGroupEnabled(IVideoCompressor.DATARATE, hasDatarate);
        if (hasDatarate) {
            UnitDouble dr = compressor.get(IVideoCompressor.DATARATE);
            this.d_dataRateCB.setSelected(dr.getValueNoUnit() >= 0.0);
            this.d_dataRateFld.setValue(dr.abs());
        } else {
            this.d_dataRateCB.setSelected(false);
            this.d_dataRateFld.setValue(null);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.syncButtons(this.d_selCompressor);
    }

    private void syncButtons(IVideoCompressor compressor) {
        if (this.isDisplayable()) {
            this.d_aboutBtn.setEnabled(compressor.hasAboutDlg(this));
            this.d_configureBtn.setEnabled(compressor.hasPropsDlg(this));
        }
    }

    public void load(IVideoCompressor compressor) {
        if (compressor == null) {
            this.d_compressorsList.setSelectedIndex(-1);
        } else {
            this.d_compressorsList.setSelectedValue(compressor, true);
        }
    }

    public IVideoCompressor save() {
        IVideoCompressor result = this.d_selCompressor;
        if (result == null) {
            return null;
        }
        this.save(result);
        return result;
    }

    private void save(IVideoCompressor result) {
        if (result.isSupported(IVideoCompressor.DATARATE)) {
            UnitDouble value = (UnitDouble)this.d_dataRateFld.getValue();
            if (!this.d_dataRateCB.isSelected()) {
                value = value.negate();
            }
            result.set(IVideoCompressor.DATARATE, value);
        }
        if (result.isSupported(IVideoCompressor.KEYFRAME_INTERVAL)) {
            int kf = (Integer)this.d_keyframeFld.getValue();
            if (!this.d_keyframeCB.isSelected()) {
                kf = -kf;
            }
            result.set(IVideoCompressor.KEYFRAME_INTERVAL, kf);
        }
        if (result.isSupported(IVideoCompressor.QUALITY)) {
            result.set(IVideoCompressor.QUALITY, new UnitDouble(this.d_quality.getValue(), Unit.ONE));
        }
    }

    static {
        SI.GIGA((Unit)SI.BIT).label("Gb");
        SI.MEGA((Unit)SI.BIT).label("Mb");
        SI.KILO((Unit)SI.BIT).label("Kb");
        SI.GIGA((Unit)NonSI.BYTE).label("GB");
        SI.MEGA((Unit)NonSI.BYTE).label("MB");
        SI.KILO((Unit)NonSI.BYTE).label("KB");
    }
}

