/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui.video;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.util.List;
import javax.swing.JOptionPane;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.Intl;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.video.VideoCompressorPnl;
import thunderheadeng.units.ConstantUnitSrc;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.video.IVideoCompressor;
import thunderheadeng.video.IVideoCompressors;

public class VideoCompressorDlg
extends guiDialog {
    private final VideoCompressorPnl d_pnl;
    private final boolean d_selectionRequired;

    public VideoCompressorDlg(Window owner, String title, IVideoCompressors.Type type, List<IVideoCompressor> compressors, boolean selectionRequired) {
        this(owner, title, type, compressors, new ConstantUnitSrc(SI.KILO((Unit)SI.BIT).label("kbit").divide((Unit)SI.SECOND)), selectionRequired);
    }

    public VideoCompressorDlg(Window owner, String title, IVideoCompressors.Type type, List<IVideoCompressor> compressors, IUnitSrc datarateUnit, boolean selectionRequired) {
        super(owner, title, 9);
        this.d_pnl = new VideoCompressorPnl(type, compressors, datarateUnit);
        this.d_selectionRequired = selectionRequired;
        guiPanel mainPnl = this.getDialogPane();
        mainPnl.setLayout(new BorderLayout());
        mainPnl.add((Component)this.d_pnl, "Center");
        this.setResizable(true);
    }

    public void load(IVideoCompressor compressor) {
        this.d_pnl.load(compressor);
    }

    public IVideoCompressor save() {
        return this.d_pnl.save();
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        if (this.d_selectionRequired && this.save() == null) {
            if (showWarn) {
                JOptionPane.showMessageDialog(this, Intl.intl("A compressor must be selected"), Intl.intl("No Compressor Selected"), 0);
            }
            return false;
        }
        return true;
    }
}

