/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui.tool;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import thunderheadeng.gui.DecoratedIcon;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.gui.tool.Tool;
import thunderheadeng.gui.tool.ToolManager;

public class ToolToggleButton
extends JToggleButton {
    private boolean d_stickyModifiable;

    ToolToggleButton(Tool tool, ToolManager.ToolAction toolAction, boolean stickyModifiable, KeyStroke accelerator) {
        super(toolAction);
        this.setModel(new ToolToggleButtonModel());
        this.d_stickyModifiable = stickyModifiable;
        this.getActionMap().put(tool, new ToggleButtonAction(this));
        this.getInputMap(2).put(accelerator, tool);
    }

    public void setSticky(boolean sticky) {
        ((ToolToggleButtonModel)this.getModel()).setSticky(sticky);
    }

    public boolean isSticky() {
        return ((ToolToggleButtonModel)this.getModel()).isSticky();
    }

    private class ToggleButtonAction
    extends AbstractAction {
        private final ToolToggleButton toolButton;

        ToggleButtonAction(ToolToggleButton toolButton) {
            this.toolButton = toolButton;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.toolButton.doClick();
        }
    }

    private class ToolToggleButtonModel
    extends JToggleButton.ToggleButtonModel {
        private boolean d_isSticky = false;
        private final ImageIcon stickyIcon = guiUtil.loadTeciIcon("pin.png");

        private ToolToggleButtonModel() {
        }

        @Override
        public void setPressed(boolean isPressed) {
            boolean toggleSticky;
            boolean bl = toggleSticky = !isPressed && this.isSelected() && ToolToggleButton.this.d_stickyModifiable;
            if (toggleSticky) {
                isPressed = !this.d_isSticky;
                this.setSticky(isPressed);
                super.setPressed(isPressed);
            } else {
                super.setPressed(isPressed);
            }
        }

        public void setSticky(boolean sticky) {
            this.d_isSticky = sticky;
            if (this.d_isSticky) {
                ImageIcon newIcon = ToolToggleButton.this.getIcon() != null ? new DecoratedIcon(ToolToggleButton.this.getIcon(), this.stickyIcon, 3) : this.stickyIcon;
                ToolToggleButton.this.setIcon(newIcon);
            } else {
                Icon currIcon = ToolToggleButton.this.getIcon();
                if (currIcon instanceof DecoratedIcon) {
                    ToolToggleButton.this.setIcon(((DecoratedIcon)currIcon).getBase());
                } else if (currIcon == this.stickyIcon) {
                    ToolToggleButton.this.setIcon(null);
                }
            }
        }

        public boolean isSticky() {
            return this.d_isSticky;
        }
    }
}

