/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui.tool;

import java.awt.AWTException;
import java.awt.Point;
import java.awt.Robot;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import thunderheadeng.gui.tool.IMouseDevc;

public class SwingMouse
extends MouseAdapter
implements IMouseDevc {
    private static final IMouseDevc.MouseButtonHistory DEF_HISTORY = new IMouseDevc.MouseButtonHistory();
    private final Map<Integer, IMouseDevc.MouseButtonHistory> d_buttons = new HashMap<Integer, IMouseDevc.MouseButtonHistory>();
    private final Robot d_robot;
    private Point d_location = new Point(0, 0);

    public SwingMouse() {
        Robot robot = null;
        try {
            robot = new Robot();
        }
        catch (AWTException e) {
            e.printStackTrace();
        }
        this.d_robot = robot;
    }

    @Override
    public IMouseDevc.MouseButtonHistory getHistory(IMouseDevc.Button button) {
        return this.getHistory(SwingMouse.getSwingButton(button));
    }

    @Override
    public IMouseDevc.MouseButtonHistory getHistory(int button) {
        return this.d_buttons.getOrDefault(button, DEF_HISTORY);
    }

    private IMouseDevc.MouseButtonHistory history(int button) {
        return this.d_buttons.computeIfAbsent(button, b -> new IMouseDevc.MouseButtonHistory());
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.d_location = e.getPoint();
        IMouseDevc.MouseButtonHistory history = this.history(e.getButton());
        if (history.isPressed) {
            history.lastReleased = e.getWhen();
        }
        history.lastPressed = e.getWhen();
        history.isPressed = true;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.d_location = e.getPoint();
        IMouseDevc.MouseButtonHistory history = this.history(e.getButton());
        if (!history.isPressed) {
            history.lastPressed = e.getWhen();
        }
        history.lastReleased = e.getWhen();
        history.isPressed = false;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.d_location = e.getPoint();
        this.d_buttons.values().stream().filter(h -> h.isPressed).forEach(h -> {
            h.lastDragged = e.getWhen();
        });
    }

    @Override
    public void moveMouse(Point locOnScreen) {
        this.d_robot.mouseMove(locOnScreen.x, locOnScreen.y);
    }

    public static IMouseDevc.Button getPredef(MouseEvent e) {
        return SwingMouse.getPredef(e.getButton());
    }

    public static IMouseDevc.Button getPredef(int jbtn) {
        IMouseDevc.Button[] button = new IMouseDevc.Button[]{null};
        SwingMouse.ifPredef(jbtn, (IMouseDevc.Button b) -> {
            buttonArray[0] = b;
        });
        return button[0];
    }

    public static void ifPredef(MouseEvent e, Consumer<IMouseDevc.Button> consumer) {
        SwingMouse.ifPredef(e.getButton(), consumer);
    }

    public static void ifPredef(int button, Consumer<IMouseDevc.Button> consumer) {
        switch (button) {
            case 1: {
                consumer.accept(IMouseDevc.Button.LEFT);
                break;
            }
            case 2: {
                consumer.accept(IMouseDevc.Button.MIDDLE);
                break;
            }
            case 3: {
                consumer.accept(IMouseDevc.Button.RIGHT);
            }
        }
    }

    public static int getSwingButton(IMouseDevc.Button btn) {
        switch (btn) {
            case LEFT: {
                return 1;
            }
            case MIDDLE: {
                return 2;
            }
            case RIGHT: {
                return 3;
            }
        }
        assert (false);
        return 1;
    }
}

