/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui.test;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.function.Predicate;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.format.IntFormat;
import thunderheadeng.gui.format.UnitDoubleFormat;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiFormattedFld;
import thunderheadeng.units.ConstantUnitSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.IntVR;
import thunderheadeng.util.theUtil;

public class FieldTest {
    public static void main(String[] args) {
        guiDialog dlg = new guiDialog(null, "guiFormattedFld test", 9);
        GridBagHelper gb = new GridBagHelper(dlg.getDialogPane());
        final guiFormattedFld<Integer> iFld1 = FieldTest.newIntFld(false, true, null);
        iFld1.setCommitOnValidEdit(false);
        final guiFormattedFld<Integer> iFld2 = FieldTest.newIntFld(false, false, null);
        iFld2.setCommitOnValidEdit(true);
        guiFormattedFld<Integer> iFld3 = FieldTest.newIntFld(true, true, null);
        guiFormattedFld<Integer> iFld4 = FieldTest.newIntFld(false, false, IntVR.between(3, 9, true, false));
        ValueField<UnitDouble> udFld1 = ValueFields.udFld(DoubleVR.above(0.0, false), (Unit)SI.METER);
        UnitDoubleFormat udFormat = new UnitDoubleFormat(new ConstantUnitSrc((Unit)SI.METER), false);
        udFormat.alias(new UnitDouble(3.0, (Unit)SI.METER), "blah", "blah2");
        guiFormattedFld<Object> udFld2 = new guiFormattedFld<Object>(udFormat, null);
        iFld1.addValueChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!theUtil.equal(evt.getOldValue(), evt.getNewValue())) {
                    System.out.println("iFld1 changed: " + iFld1.getValue());
                }
            }
        });
        iFld2.addValueChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!theUtil.equal(evt.getOldValue(), evt.getNewValue())) {
                    System.out.println("iFld2 changed: " + iFld2.getValue() + " " + evt.getOldValue() + " " + evt.getNewValue());
                }
            }
        });
        udFld1.setValue(new UnitDouble(-1.0, NonSI.FOOT));
        gb.addRow("[nullAllowed, yieldOnError, filter]", 0);
        gb.addRow("Int1 [f,t,null]:", iFld1);
        gb.addRow("Int2 [f,f,null]:", iFld2);
        gb.addRow("Int3 [t,t,null]:", iFld3);
        gb.addRow("Int4 [f,f,3 <= x < 9]:", iFld4);
        gb.addRow("UD1  [f,f,x > 0]:", udFld1);
        gb.addRow("UD2  [f,f,blah,blah2]:", udFld2);
        gb.finalizeRows();
        if (dlg.doModal() == 1) {
            System.out.println(iFld1.getValue());
            System.out.println(iFld2.getValue());
            System.out.println(iFld3.getValue());
            System.out.println(iFld4.getValue());
            System.out.println(udFld1.getValue());
            System.out.println((Object)udFld2.getValue());
        }
    }

    private static guiFormattedFld<Integer> newIntFld(boolean nullAllowed, boolean yieldFocOnError, Predicate<Integer> filter) {
        guiFormattedFld<Object> fld = new guiFormattedFld<Object>(new guiFormattedFld.Formatter<Integer>(new IntFormat(), filter, nullAllowed), null);
        fld.setYieldFocusOnError(yieldFocOnError);
        return fld;
    }
}

