/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import javax.swing.ActionMap;
import javax.swing.DefaultCellEditor;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import org.jscience.physics.units.Unit;
import thunderheadeng.Intl;
import thunderheadeng.gui.AbstractCommand;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.Command;
import thunderheadeng.gui.CommandAction;
import thunderheadeng.gui.ContextMenu;
import thunderheadeng.gui.ContextMenuListener;
import thunderheadeng.gui.ContextMenuModel;
import thunderheadeng.gui.Modifiable;
import thunderheadeng.gui.Validateable;
import thunderheadeng.gui.WaitCursorMgr;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.gui.table.ColorTableCell;
import thunderheadeng.gui.table.ComboBoxTableCell;
import thunderheadeng.gui.table.CustomHeader;
import thunderheadeng.gui.table.DefaultTableClipboard;
import thunderheadeng.gui.table.LimitedTableClipboard;
import thunderheadeng.gui.table.ResizableTableModel;
import thunderheadeng.gui.table.SortMod;
import thunderheadeng.gui.table.TableModelValidator;
import thunderheadeng.gui.table.guiDefaultTableModel;
import thunderheadeng.gui.table.guiRowHeader;
import thunderheadeng.gui.table.guiTableClipboard;
import thunderheadeng.io.ObjectSelection;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.BitOptions;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Global;
import thunderheadeng.util.Pair;

public class guiTable
extends JTable
implements ContextMenuModel,
Modifiable,
Validateable {
    public static final CustomHeader HEADER_UP = new CustomHeader("graphics/SpinUp.gif");
    public static final CustomHeader HEADER_DOWN = new CustomHeader("graphics/SpinDown.gif");
    public static final String COMMIT_ADD_ROW_ACTION = "CommitAddRow";
    public static final String CUT_ACTION = "Cut";
    public static final String COPY_ACTION = "Copy";
    public static final String PASTE_ACTION = "Paste";
    public static final String DELETE_ACTION = "Delete";
    public static final KeyStroke PASTE_ACCEL = KeyStroke.getKeyStroke(86, 128);
    public static final KeyStroke COPY_ACCEL = KeyStroke.getKeyStroke(67, 128);
    public static final KeyStroke CUT_ACCEL = KeyStroke.getKeyStroke(88, 128);
    public static final KeyStroke DELETE_ACCEL = KeyStroke.getKeyStroke(127, 0);
    private static final int ROW_UP = -1;
    private static final int ROW_DOWN = 1;
    public static final int CAN_SORT_NONE = 1;
    public static final int CAN_SORT_ASCENDING = 2;
    public static final int CAN_SORT_DESCENDING = 4;
    public static final int CAN_SORT_ALL = 7;
    public static final int CAN_ADD_ROW = 8;
    public static final int SHOW_ROW_HEADERS = 16;
    public static final int CAN_REMOVE_ROW = 32;
    public static final int ASCENDING = 1;
    public static final int DESCENDING = 2;
    public static final int NONE = 0;
    private static DataFlavor GUITABLE_DATA_FLAVOR = new DataFlavor(TableObjectSelection.class, "guiTable Object Selection");
    private RemoveRowCmd d_removeRowCmd;
    private InsertRowCmd d_insertRowCmd;
    private MoveRowUpCmd d_moveRowUpCmd;
    private MoveRowDownCmd d_moveRowDownCmd;
    private EnableSortCmd d_enableSortCmd;
    private CutCmd d_cutCmd;
    private CopyCmd d_copyCmd;
    private PasteCmd d_pasteCmd;
    private DeleteCmd d_deleteCmd;
    private TableModel d_baseModel;
    private SortMod d_sortMod = new SortMod();
    private HashMap<TableColumn, guiTableClipboard> d_clipboards;
    private guiTableClipboard d_defaultClipboard;
    private TableModelValidator d_validator;
    private boolean d_canAddRow;
    private boolean d_showRowHeaders;
    private JTable d_rowHeader;
    private boolean d_canResize;
    private Object[] d_tempRowValues;
    private boolean d_addRowModified;
    private int d_sortOptions;
    private int d_lastSortColumn;
    private boolean d_delaySort;
    private int d_rowLimit = Integer.MAX_VALUE;
    private boolean d_popup;
    private boolean d_nullValuesAllowed;
    private boolean d_isModified;
    private final BitOptions d_options;
    private Set<Integer> d_uneditableCols;
    public static final String COL_SEPARATOR = "\t";
    public static final String ROW_SEPARATOR = "\n";

    public guiTable() {
        this((TableModel)new guiDefaultTableModel(), 6);
    }

    public guiTable(TableModel model, int options) {
        super(model);
        this.d_options = new BitOptions(options);
        this.d_nullValuesAllowed = true;
        this.d_uneditableCols = new HashSet<Integer>();
        this.getTableHeader().setReorderingAllowed(false);
        this.setColumnSelectionAllowed(true);
        boolean bl = this.d_canAddRow = (options & 8) > 0;
        if (this.d_canAddRow && !this.d_canResize) {
            throw new IllegalArgumentException("model must implement ResizableTableModel if canAddRow==true");
        }
        if (this.d_canAddRow) {
            this.getTableHeader().setReorderingAllowed(false);
        }
        this.d_rowHeader = new guiRowHeader(this);
        this.d_showRowHeaders = (options & 0x10) > 0;
        this.d_sortOptions = options & 7;
        if (this.d_sortOptions > 0) {
            this.getTableHeader().addMouseListener(new SortListener(this));
        }
        this.addMouseListener(new ContextMenuListener(this));
        this.d_clipboards = new HashMap();
        this.d_defaultClipboard = new DefaultTableClipboard();
        this.d_validator = null;
        this.allocateTempRowValues();
        this.d_popup = true;
        this.setDefaultEditor(Double.class, new guiDoubleEditor());
        this.setDefaultRenderer(Double.class, new guiDoubleRenderer());
        this.setDefaultRenderer(UnitDouble.class, new UnitDoubleRenderer());
        ColorTableCell colorCell = new ColorTableCell();
        this.setDefaultRenderer(Color.class, colorCell);
        this.setDefaultEditor(Color.class, colorCell);
        this.d_removeRowCmd = new RemoveRowCmd();
        this.d_insertRowCmd = new InsertRowCmd();
        this.d_moveRowUpCmd = new MoveRowUpCmd();
        this.d_moveRowDownCmd = new MoveRowDownCmd();
        this.d_enableSortCmd = new EnableSortCmd();
        this.d_cutCmd = new CutCmd();
        this.d_copyCmd = new CopyCmd();
        this.d_pasteCmd = new PasteCmd();
        this.d_deleteCmd = new DeleteCmd();
        this.setSortOrder(this.getNextAllowedSortOption(true));
        InputMap im = this.getInputMap();
        ActionMap am = this.getActionMap();
        im.put((KeyStroke)this.getPasteCommand().getValue("AcceleratorKey"), PASTE_ACTION);
        am.put(PASTE_ACTION, this.getPasteCommand());
        im.put((KeyStroke)this.getCopyCommand().getValue("AcceleratorKey"), COPY_ACTION);
        am.put(COPY_ACTION, this.getCopyCommand());
        im.put((KeyStroke)this.getCutCommand().getValue("AcceleratorKey"), CUT_ACTION);
        am.put(CUT_ACTION, this.getCutCommand());
        im.put((KeyStroke)this.getDeleteCommand().getValue("AcceleratorKey"), DELETE_ACTION);
        am.put(DELETE_ACTION, this.getDeleteCommand());
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.updateColumnHeaders();
    }

    public void forceColumnUpdate() {
        this.updateColumnHeaders();
        super.configureEnclosingScrollPane();
    }

    public void setNullValuesAllowed(boolean allowed) {
        this.d_nullValuesAllowed = allowed;
    }

    public boolean getNullValuesAllowed() {
        return this.d_nullValuesAllowed;
    }

    private void allocateTempRowValues() {
        this.d_tempRowValues = this.allocateRow();
        this.d_addRowModified = false;
    }

    private Object[] allocateRow() {
        int numCols = this.getColumnModel().getColumnCount();
        return new Object[numCols];
    }

    public int autoSizeColumns() {
        return this.autoSizeColumns(true, this.getPreferredScrollableViewportSize().height);
    }

    public int autoSizeColumns(int preferredScrollHeight) {
        return this.autoSizeColumns(true, preferredScrollHeight);
    }

    public int autoSizeColumns(boolean includeTableValues) {
        return this.autoSizeColumns(true, this.getPreferredScrollableViewportSize().height);
    }

    public int autoSizeColumns(boolean includeTableValues, int preferredScrollHeight) {
        JLabel tempLabel = new JLabel();
        for (int col = 0; col < this.getColumnCount(); ++col) {
            TableColumn tc = this.getColumnModel().getColumn(col);
            TableCellRenderer headerRenderer = tc.getHeaderRenderer();
            Object headerObject = tc.getHeaderValue();
            int preferredWidth = 0;
            if (headerRenderer != null) {
                Component c = headerRenderer.getTableCellRendererComponent(null, tc.getHeaderValue(), false, false, 0, 0);
                preferredWidth = c.getPreferredSize().width;
            } else if (headerObject instanceof String) {
                tempLabel.setText((String)headerObject);
                preferredWidth = tempLabel.getPreferredSize().width + 20;
            }
            if (includeTableValues) {
                for (int row = 0; row < this.getRowCount(); ++row) {
                    Component c;
                    TableCellEditor editor;
                    Component c2;
                    Object value = this.getValueAt(row, col);
                    TableCellRenderer renderer = this.getCellRenderer(row, col);
                    if (renderer != null && (c2 = renderer.getTableCellRendererComponent(this, value, false, false, row, col)) != null) {
                        preferredWidth = Math.max(preferredWidth, c2.getPreferredSize().width + 20);
                    }
                    if ((editor = this.getCellEditor(row, col)) == null || (c = editor.getTableCellEditorComponent(this, value, false, row, col)) == null) continue;
                    preferredWidth = Math.max(preferredWidth, c.getPreferredSize().width + 20);
                }
            }
            tc.setPreferredWidth(preferredWidth);
        }
        this.setPreferredScrollableViewportSize(new Dimension(this.getPreferredSize().width, preferredScrollHeight));
        return this.getPreferredSize().width;
    }

    public Object[] getRowData(int row) {
        if (this.isAddRow(row)) {
            return this.d_tempRowValues;
        }
        if (row < 0 || row >= this.getRowCount()) {
            return null;
        }
        Object[] result = new Object[this.getColumnCount()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.getValueAt(row, i);
        }
        return result;
    }

    public boolean isAddRow(int row) {
        int modelRows = super.getRowCount();
        return this.d_canAddRow && row == modelRows && ((ResizableTableModel)this.d_baseModel).getMaxRows() > modelRows && row < this.d_rowLimit;
    }

    public void setRowLimit(int rowLimit) {
        this.d_rowLimit = rowLimit;
    }

    @Override
    public void setModel(TableModel model) {
        if (this.d_sortMod == null) {
            this.d_sortMod = new SortMod();
        }
        this.d_baseModel = model;
        this.d_canResize = this.d_baseModel instanceof ResizableTableModel;
        this.resort();
        super.setModel(this.d_baseModel);
    }

    @Override
    protected void configureEnclosingScrollPane() {
        Container gp;
        super.configureEnclosingScrollPane();
        if (!this.d_showRowHeaders) {
            return;
        }
        Container p = this.getParent();
        if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)gp;
            JViewport viewport = scrollPane.getViewport();
            if (viewport == null || viewport.getView() != this) {
                return;
            }
            scrollPane.setRowHeaderView(this.getRowHeader());
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.d_rowHeader != null) {
            this.d_rowHeader.setEnabled(enabled);
        }
        if (this.getTableHeader() != null) {
            this.getTableHeader().setEnabled(enabled);
        }
        super.setEnabled(enabled);
    }

    @Override
    public Color getBackground() {
        if (this.isEnabled()) {
            return super.getBackground();
        }
        Container parent = this.getParent();
        return parent != null ? parent.getBackground() : null;
    }

    @Override
    public void setRowHeight(int row, int rowHeight) {
        super.setRowHeight(row, rowHeight);
        if (this.d_rowHeader != null) {
            this.d_rowHeader.setRowHeight(row, rowHeight);
        }
    }

    @Override
    public void setRowHeight(int rowHeight) {
        super.setRowHeight(rowHeight);
        if (this.d_rowHeader != null) {
            this.d_rowHeader.setRowHeight(rowHeight);
        }
    }

    @Override
    public void setRowMargin(int rowMargin) {
        super.setRowMargin(rowMargin);
        if (this.d_rowHeader != null) {
            this.d_rowHeader.setRowMargin(rowMargin);
        }
    }

    @Override
    public JPopupMenu getContextMenu(MouseEvent e) {
        if (!this.isEnabled() || !this.d_popup) {
            return null;
        }
        int row = this.rowAtPoint(e.getPoint());
        int col = this.columnAtPoint(e.getPoint());
        if (row >= 0 && col >= 0 && !this.isCellSelected(row, col)) {
            this.setRowSelectionInterval(row, row);
            this.setColumnSelectionInterval(col, col);
        }
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(this.d_cutCmd);
        commands.add(this.d_copyCmd);
        commands.add(this.d_pasteCmd);
        if (this.canAddRow()) {
            commands.add(this.d_insertRowCmd);
            commands.add(this.d_removeRowCmd);
            commands.add(this.d_moveRowUpCmd);
            commands.add(this.d_moveRowDownCmd);
        } else if (this.d_options.get(32L)) {
            commands.add(this.d_removeRowCmd);
        }
        return ContextMenu.menuFromCommands(commands.toArray(new Command[commands.size()]));
    }

    public void setAllowPopup(boolean b) {
        this.d_popup = b;
    }

    public boolean canAddRow() {
        return this.d_canAddRow;
    }

    public Component getRowHeader() {
        return this.d_rowHeader;
    }

    @Override
    public int getRowCount() {
        int numRows = super.getRowCount();
        if (this.isAddRow(numRows)) {
            ++numRows;
        }
        return numRows;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.isAddRow(row)) {
            return this.d_tempRowValues[col];
        }
        return super.getValueAt(row, col);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if ("".equals(value)) {
            value = null;
        }
        if (this.isAddRow(row)) {
            this.d_tempRowValues[col] = value;
            this.d_addRowModified = value != null;
            this.repaint(this.getCellRect(row, col, true));
        } else {
            super.setValueAt(value, row, col);
        }
    }

    @Override
    public int convertColumnIndexToModel(int viewColumnIndex) {
        if (viewColumnIndex >= this.getColumnModel().getColumnCount() && this.d_canResize) {
            return viewColumnIndex;
        }
        return super.convertColumnIndexToModel(viewColumnIndex);
    }

    public RemoveRowCmd getRemoveRowCommand() {
        return this.d_removeRowCmd;
    }

    public InsertRowCmd getInsertRowCommand() {
        return this.d_insertRowCmd;
    }

    public MoveRowUpCmd getMoveRowUpCommand() {
        return this.d_moveRowUpCmd;
    }

    public MoveRowDownCmd getMoveRowDownCommand() {
        return this.d_moveRowDownCmd;
    }

    public EnableSortCmd getEnableSortCommand() {
        return this.d_enableSortCmd;
    }

    private Object[][] convertToObjArr2(int[][] iArr2) {
        if (iArr2 == null || iArr2.length == 0) {
            return new Integer[0][0];
        }
        if (iArr2[0] == null) {
            Object[][] out = new Integer[iArr2.length][0];
            return out;
        }
        Object[][] out = new Integer[iArr2.length][iArr2[0].length];
        for (int i = 0; i < out.length; ++i) {
            for (int j = 0; j < out[0].length; ++j) {
                out[i][j] = iArr2[i][j];
            }
        }
        return out;
    }

    private Object[][] convertToObjArr2(double[][] dArr2) {
        if (dArr2 == null || dArr2.length == 0) {
            return new Double[0][0];
        }
        if (dArr2[0] == null) {
            Object[][] out = new Double[dArr2.length][0];
            return out;
        }
        Object[][] out = new Double[dArr2.length][dArr2[0].length];
        for (int i = 0; i < out.length; ++i) {
            for (int j = 0; j < out[0].length; ++j) {
                out[i][j] = dArr2[i][j];
            }
        }
        return out;
    }

    public static double[][] transpose(double[][] dArr) {
        if (dArr == null || dArr[0] == null) {
            return dArr;
        }
        double[][] tmp = new double[dArr[0].length][dArr.length];
        for (int i = 0; i < dArr.length; ++i) {
            for (int j = 0; j < dArr[0].length; ++j) {
                tmp[j][i] = dArr[i][j];
            }
        }
        return tmp;
    }

    protected void lockSort() {
        this.d_delaySort = true;
    }

    protected void freeSort() {
        this.d_delaySort = false;
    }

    public void moveRows(int direction) {
        int[] rows = this.getSelectedRows();
        if (rows.length == 0) {
            return;
        }
        int lastRow = rows.length - 1;
        Object[][] rowData = new Object[rows.length][];
        Arrays.sort(rows);
        if (direction == -1 && rows[0] == 0 || direction == 1 && (rows[lastRow] == this.getRowCount() - 1 || this.isAddRow(rows[lastRow] + 1))) {
            return;
        }
        if (this.d_canResize) {
            int currRow;
            ResizableTableModel mod = (ResizableTableModel)this.d_baseModel;
            if (this.isAddRow(rows[lastRow])) {
                --lastRow;
            }
            for (currRow = lastRow; currRow >= 0; --currRow) {
                rowData[currRow] = this.getRowData(rows[currRow]);
                mod.removeRow(rows[currRow]);
            }
            for (currRow = 0; currRow <= lastRow; ++currRow) {
                mod.insertRow(rows[currRow] + direction, rowData[currRow]);
            }
            ListSelectionModel lsm = this.getSelectionModel();
            int mode = lsm.getSelectionMode();
            if (mode == 0) {
                this.setRowSelectionInterval(rows[0] + direction, rows[0] + direction);
            } else if (mode == 1) {
                this.setRowSelectionInterval(rows[0] + direction, rows[lastRow] + direction);
            } else if (mode == 2) {
                for (int i = 0; i <= lastRow; ++i) {
                    lsm.addSelectionInterval(rows[i] + direction, rows[i] + direction);
                }
            }
        } else {
            throw new RuntimeException("It should be possible to move rows on a non-resizable guiTable, but that option is not currently implemented.");
        }
    }

    public guiTableClipboard getClipboard(int viewColumn) {
        assert (viewColumn >= 0 && viewColumn < this.getColumnCount());
        TableColumn column = this.getColumnModel().getColumn(viewColumn);
        guiTableClipboard cb = this.d_clipboards.get(column);
        if (cb == null) {
            return this.d_defaultClipboard;
        }
        return cb;
    }

    public void setClipboard(Class columnClass, guiTableClipboard cb) {
        for (int m = 0; m < this.getColumnCount(); ++m) {
            if (!this.getColumnClass(m).equals(columnClass)) continue;
            this.setClipboard(m, cb);
        }
    }

    public void setClipboard(int viewColumn, guiTableClipboard cb) {
        assert (viewColumn >= 0 && viewColumn < this.getColumnCount());
        TableColumn column = this.getColumnModel().getColumn(viewColumn);
        this.d_clipboards.put(column, cb);
    }

    public <T> void setColumnOptions(int column, T ... options) {
        this.setColumnOptions(column, (Collection<T>)Arrays.asList(options));
    }

    public <T> void setColumnOptions(int column, Collection<T> options) {
        ComboBoxTableCell<T> cell = new ComboBoxTableCell<T>(options);
        this.setClipboard(column, (guiTableClipboard)new LimitedTableClipboard(options));
        this.getColumnModel().getColumn(column).setCellRenderer(cell);
        this.getColumnModel().getColumn(column).setCellEditor(cell);
    }

    protected static TableObjectSelection getClipboardContents(Transferable contents) {
        TableObjectSelection data = null;
        try {
            data = (TableObjectSelection)contents.getTransferData(GUITABLE_DATA_FLAVOR);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (UnsupportedFlavorException udfe) {
            try {
                String clipboardText = (String)contents.getTransferData(DataFlavor.stringFlavor);
                data = guiTable.parsePastedString(clipboardText);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            catch (UnsupportedFlavorException udfe2) {
                udfe2.printStackTrace();
            }
        }
        return data;
    }

    private static TableObjectSelection parsePastedString(String str) {
        TableObjectSelection objSel = new TableObjectSelection();
        int rowIx = 0;
        for (String row : str.split(ROW_SEPARATOR)) {
            guiTable.parsePastedRowString(objSel, row, rowIx);
            ++rowIx;
        }
        return objSel;
    }

    private static void parsePastedRowString(TableObjectSelection objSel, String str, int row) {
        int col = 0;
        String lastColToken = "";
        String currColToken = "";
        StringTokenizer columns = new StringTokenizer(str, COL_SEPARATOR, true);
        while (columns.hasMoreTokens()) {
            currColToken = columns.nextToken();
            if (currColToken.equals(COL_SEPARATOR)) {
                if (lastColToken.equals(COL_SEPARATOR)) {
                    objSel.setObject(row, col, (Serializable)((Object)""));
                } else {
                    objSel.setObject(row, col, (Serializable)((Object)lastColToken));
                }
                ++col;
            }
            lastColToken = currColToken;
        }
        if (!lastColToken.equals(COL_SEPARATOR)) {
            objSel.setObject(row, col, (Serializable)((Object)lastColToken));
        }
    }

    public boolean copy() {
        int[] selCols = this.getSelectedColumns();
        int[] selRows = this.getSelectedRows();
        if (selCols.length == 0 || selRows.length == 0) {
            return false;
        }
        Arrays.sort(selRows);
        Arrays.sort(selCols);
        TableObjectSelection objRep = new TableObjectSelection();
        for (int row : selRows) {
            for (int col : selCols) {
                Object value = this.getValueAt(row, col);
                if (!(value instanceof Serializable) && value != null) continue;
                objRep.setObject(row, col, (Serializable)value);
            }
        }
        StringBuilder strRep = new StringBuilder();
        int firstRow = selRows[0];
        int lastRow = selRows[selRows.length - 1];
        int firstCol = selCols[0];
        int lastCol = selCols[selCols.length - 1];
        for (int row = firstRow; row <= lastRow; ++row) {
            for (int col = firstCol; col <= lastCol; ++col) {
                Object value = this.getValueAt(row, col);
                if (value != null) {
                    strRep.append(value);
                }
                strRep.append(COL_SEPARATOR);
            }
            strRep.append(ROW_SEPARATOR);
        }
        ObjectSelection sel = new ObjectSelection(objRep, strRep.toString(), GUITABLE_DATA_FLAVOR);
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            cb.setContents(sel, sel);
        }
        catch (IllegalStateException e) {
            guiUtil.showError(Application.getApp(), Intl.intl("Clipboard Unavailable"), Intl.intl("The clipboard is unavailable."), (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean cut() {
        this.copy();
        this.delete();
        return true;
    }

    public void paste() {
        int pasteRow = this.getSelectedRow();
        int pasteCol = this.getSelectedColumn();
        if (pasteRow < 0) {
            pasteRow = 0;
        }
        if (pasteCol < 0) {
            pasteCol = 0;
        }
        this.lockSort();
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            TableObjectSelection objSel = guiTable.getClipboardContents(clipboard.getContents(this));
            if (objSel == null) {
                return;
            }
            Set<Integer> rows = objSel.getAvailableRows();
            if (rows.isEmpty()) {
                return;
            }
            Vector<Integer[]> noPasteCells = new Vector<Integer[]>();
            int firstRow = rows.iterator().next();
            int firstCol = objSel.getObjectsForRow(firstRow).keySet().iterator().next();
            for (int row : rows) {
                Map<Integer, Serializable> colMap = objSel.getObjectsForRow(row);
                Iterator<Integer> iterator = colMap.keySet().iterator();
                for (Serializable obj : colMap.values()) {
                    boolean pasted;
                    int col = iterator.next();
                    int curPasteRow = row - firstRow + pasteRow;
                    int curPasteCol = col - firstCol + pasteCol;
                    if (curPasteRow >= this.getRowCount() || curPasteCol >= this.getColumnCount() || !this.isCellEditable(curPasteRow, curPasteCol) || (pasted = this.pasteData(obj, curPasteRow, curPasteCol))) continue;
                    noPasteCells.add(new Integer[]{curPasteRow, curPasteCol});
                }
            }
            this.revalidate();
            this.repaint();
            if (!noPasteCells.isEmpty()) {
                Object[] messages = new String[noPasteCells.size()];
                int index = 0;
                for (Integer[] integerArray : noPasteCells) {
                    assert (integerArray.length == 2);
                    messages[index++] = this.formatCellName(integerArray[0], integerArray[1]);
                }
                Arrays.sort(messages);
                StringBuilder message = new StringBuilder(Intl.intl("The copied values could not be pasted into the following cells:") + ROW_SEPARATOR);
                for (Object mes : messages) {
                    message.append((String)mes);
                    message.append(ROW_SEPARATOR);
                }
                Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, this);
                JOptionPane.showMessageDialog(window, message.toString(), Intl.intl("Paste Warning"), 2);
            }
            this.freeSort();
            this.resort();
        }
        catch (IllegalStateException e) {
            guiUtil.showError(Application.getApp(), Intl.intl("Clipboard Unavailable."), Intl.intl("The clipboard is unavailable."), (Throwable)e);
            return;
        }
    }

    private String formatCellName(int row, int col) {
        try {
            Object headerVal = this.getColumnModel().getColumn(col).getHeaderValue();
            return String.format(Intl.intl("Column \"%s\", Row %d"), headerVal, row + 1);
        }
        catch (Exception e) {
            return String.format(Intl.intl("Column %1$d, Row %2$d"), col + 1, row + 1);
        }
    }

    private boolean pasteData(Object data, int row, int col) {
        if (this.d_canResize || this.isInTable(row, col)) {
            guiTableClipboard cb = this.getClipboard(col);
            return cb.pasteObject(this, data, row, col);
        }
        return true;
    }

    private boolean isInTable(int row, int col) {
        return row >= 0 && row < this.getRowCount() && col >= 0 && col < this.getColumnCount();
    }

    public DeleteCmd getDeleteCommand() {
        return this.d_deleteCmd;
    }

    public CutCmd getCutCommand() {
        return this.d_cutCmd;
    }

    public CopyCmd getCopyCommand() {
        return this.d_copyCmd;
    }

    public PasteCmd getPasteCommand() {
        return this.d_pasteCmd;
    }

    @Override
    public int convertRowIndexToView(int modelRowIndex) {
        return this.d_sortMod.getSortIndex(modelRowIndex);
    }

    @Override
    public int convertRowIndexToModel(int viewRowIndex) {
        return this.d_sortMod.getModelIndex(viewRowIndex);
    }

    public int getSortOrder() {
        return this.d_sortMod.getSortOrder();
    }

    public void setSortOrder(int sortOrder) {
        if (this.isSortOrderAllowed(sortOrder)) {
            this.resortDir(sortOrder);
            this.updateColumnHeaders();
        }
    }

    public boolean isSortOrderAllowed(int sortOrder) {
        return sortOrder == 0 && (this.d_sortOptions & 1) > 0 || sortOrder == 1 && (this.d_sortOptions & 2) > 0 || sortOrder == 2 && (this.d_sortOptions & 4) > 0;
    }

    public boolean setSortColumn(int colIndex) {
        if (!this.getCanSortColumn(colIndex)) {
            return false;
        }
        this.d_lastSortColumn = this.d_sortMod.getSortColumn();
        this.resortCol(colIndex);
        this.updateColumnHeaders();
        return true;
    }

    public boolean getCanSortColumn(int colIndex) {
        Class<?> clazz = this.getColumnClass(colIndex);
        return Comparable.class.isAssignableFrom(clazz);
    }

    public int getSortColumn() {
        return this.d_sortMod.getSortColumn();
    }

    private void updateColumnHeaders() {
        TableColumn column;
        if (this.d_sortOptions == 0) {
            return;
        }
        if (this.getTableHeader() == null) {
            System.out.println("Warning: null TableHeader, can't update.");
            return;
        }
        int oldViewCol = this.convertColumnIndexToView(this.d_lastSortColumn);
        int viewCol = this.convertColumnIndexToView(this.d_sortMod.getSortColumn());
        if (oldViewCol >= 0) {
            column = this.getColumnModel().getColumn(oldViewCol);
            column.setHeaderRenderer(null);
        }
        if (viewCol >= 0) {
            column = this.getColumnModel().getColumn(viewCol);
            if (this.d_sortMod.getSortOrder() == 1) {
                column.setHeaderRenderer(HEADER_UP);
            } else if (this.d_sortMod.getSortOrder() == 2) {
                column.setHeaderRenderer(HEADER_DOWN);
            }
        }
        this.getTableHeader().repaint();
    }

    private void resort() {
        this.resort(this.d_baseModel, this.d_sortMod.getSortColumn(), this.d_sortMod.getSortOrder());
    }

    private void resortCol(int col) {
        this.resort(this.d_baseModel, col, this.d_sortMod.getSortOrder());
    }

    private void resortDir(int dir) {
        this.resort(this.d_baseModel, this.d_sortMod.getSortColumn(), dir);
    }

    private void resort(TableModel mod, int column, int dir) {
        int newRow;
        int oldSelection = this.getSelectedRow();
        oldSelection = this.convertRowIndexToModel(oldSelection);
        this.d_sortMod.sort(mod, column, dir);
        if (oldSelection >= 0 && (newRow = this.convertRowIndexToView(oldSelection)) >= 0 && this.getRowCount() > 0) {
            super.setRowSelectionInterval(newRow, newRow);
        }
    }

    private int getNextAllowedSortOption(boolean reset) {
        int currOption = this.getSortOrder();
        if (reset) {
            currOption = 0;
        }
        int nextOption = this.getNextSortOption(currOption);
        while (nextOption != currOption) {
            if (this.isSortOrderAllowed(nextOption)) {
                return nextOption;
            }
            nextOption = this.getNextSortOption(nextOption);
        }
        return 0;
    }

    private int getNextSortOption(int currOption) {
        if (currOption == 0) {
            return 1;
        }
        if (currOption == 1) {
            return 2;
        }
        return 0;
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if ((e.getKeyCode() == 10 || e.getKeyCode() == 9 && this.getSelectedColumn() == this.getColumnCount() - 1) && !ks.isOnKeyRelease() && this.isAddRow(this.getSelectedRow()) && (this.addRowIsModified() || this.isEditing())) {
            this.validateData(false, true);
            return true;
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    public void delete() {
        this.requestFocus();
        this.lockSort();
        boolean modified = false;
        int[] selRows = this.getSelectedRows();
        int[] selCols = this.getSelectedColumns();
        for (int r : selRows) {
            for (int c : selCols) {
                Object existing;
                if (!this.isCellEditable(r, c) || (existing = this.getValueAt(r, c)) == null) continue;
                modified = true;
                this.setValueAt(null, r, c);
            }
        }
        this.freeSort();
        if (modified) {
            this.resort();
        }
    }

    public void setColumnEditable(int col, boolean editable) {
        if (!editable) {
            this.d_uneditableCols.add(col);
        } else {
            this.d_uneditableCols.remove(col);
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return super.isCellEditable(row, column) && !this.d_uneditableCols.contains(column);
    }

    private boolean addRowIsModified() {
        return this.d_addRowModified;
    }

    public void clearRows() {
        if (this.isEditing()) {
            this.removeEditor();
        }
        int[] rowIxs = IntStream.range(0, this.getRowCount()).toArray();
        this.removeRows(rowIxs);
    }

    public void removeRowsGreaterThan(int row, boolean inclusive) {
        int start = inclusive ? row : row + 1;
        int numRows = this.getRowCount();
        int[] rowIxs = IntStream.range(start, numRows).toArray();
        this.removeRows(rowIxs);
    }

    public void removeRows(int[] rows) {
        if (!this.d_canResize) {
            return;
        }
        ResizableTableModel mod = (ResizableTableModel)this.d_baseModel;
        if (rows.length == 0) {
            return;
        }
        Arrays.sort(rows);
        int currRow = rows.length - 1;
        int editingRow = this.getEditingRow();
        if (this.isAddRow(rows[currRow])) {
            this.allocateTempRowValues();
            this.repaint();
            --currRow;
        }
        int[] modelRows = new int[currRow + 1];
        for (int i = 0; i < modelRows.length; ++i) {
            modelRows[i] = this.convertRowIndexToModel(rows[i]);
            if (rows[i] != editingRow) continue;
            this.getCellEditor().cancelCellEditing();
        }
        Arrays.sort(modelRows);
        while (currRow >= 0) {
            mod.removeRow(modelRows[currRow]);
            --currRow;
        }
        if (rows[0] >= 0 && rows[0] < this.getRowCount()) {
            this.setRowSelectionInterval(rows[0], rows[0]);
        }
        this.resort();
    }

    public void removeSelectedRows() {
        this.removeRows(this.getSelectedRows());
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (allowModify) {
            TableCellEditor ed = this.getCellEditor();
            if (ed != null && !ed.stopCellEditing()) {
                int r = this.getEditingRow();
                int c = this.getEditingColumn();
                String msg = String.format(Intl.intl("Invalid value in cell, [%s]."), this.formatCellName(r, c));
                this.flagInvalidCell(r, c, showWarn, allowModify, msg);
                return false;
            }
            if (this.d_canAddRow && this.d_canResize && this.d_addRowModified) {
                ResizableTableModel mod = (ResizableTableModel)this.d_baseModel;
                mod.insertRow(this.getRowCount() - 1, this.d_tempRowValues);
                this.allocateTempRowValues();
                this.setRowSelectionInterval(this.getRowCount() - 1, this.getRowCount() - 1);
                if (this.getSelectedColumn() == this.getColumnCount() - 1) {
                    this.setColumnSelectionInterval(0, 0);
                }
            }
        }
        if (!this.d_nullValuesAllowed) {
            TableModel model = this.getModel();
            for (int row = 0; row < model.getRowCount(); ++row) {
                for (int col = 0; col < model.getColumnCount(); ++col) {
                    if (model.getValueAt(row, col) != null) continue;
                    String msg = String.format(Intl.intl("Error: Blank value in cell, [%s]."), this.formatCellName(row, col));
                    this.flagInvalidCell(row, col, showWarn, allowModify, msg);
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        super.tableChanged(e);
        if (e.getFirstRow() == -1) {
            this.allocateTempRowValues();
        }
        if (!this.d_delaySort) {
            this.resort();
        }
        if (this.d_rowHeader != null) {
            this.d_rowHeader.revalidate();
            this.d_rowHeader.repaint();
        }
        this.d_isModified = true;
    }

    @Override
    public void setRowSelectionInterval(int index0, int index1) {
        super.setRowSelectionInterval(index0, index1);
    }

    @Override
    public Component prepareEditor(TableCellEditor editor, int row, int column) {
        Component c = super.prepareEditor(editor, row, column);
        if (c instanceof JTextComponent) {
            ((JTextComponent)c).selectAll();
        }
        c.setEnabled(this.isEnabled());
        return c;
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component c = super.prepareRenderer(renderer, row, column);
        c.setEnabled(this.isEnabled());
        return c;
    }

    @Override
    public boolean getSurrendersFocusOnKeystroke() {
        return this.getEditorComponent() instanceof JComboBox;
    }

    public void flagInvalidCell(int row, int col, boolean showWarn, boolean allowModify, String msg) {
        if (allowModify) {
            Pair<JTabbedPane, Component> tabPane = guiUtil.findTab(this);
            if (tabPane != null) {
                ((JTabbedPane)tabPane.v1).setSelectedComponent((Component)tabPane.v2);
            }
            this.requestFocus();
            if (this.getRowSelectionAllowed()) {
                if (row == -1) {
                    this.setRowSelectionInterval(0, this.getRowCount() - 1);
                } else {
                    this.setRowSelectionInterval(row, row);
                }
            }
            if (this.getColumnSelectionAllowed()) {
                if (col == -1) {
                    this.setColumnSelectionInterval(0, this.getColumnCount() - 1);
                } else {
                    this.setColumnSelectionInterval(col, col);
                }
            }
        }
        if (showWarn) {
            Window parent = (Window)SwingUtilities.getAncestorOfClass(Window.class, this);
            guiDialog.showInvalidEntryMessage(parent, msg);
        }
    }

    public void addValueChangedListener(String prop) {
        this.getModel().addTableModelListener(e -> this.firePropertyChange(prop, null, null));
    }

    @Override
    public boolean isModified() {
        return this.d_isModified;
    }

    @Override
    public void setModified(boolean modified) {
        this.d_isModified = modified;
    }

    class SortListener
    extends MouseAdapter {
        private guiTable d_guiTable;

        public SortListener(guiTable table) {
            this.d_guiTable = table;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!this.d_guiTable.isEnabled()) {
                return;
            }
            if (!guiTable.this.validateData(true, true)) {
                return;
            }
            int sortColIndex = this.d_guiTable.getSortColumn();
            int viewCol = this.d_guiTable.getColumnModel().getColumnIndexAtX(e.getX());
            int modCol = this.d_guiTable.convertColumnIndexToModel(viewCol);
            if (this.d_guiTable.setSortColumn(modCol)) {
                this.d_guiTable.setSortOrder(this.d_guiTable.getNextAllowedSortOption(modCol != sortColIndex));
                this.d_guiTable.repaint();
            }
        }
    }

    public static class UnitDoubleEditor
    extends DefaultCellEditor {
        private final Unit d_unit;
        private UnitDouble d_ud;
        private Predicate<UnitDouble> d_filter;
        private boolean d_nullAllowed;

        public UnitDoubleEditor(Unit unit) {
            this(unit, Filters.acceptAll(), true);
        }

        public UnitDoubleEditor(Unit unit, Predicate<UnitDouble> filter, boolean nullAllowed) {
            super(new JTextField());
            this.d_unit = unit;
            this.d_filter = filter;
            ((JTextField)this.getComponent()).setHorizontalAlignment(4);
        }

        public void setNullAllowed(boolean allowed) {
            this.d_nullAllowed = allowed;
        }

        public void setFilter(Predicate<UnitDouble> filter) {
            this.d_filter = filter;
        }

        public Unit getDefaultUnit() {
            return this.d_unit;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            UnitDouble ud;
            this.d_ud = ud = (UnitDouble)value;
            String text = ud == null ? "" : Global.format(ud);
            JComponent c = (JComponent)super.getTableCellEditorComponent(table, text, isSelected, row, column);
            c.setBorder(new LineBorder(Color.black));
            c.setToolTipText(null);
            return c;
        }

        @Override
        public boolean stopCellEditing() {
            JComponent c = (JComponent)this.getComponent();
            c.setBorder(new LineBorder(Color.black));
            c.setToolTipText(null);
            String s = (String)super.getCellEditorValue();
            try {
                UnitDouble ud = "".equals(s) ? null : Global.parseUnitDouble(s, this.d_unit);
                if (ud == null && !this.d_nullAllowed) {
                    throw new ParseException(Intl.intl("Empty values are not allowed."), 0);
                }
                if (ud != null && !this.d_filter.test(ud)) {
                    throw new ParseException(this.d_filter.toString(), 0);
                }
                this.d_ud = ud;
            }
            catch (ParseException e) {
                c.setBorder(new LineBorder(Color.red));
                c.setToolTipText(e.getLocalizedMessage());
                return false;
            }
            return super.stopCellEditing();
        }

        @Override
        public Object getCellEditorValue() {
            return this.d_ud;
        }
    }

    public static class UnitDoubleRenderer
    extends DefaultTableCellRenderer {
        public UnitDoubleRenderer() {
            this.setHorizontalAlignment(4);
        }

        @Override
        protected void setValue(Object value) {
            String text = value == null ? "" : Global.format((UnitDouble)value);
            this.setText(text);
        }
    }

    public static class guiDoubleRenderer
    extends DefaultTableCellRenderer {
        public guiDoubleRenderer() {
            this.setHorizontalAlignment(4);
        }

        @Override
        public void setValue(Object value) {
            this.setText(value == null ? "" : Global.format((Double)value));
        }
    }

    public static class guiDoubleEditor
    extends DefaultCellEditor {
        Object value;

        public guiDoubleEditor() {
            super(new JTextField());
            ((JTextField)this.getComponent()).setHorizontalAlignment(4);
        }

        @Override
        public boolean stopCellEditing() {
            String s = (String)super.getCellEditorValue();
            if ("".equals(s)) {
                this.value = null;
                return super.stopCellEditing();
            }
            try {
                this.value = Global.parseDouble(s);
            }
            catch (ParseException e) {
                ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.red));
                return false;
            }
            return super.stopCellEditing();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            JTextField c = (JTextField)this.getComponent();
            this.value = value;
            c.setText(value != null ? Global.format((Double)value) : "");
            c.setBorder(new LineBorder(Color.black));
            return c;
        }

        @Override
        public Object getCellEditorValue() {
            return this.value;
        }
    }

    protected static class TableObjectSelection
    implements Serializable {
        static final long serialVersionUID = 1L;
        private final TreeMap<Integer, Map<Integer, Serializable>> d_rowMap = new TreeMap();

        public void setObject(int row, int col, Serializable obj) {
            Map<Integer, Serializable> colMap = this.d_rowMap.get(row);
            if (colMap == null) {
                colMap = new TreeMap<Integer, Serializable>();
                this.d_rowMap.put(row, colMap);
            }
            colMap.put(col, obj);
        }

        public Set<Integer> getAvailableRows() {
            return this.d_rowMap.keySet();
        }

        public Map<Integer, Serializable> getObjectsForRow(int row) {
            return this.d_rowMap.get(row);
        }
    }

    private class PasteCmd
    extends TableCommand {
        public PasteCmd() {
            super(Intl.intl(guiTable.PASTE_ACTION), "graphics/Paste16.gif", PASTE_ACCEL, (e, t) -> t.paste());
        }
    }

    private class CopyCmd
    extends TableCommand {
        public CopyCmd() {
            super(Intl.intl(guiTable.COPY_ACTION), "graphics/Copy16.gif", COPY_ACCEL, (e, t) -> t.copy());
        }
    }

    private class CutCmd
    extends TableCommand {
        public CutCmd() {
            super(Intl.intl(guiTable.CUT_ACTION), "graphics/Cut16.gif", CUT_ACCEL, (e, t) -> t.cut());
        }
    }

    private class DeleteCmd
    extends TableCommand {
        public DeleteCmd() {
            super(Intl.intl(guiTable.DELETE_ACTION), "graphics/RowDelete16.gif", DELETE_ACCEL, (e, t) -> t.delete());
        }
    }

    private abstract class TableCommand
    extends CommandAction {
        private final BiConsumer<ActionEvent, guiTable> d_action;

        public TableCommand(String title, String icon, KeyStroke accel, BiConsumer<ActionEvent, guiTable> action) {
            super(title, icon);
            this.putValue("AcceleratorKey", accel);
            this.d_action = action;
        }

        @Override
        public boolean isEnabled() {
            return guiTable.this.isEnabled();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            WaitCursorMgr wcursor = new WaitCursorMgr(guiTable.this);
            wcursor.beginWaitCursor();
            try {
                this.d_action.accept(e, guiTable.this);
                guiTable.this.requestFocus();
            }
            finally {
                wcursor.endWaitCursor();
            }
        }
    }

    class EnableSortCmd
    extends AbstractCommand {
        private boolean d_sortAllowed;

        public EnableSortCmd() {
            super("Sort", null);
            this.d_sortAllowed = (guiTable.this.d_sortOptions & 6) > 0;
        }

        @Override
        public boolean isSelected() {
            return this.d_sortAllowed;
        }

        @Override
        public boolean isEnabled() {
            return guiTable.this.isEnabled();
        }

        @Override
        public void execute() {
            if (!this.isEnabled()) {
                return;
            }
            guiTable.this.requestFocus();
            if (this.d_sortAllowed) {
                this.d_sortAllowed = false;
                guiTable.this.d_sortOptions = 1;
                guiTable.this.setSortOrder(0);
            } else {
                this.d_sortAllowed = true;
                guiTable.this.d_sortOptions = guiTable.this.d_sortOptions | 7;
            }
            guiTable.this.repaint();
        }
    }

    class MoveRowDownCmd
    extends AbstractCommand {
        public MoveRowDownCmd() {
            super(Intl.intl("Move Down"), "graphics/Down16.gif");
        }

        @Override
        public boolean isEnabled() {
            return guiTable.this.isEnabled() && guiTable.this.getSortOrder() == 0;
        }

        @Override
        public void execute() {
            if (!this.isEnabled()) {
                return;
            }
            guiTable.this.requestFocus();
            guiTable.this.moveRows(1);
        }
    }

    class MoveRowUpCmd
    extends AbstractCommand {
        public MoveRowUpCmd() {
            super(Intl.intl("Move Up"), "graphics/Up16.gif");
        }

        @Override
        public boolean isEnabled() {
            return guiTable.this.isEnabled() && guiTable.this.getSortOrder() == 0;
        }

        @Override
        public void execute() {
            if (!this.isEnabled()) {
                return;
            }
            guiTable.this.requestFocus();
            guiTable.this.moveRows(-1);
        }
    }

    class RemoveRowCmd
    extends AbstractCommand {
        public RemoveRowCmd() {
            super(Intl.intl("Remove Row"), "graphics/RowDelete16.gif");
        }

        @Override
        public boolean isEnabled() {
            return guiTable.this.isEnabled();
        }

        @Override
        public void execute() {
            if (!this.isEnabled()) {
                return;
            }
            guiTable.this.requestFocus();
            guiTable.this.removeSelectedRows();
        }
    }

    class InsertRowCmd
    extends AbstractCommand {
        public InsertRowCmd() {
            super(Intl.intl("Insert Row"), "graphics/RowInsertBefore16.gif");
        }

        @Override
        public boolean isEnabled() {
            return guiTable.this.isEnabled() && guiTable.this.getSortOrder() == 0;
        }

        @Override
        public void execute() {
            if (!this.isEnabled()) {
                return;
            }
            guiTable.this.requestFocus();
            if (!guiTable.this.d_canResize) {
                return;
            }
            int insertRow = guiTable.this.getSelectedRow();
            if (guiTable.this.isAddRow(insertRow) && (guiTable.this.d_addRowModified || guiTable.this.isEditing())) {
                guiTable.this.validateData(false, true);
                insertRow = guiTable.this.getRowCount() - 1;
            } else {
                TableCellEditor e;
                if (insertRow < 0) {
                    insertRow = guiTable.this.getRowCount() == 0 ? 0 : guiTable.this.getRowCount() - 1;
                }
                if ((e = guiTable.this.getCellEditor()) != null) {
                    guiTable.this.getCellEditor().stopCellEditing();
                }
                ((ResizableTableModel)guiTable.this.d_baseModel).insertRow(insertRow, guiTable.this.allocateRow());
                guiTable.this.setRowSelectionInterval(insertRow, insertRow);
            }
        }
    }
}

