/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import thunderheadeng.gui.colorscheme.ColorButton;

public class ColorTableCell
extends AbstractCellEditor
implements TableCellEditor,
TableCellRenderer {
    private final ColorButton d_editor = new ColorButton(){

        @Override
        protected void editingFinished(boolean committed) {
            if (committed) {
                ColorTableCell.this.stopCellEditing();
            } else {
                ColorTableCell.this.cancelCellEditing();
            }
        }
    };
    private final ColorButton d_renderer = new ColorButton();
    private DefaultTableCellRenderer d_defaultRend = new DefaultTableCellRenderer();
    private DefaultCellEditor d_defaultEditor = new DefaultCellEditor(new JTextField());

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            return ((MouseEvent)anEvent).getClickCount() >= 2;
        }
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        return this.d_editor.getColor();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        Component sampleComp = this.d_defaultEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
        return this.getComponent(this.d_editor, sampleComp, table, value, row, column, true, true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component sampleComp = this.d_defaultRend.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        return this.getComponent(this.d_renderer, sampleComp, table, value, row, column, isSelected, hasFocus);
    }

    private Component getComponent(ColorButton component, Component defaultComp, JTable table, Object value, int row, int column, boolean isSelected, boolean hasFocus) {
        component.setColor((Color)value);
        component.setModified(false);
        Color bgColor = defaultComp.getBackground();
        Color fgColor = defaultComp.getForeground();
        Border border = BorderFactory.createEmptyBorder(0, 0, 0, 0);
        if (defaultComp instanceof JComponent) {
            border = ((JComponent)defaultComp).getBorder();
        }
        component.setContentAreaFilled(false);
        component.setBorder(border);
        component.setBackground(bgColor);
        component.setForeground(fgColor);
        component.setText("");
        return component;
    }
}

