/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui.print;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.util.ArrayList;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class PrintableDocument
implements Pageable,
Printable {
    View root;
    PageFormat format;
    double scalefactor;
    int numPages;
    double printX;
    double printY;
    double printWidth;
    double printHeight;
    Rectangle drawRect;
    static final double MARGIN_ADJUST = 0.97;
    static final Font headerFont = new Font("Serif", 0, 12);
    double pageStart = 0.0;
    ArrayList pageLengths = new ArrayList();
    ArrayList pageOffsets = new ArrayList();

    public PrintableDocument(JTextComponent textComponent) {
        this(textComponent, new PageFormat(), 0.75);
    }

    public PrintableDocument(JTextComponent textComponent, PageFormat format, double scalefactor) {
        this.format = format;
        this.scalefactor = scalefactor;
        this.printX = format.getImageableX() / scalefactor;
        this.printY = format.getImageableY() / scalefactor;
        this.printWidth = format.getImageableWidth() / scalefactor;
        this.printHeight = format.getImageableHeight() / scalefactor;
        Document document = textComponent.getDocument();
        Element rootElement = document.getDefaultRootElement();
        EditorKit editorKit = textComponent.getUI().getEditorKit(textComponent);
        ViewFactory viewFactory = editorKit.getViewFactory();
        this.root = viewFactory.create(rootElement);
        this.root.setParent(new ParentView(this.root, viewFactory, textComponent));
        this.root.setSize((float)this.printWidth, (float)this.printHeight);
        double documentHeight = this.root.getPreferredSpan(1);
        this.drawRect = new Rectangle(0, 0, (int)this.printWidth, (int)documentHeight);
        if (documentHeight > this.printHeight) {
            this.paginate(this.root, this.drawRect);
        }
        this.numPages = this.pageLengths.size() + 1;
    }

    protected void paginate(View v, Rectangle2D allocation) {
        double myheight = v.getPreferredSpan(1);
        v.setSize((float)this.printWidth, (float)myheight);
        int numkids = v.getViewCount();
        for (int i = 0; i < numkids; ++i) {
            View kid = v.getView(i);
            Shape kidshape = v.getChildAllocation(i, allocation);
            if (kidshape == null) continue;
            Rectangle2D kidbox = kidshape.getBounds2D();
            double kidpos = kidbox.getY() + kidbox.getHeight() - this.pageStart;
            if (numkids > 1 && i == 0) {
                if (kidpos < this.printY + this.printHeight * 0.97) continue;
                this.breakPage(kidbox.getY());
                continue;
            }
            if (numkids > 1 && i == numkids - 1) {
                if (kidpos < this.printY + this.printHeight) continue;
                if (kidpos < this.printY + this.printHeight / 0.97) {
                    this.breakPage(allocation.getY() + allocation.getHeight());
                    continue;
                }
            }
            if (kidpos < this.printY + this.printHeight) continue;
            if (kid.getViewCount() == 0) {
                this.breakPage(kidbox.getY());
                continue;
            }
            this.paginate(kid, kidbox);
        }
    }

    void breakPage(double y) {
        double pageLength = y - this.pageStart - this.printY;
        this.pageStart = y - this.printY;
        this.pageLengths.add(pageLength);
        this.pageOffsets.add(this.pageStart);
    }

    @Override
    public int getNumberOfPages() {
        return this.numPages;
    }

    @Override
    public PageFormat getPageFormat(int pagenum) {
        if (pagenum == this.numPages - 1) {
            return this.format;
        }
        double pageLength = (Double)this.pageLengths.get(pagenum);
        PageFormat f = (PageFormat)this.format.clone();
        Paper p = f.getPaper();
        if (f.getOrientation() == 1) {
            p.setImageableArea(this.printX * this.scalefactor, this.printY * this.scalefactor, this.printWidth * this.scalefactor, pageLength * this.scalefactor);
        } else {
            p.setImageableArea(this.printY * this.scalefactor, this.printX * this.scalefactor, pageLength * this.scalefactor, this.printWidth * this.scalefactor);
        }
        f.setPaper(p);
        return f;
    }

    @Override
    public Printable getPrintable(int pagenum) {
        return this;
    }

    @Override
    public int print(Graphics g, PageFormat format, int pageIndex) {
        if (pageIndex >= this.numPages) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.translate(format.getImageableX(), format.getImageableY());
        g2.scale(this.scalefactor, this.scalefactor);
        if (pageIndex > 0) {
            Shape originalClip = g.getClip();
            g.setClip(new Rectangle(0, (int)(-this.printY), (int)this.printWidth, (int)this.printY));
            String numString = "- " + (pageIndex + 1) + " -";
            FontRenderContext frc = g2.getFontRenderContext();
            Rectangle2D numBounds = headerFont.getStringBounds(numString, frc);
            LineMetrics metrics = headerFont.getLineMetrics(numString, frc);
            g.setFont(headerFont);
            g.setColor(Color.black);
            g.drawString(numString, (int)((this.printWidth - numBounds.getWidth()) / 2.0), (int)(-(this.printY - numBounds.getHeight()) / 2.0 + (double)metrics.getAscent()));
            g.setClip(originalClip);
        }
        double pageStart = 0.0;
        if (pageIndex > 0) {
            pageStart = (Double)this.pageOffsets.get(pageIndex - 1);
        }
        g2.translate(0.0, -pageStart);
        this.root.paint(g, this.drawRect);
        return 0;
    }

    static class ParentView
    extends View {
        ViewFactory viewFactory;
        Container container;

        public ParentView(View v, ViewFactory viewFactory, Container container) {
            super(v.getElement());
            this.viewFactory = viewFactory;
            this.container = container;
        }

        @Override
        public ViewFactory getViewFactory() {
            return this.viewFactory;
        }

        @Override
        public Container getContainer() {
            return this.container;
        }

        @Override
        public void paint(Graphics g, Shape allocation) {
        }

        @Override
        public float getPreferredSpan(int axis) {
            return 0.0f;
        }

        @Override
        public int viewToModel(float x, float y, Shape a, Position.Bias[] bias) {
            return 0;
        }

        @Override
        public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
            return a;
        }
    }
}

