/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.beans.PropertyChangeListener;
import javax.swing.JSlider;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.IListenerStripper;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.util.IntVR;

public class guiSliderVal
extends guiPanel {
    private static final String VALUE_CHANGED = "VALUE_CHANGED";
    private final JSlider d_opacitySlider = new JSlider(0, 0, 100, 100);
    private final ValueField<Integer> d_opacityField = ValueFields.intFld(100, IntVR.between(0, 100, true, true));
    private float d_value;

    public guiSliderVal() {
        this.d_opacityField.setColumns(3);
        this.d_opacityField.setHorizontalAlignment(4);
        this.d_opacityField.addValueChangeListener(e -> this.d_opacitySlider.setValue((Integer)this.d_opacityField.getValue()));
        this.d_opacitySlider.addChangeListener(e -> {
            int value = this.d_opacitySlider.getValue();
            this.d_opacityField.setValue(value);
            float opacity = (float)value / (float)this.d_opacitySlider.getMaximum();
            if (opacity != this.d_value) {
                float oldValue = this.d_value;
                this.d_value = opacity;
                this.firePropertyChange(VALUE_CHANGED, oldValue, this.d_value);
            }
        });
        GridBagHelper gb = new GridBagHelper(this);
        gb.addRow(this.d_opacitySlider, 1.0, this.d_opacityField, "%");
        gb.finalizeRows();
        this.d_value = (float)this.d_opacitySlider.getValue() / (float)this.d_opacitySlider.getMaximum();
    }

    public void setValue(float value) {
        this.d_value = value;
        IListenerStripper listeners = guiUtil.stripListeners(this::addValueChangeListener, this::getValueChangeListeners, this::removeValueChangeListener);
        this.d_opacitySlider.setValue((int)(this.d_value * (float)this.d_opacitySlider.getMaximum()));
        listeners.restore();
        this.setModified(false);
    }

    public float getValue() {
        return this.d_value;
    }

    public void addValueChangeListener(PropertyChangeListener listener) {
        this.addPropertyChangeListener(VALUE_CHANGED, listener);
    }

    public void removeValueChangeListener(PropertyChangeListener listener) {
        this.removePropertyChangeListener(VALUE_CHANGED, listener);
    }

    public PropertyChangeListener[] getValueChangeListeners() {
        return this.getPropertyChangeListeners(VALUE_CHANGED);
    }
}

