/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.text.ParseException;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.guiValueField;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.Global;
import thunderheadeng.util.ValueRange;

public class guiConstUnitDoubleField
extends guiValueField<UnitDouble> {
    private Unit d_unit;

    public guiConstUnitDoubleField(Unit unit) {
        this(unit, UnitDoubleVR.unbounded());
    }

    public guiConstUnitDoubleField(Unit unit, DoubleVR range) {
        this(unit, UnitDoubleVR.from(range, unit));
    }

    public guiConstUnitDoubleField(Unit unit, UnitDoubleVR range) {
        this(unit, range.clampValue(new UnitDouble(0.0, unit)), range);
    }

    public guiConstUnitDoubleField(Unit unit, double value) {
        this(unit, new UnitDouble(value, unit));
    }

    public guiConstUnitDoubleField(Unit unit, double value, DoubleVR range) {
        this(unit, new UnitDouble(value, unit), UnitDoubleVR.from(range, unit));
    }

    public guiConstUnitDoubleField(Unit unit, UnitDouble value) {
        this(unit, value, UnitDoubleVR.UNBOUNDED);
    }

    public guiConstUnitDoubleField(Unit unit, UnitDouble value, ValueRange<UnitDouble> range) {
        this.d_unit = unit;
        this.init(value, range);
    }

    @Override
    protected String format(UnitDouble value) {
        return Global.format(value.getValue(this.d_unit));
    }

    @Override
    public UnitDouble parse(String value) throws ParseException {
        double baseval = Global.parseDouble(value);
        return new UnitDouble(baseval, this.d_unit);
    }

    @Override
    protected ValueRange<UnitDouble> getUncheckedRange(UnitDouble value) {
        return UnitDoubleVR.unbounded();
    }

    public Unit getUnit() {
        return this.d_unit;
    }

    public void setUnit(Unit u) {
        this.d_unit = u;
        this.setModified(true);
    }
}

