/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import thunderheadeng.Intl;
import thunderheadeng.gui.Modifiable;
import thunderheadeng.gui.Validateable;
import thunderheadeng.util.IntVR;
import thunderheadeng.util.ValueRange;
import thunderheadeng.util.theUtil;

public class guiComboBox<T>
extends JComboBox
implements Modifiable,
Validateable {
    private ValueRange d_range = IntVR.unbounded();
    private boolean d_modified = false;

    public guiComboBox() {
        this.init(null);
    }

    public guiComboBox(T ... items) {
        super(items);
        this.init(null);
    }

    public guiComboBox(Vector<? extends T> items) {
        super(items);
        this.init(null);
    }

    public guiComboBox(Collection<? extends T> items) {
        super(new Vector<T>(items));
        this.init(null);
    }

    public guiComboBox(ComboBoxModel aModel) {
        super(aModel);
        this.init(null);
    }

    private void init(ValueRange vr) {
        this.setControls();
    }

    public Vector<T> getAllItems() {
        Vector<T> objs = new Vector<T>(this.getModel().getSize());
        for (int m = 0; m < this.getModel().getSize(); ++m) {
            objs.add(this.getItemAt(m));
        }
        return objs;
    }

    public void add(T obj) {
        Vector<T> objs = this.getAllItems();
        if (!objs.contains(obj)) {
            objs.add(obj);
        }
        this.setItems(objs);
    }

    public boolean contains(T obj) {
        for (int m = 0; m < this.getModel().getSize(); ++m) {
            if (!theUtil.equal(obj, this.getModel().getElementAt(m))) continue;
            return true;
        }
        return false;
    }

    public void setRange(ValueRange vr) {
        this.d_range = vr;
    }

    @Override
    protected void fireItemStateChanged(ItemEvent e) {
        this.d_modified = true;
        super.fireItemStateChanged(e);
    }

    @Override
    public boolean isModified() {
        return this.d_modified;
    }

    @Override
    public void setModified(boolean modified) {
        this.d_modified = modified;
    }

    public void setItems(T ... items) {
        this.setModel(new DefaultComboBoxModel<T>(items));
    }

    public void setItems(Vector<? extends T> items) {
        this.setModel(new DefaultComboBoxModel<T>(items));
    }

    public void setItems(Collection<? extends T> items) {
        if (items instanceof Vector) {
            this.setItems((Vector)items);
        } else {
            this.setItems(new Vector<T>(items));
        }
    }

    public T getItemAt(int index) {
        return (T)super.getItemAt(index);
    }

    public T getSelectedItem() {
        return (T)super.getSelectedItem();
    }

    public Collection<T> getSelectedItems() {
        Object[] objs = super.getSelectedObjects();
        ArrayList<Object> objsColl = new ArrayList<Object>(objs.length);
        for (Object o : objs) {
            objsColl.add(o);
        }
        return objsColl;
    }

    private void setControls() {
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        return new Dimension(d.width, 24);
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!this.d_range.checksMax() && !this.d_range.checksMin()) {
            return true;
        }
        int value = 0;
        try {
            value = Integer.parseInt(this.getSelectedItem().toString());
        }
        catch (NumberFormatException e) {
            if (showWarn) {
                String msg = String.format(Intl.intl("The entry \"%1$s\" is invalid.\n%2$s"), this.getSelectedItem().toString(), this.d_range.describeRange());
                this.showMessageBox(msg);
                this.requestFocusHack();
            }
            return false;
        }
        if (!this.d_range.checkValue(value)) {
            if (showWarn) {
                String msg = String.format(Intl.intl("The entry \"%1$s\" is invalid.\n%2$s"), this.getSelectedItem().toString(), this.d_range.describeRange());
                this.showMessageBox(msg);
                this.requestFocusHack();
            }
            return false;
        }
        return true;
    }

    public boolean validateData() {
        return this.validateData(true, true);
    }

    protected void showMessageBox(String msg) {
        JOptionPane.showMessageDialog(null, msg, Intl.intl("Invalid Entry"), 2);
    }

    protected void requestFocusHack() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                guiComboBox.this.requestFocus();
            }
        });
    }
}

