/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui.format;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.format.AFormat;
import thunderheadeng.gui.format.FormatUtil;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Global;
import thunderheadeng.util.IObservable;
import thunderheadeng.util.IObserver;
import thunderheadeng.util.ObservableProxy;

public class UDListFormat
extends AFormat<UnitDouble[]>
implements IObservable,
IObserver {
    private final IUnitSrc d_displayUnit;
    private final int d_minLen;
    private final int d_maxLen;
    private final ObservableProxy d_observable;

    public UDListFormat(IUnitSrc displayUnit) {
        this(displayUnit, 0, Integer.MAX_VALUE);
    }

    public UDListFormat(IUnitSrc displayUnit, int minLen, int maxLen) {
        this.d_minLen = minLen;
        this.d_maxLen = maxLen;
        this.d_displayUnit = displayUnit;
        this.d_displayUnit.addObserver(this, true);
        this.d_observable = new ObservableProxy(this);
    }

    @Override
    public void addObserver(IObserver observer, boolean weakRef) {
        this.d_observable.addObserver(observer, weakRef);
    }

    @Override
    public void deleteObserver(IObserver observer) {
        this.d_observable.deleteObserver(observer);
    }

    @Override
    public void update(IObservable source, Object arg) {
        this.d_observable.setChanged(true);
    }

    @Override
    protected UnitDouble[] parse(String text) throws ParseException {
        Unit defaultUnit = this.d_displayUnit.getUnit();
        ArrayList<UnitDouble> vals = new ArrayList<UnitDouble>();
        char coordSep = UDListFormat.getCoordSeparator();
        StringTokenizer tokenizer = new StringTokenizer(text, " " + coordSep);
        ArrayList<String> tokens = new ArrayList<String>(tokenizer.countTokens());
        while (tokenizer.hasMoreTokens()) {
            tokens.add(tokenizer.nextToken().trim());
        }
        int m = 0;
        while (m < tokens.size()) {
            String token1 = (String)tokens.get(m);
            if (m < tokens.size() - 1) {
                String token2 = (String)tokens.get(m + 1);
                String together = token1 + " " + token2;
                try {
                    UnitDouble val = Global.parseUnitDouble(together, defaultUnit);
                    m += 2;
                    vals.add(val);
                    continue;
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            UnitDouble val = Global.parseUnitDouble(token1, defaultUnit);
            ++m;
            vals.add(val);
        }
        if (vals.size() < this.d_minLen || vals.size() > this.d_maxLen) {
            String msg = FormatUtil.formatLengthMessage(this.d_minLen, this.d_maxLen);
            throw new ParseException(msg, 0);
        }
        return vals.toArray(new UnitDouble[vals.size()]);
    }

    @Override
    protected String toString(UnitDouble[] vals) {
        Unit displayUnitType = this.d_displayUnit.getUnit();
        StringBuffer buffer = new StringBuffer();
        char coordSep = UDListFormat.getCoordSeparator();
        for (int m = 0; m < vals.length; ++m) {
            if (m != 0) {
                buffer.append(coordSep + " ");
            }
            UnitDouble val = vals[m];
            Unit displayUnit = displayUnitType != null ? displayUnitType : val.getUnit();
            buffer.append(Global.format(val.getValue(displayUnit), displayUnit));
        }
        return buffer.toString();
    }

    private static char getCoordSeparator() {
        char decSep = FormatUtil.getDecimalSeparator();
        return decSep == ',' ? (char)';' : ',';
    }
}

