/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui.format;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import thunderheadeng.gui.format.IValueFormat;
import thunderheadeng.util.theUtil;

public abstract class AFormat<T>
extends Format
implements IValueFormat<T>,
Cloneable {
    private Map<String, T> d_aliases = AFormat.newAliasMap();

    protected abstract T parse(String var1) throws ParseException;

    protected abstract String toString(T var1);

    @Override
    public Format get() {
        return this;
    }

    private static <T> Map<String, T> newAliasMap() {
        LinkedHashMap<String, Object> aliases = new LinkedHashMap<String, Object>();
        aliases.put("", null);
        return aliases;
    }

    @Override
    public AFormat<T> clone() {
        AFormat clone = (AFormat)super.clone();
        clone.d_aliases = new LinkedHashMap<String, T>(this.d_aliases);
        return clone;
    }

    public Map<String, T> getAliases() {
        return Collections.unmodifiableMap(this.d_aliases);
    }

    public void setAliases(Map<String, T> aliases) {
        this.d_aliases = AFormat.newAliasMap();
        this.d_aliases.putAll(aliases);
    }

    @Override
    public void alias(T val, String ... aliases) {
        for (String alias : aliases) {
            this.d_aliases.put(alias, val);
        }
    }

    @Override
    public void removeAlias(String text) {
        if (text.isEmpty()) {
            this.d_aliases.put(text, null);
            return;
        }
        this.d_aliases.remove(text);
    }

    @Override
    public T getAliasedValue(String text) {
        return this.d_aliases.get(text);
    }

    public void clearAliases() {
        this.d_aliases = AFormat.newAliasMap();
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        String text = null;
        for (Map.Entry<String, T> entry : this.d_aliases.entrySet()) {
            if (theUtil.equal(obj, entry.getValue()) && !theUtil.equal(text = entry.getKey(), "")) break;
        }
        if (text == null) {
            text = this.toString(obj);
        }
        toAppendTo.append(text);
        pos.setBeginIndex(0);
        pos.setEndIndex(text.length());
        return toAppendTo;
    }

    @Override
    public Object parseObject(String source) throws ParseException {
        if (this.d_aliases.containsKey(source = source.trim())) {
            return this.d_aliases.get(source);
        }
        return this.parse(source);
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        try {
            String substring = source.substring(pos.getIndex()).trim();
            if (this.d_aliases.containsKey(substring)) {
                return this.d_aliases.get(substring);
            }
            T parsed = this.parse(substring);
            pos.setIndex(source.length());
            return parsed;
        }
        catch (ParseException e) {
            pos.setErrorIndex(0);
            return null;
        }
    }
}

