/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui.dialogs;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import thunderheadeng.Intl;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.gui.table.guiTableUtil;
import thunderheadeng.util.Pair;

public class CustomKeyAcceleratorDlg
extends guiDialog {
    private static final long serialVersionUID = 1L;
    private final JTabbedPane d_tabbedPane;
    private final List<AcceleratorTablePanel> d_tabs;
    private final ICustomKeyUIHelper d_actionMapHelper;

    public CustomKeyAcceleratorDlg(JFrame parent, ICustomKeyUIHelper helper) {
        super((Window)parent, Intl.intl("Keyboard Shortcuts"), 9);
        this.d_actionMapHelper = helper;
        this.d_tabbedPane = new JTabbedPane();
        this.d_tabs = new ArrayList<AcceleratorTablePanel>();
        BiConsumer<String, AcceleratorTablePanel> addTab = (label, panel) -> {
            this.d_tabs.add((AcceleratorTablePanel)panel);
            panel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
            this.d_tabbedPane.add((String)label, (Component)panel);
        };
        for (Pair<String, Collection<String>> pnlInfo : this.d_actionMapHelper.getTabStrings()) {
            addTab.accept((String)pnlInfo.v1, new AcceleratorTablePanel(parent, helper, (Collection)pnlInfo.v2));
        }
        guiPanel dlgPanel = this.getDialogPane();
        dlgPanel.add((Component)this.d_tabbedPane, "Center");
        JButton resetButton = new JButton(Intl.intl("Reset All"));
        resetButton.addActionListener(e -> this.resetToDefaults());
        this.getContentPane().remove(this.getButtonPanel());
        guiPanel southPnl = new guiPanel(new GridBagLayout());
        GridBagUtil.add(southPnl, resetButton, 0, 0, 1, 1, 6, 12, 0, 12, 0, 0.0, 0.0);
        GridBagUtil.add(southPnl, Box.createGlue(), 1, 0, 1, 1, 0, 0, 0, 0, 2, 1.0, 0.0);
        GridBagUtil.add(southPnl, this.getButtonPanel(), 2, 0, 1, 1, 0, 12, 0, 0, 0, 0.0, 0.0);
        this.getContentPane().add((Component)southPnl, "South");
    }

    private void resetToDefaults() {
        for (AcceleratorTablePanel pnl : this.d_tabs) {
            pnl.resetValues();
        }
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        HashSet usedKeyStrokes = new HashSet();
        for (AcceleratorTablePanel pnl : this.d_tabs) {
            Map mapping = pnl.getKeyStrokes();
            for (Map.Entry kvPair : mapping.entrySet()) {
                boolean isUnique;
                if (kvPair.getValue() == null || (isUnique = usedKeyStrokes.add(kvPair.getValue()))) continue;
                this.d_tabbedPane.setSelectedComponent(pnl);
                pnl.invalidateCell((String)kvPair.getKey(), showWarn, allowModify);
                return false;
            }
        }
        return true;
    }

    public void saveData() {
        HashMap<String, KeyStroke> keyStrokes = new HashMap<String, KeyStroke>();
        for (AcceleratorTablePanel pnl : this.d_tabs) {
            keyStrokes.putAll(pnl.getKeyStrokes());
        }
        this.d_actionMapHelper.saveToActionMap(keyStrokes);
    }

    public void loadData() {
        for (AcceleratorTablePanel pnl : this.d_tabs) {
            pnl.load();
        }
    }

    public static String renderKeyStroke(KeyStroke ks) {
        if (ks == null) {
            return "";
        }
        int mods = ks.getModifiers();
        StringBuilder sb = new StringBuilder();
        String modsText = KeyEvent.getKeyModifiersText(mods).replace('+', ' ').toLowerCase().trim();
        if (!modsText.isEmpty()) {
            sb.append(modsText);
            sb.append(" ");
        }
        sb.append(KeyEvent.getKeyText(ks.getKeyCode()).toUpperCase());
        return sb.toString();
    }

    public static interface ICustomKeyUIHelper {
        public KeyStroke getKeyStrokeForID(String var1);

        public KeyStroke getDefaultKeyStrokeForID(String var1);

        public String getActionNameForID(String var1);

        public void saveToActionMap(Map<String, KeyStroke> var1);

        public Collection<Pair<String, Collection<String>>> getTabStrings();
    }

    private static class KeyInputDialog
    extends guiDialog {
        private static final long serialVersionUID = 1L;
        private int charCode = -1;
        private final Set<Integer> modifiers = new HashSet<Integer>();
        public static final int CLEAR = Integer.MIN_VALUE;

        public KeyInputDialog(Window owner) {
            super(owner, Intl.intl("Keyboard Shortcut"), 8);
            guiPanel dlgPanel = this.getDialogPane();
            dlgPanel.setLayout(new GridBagLayout());
            GridBagHelper gbh = new GridBagHelper(dlgPanel);
            gbh.addRow(Intl.intl("Awaiting input... "));
            gbh.finalizeRows();
            assert (super.getButton(Integer.MIN_VALUE) == null);
            JButton resetButton = new JButton(Intl.intl("Reset"));
            resetButton.addActionListener(e -> this.endModal(4));
            this.addButton(resetButton);
            JButton clearButton = new JButton(Intl.intl("Clear"));
            clearButton.addActionListener(e -> this.endModal(Integer.MIN_VALUE));
            this.addButton(clearButton);
            JButton cancelButton = this.getButton(8);
            this.getButtonPanel().remove(cancelButton);
            this.getButtonPanel().add(cancelButton);
            KeyListener theListener = new KeyListener(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getExtendedKeyCode() == 27) {
                        this.endModal(8);
                        return;
                    }
                    if (this.isModifier(e.getExtendedKeyCode())) {
                        modifiers.add(e.getExtendedKeyCode());
                        return;
                    }
                    charCode = e.getExtendedKeyCode();
                    if (charCode != -1) {
                        this.endModal(1);
                        return;
                    }
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    int keyCode = e.getExtendedKeyCode();
                    if (modifiers.contains(keyCode)) {
                        modifiers.remove(keyCode);
                    }
                }

                @Override
                public void keyTyped(KeyEvent e) {
                }

                private boolean isModifier(int keyCode) {
                    return keyCode == 18 || keyCode == 17 || keyCode == 16 || keyCode == 157 || keyCode == 65406;
                }
            };
            resetButton.addKeyListener(theListener);
            clearButton.addKeyListener(theListener);
            cancelButton.addKeyListener(theListener);
        }

        public KeyStroke getKeyStroke() {
            if (this.charCode == -1) {
                return null;
            }
            int mods = 0;
            for (int mod : this.modifiers) {
                mods |= KeyInputDialog.getMaskForModifierKeyCode(mod);
            }
            KeyStroke ks = KeyStroke.getKeyStroke(this.charCode, mods);
            return ks;
        }

        private static int getMaskForModifierKeyCode(int keycode) {
            switch (keycode) {
                case 18: {
                    return 512;
                }
                case 17: {
                    return 128;
                }
                case 16: {
                    return 64;
                }
                case 157: {
                    return 256;
                }
                case 65406: {
                    return 8192;
                }
            }
            return -1;
        }
    }

    private static class AcceleratorTablePanel
    extends guiPanel {
        private static final long serialVersionUID = 1L;
        private static final int COLUMN_FUNCTION_NAME = 0;
        private static final int COLUMN_KEYSTROKE = 1;
        private final guiTableEditor d_editor;
        private final guiTable d_table;
        private final Collection<String> d_actionKeys;
        private final JFrame d_parent;
        private final ICustomKeyUIHelper d_actionMapAbstractor;

        public AcceleratorTablePanel(JFrame parent, ICustomKeyUIHelper helper, Collection<String> actionKeys) {
            super(new GridBagLayout());
            this.d_actionKeys = actionKeys;
            this.d_parent = parent;
            this.d_actionMapAbstractor = helper;
            String[] headers = new String[]{Intl.intl("Action"), Intl.intl("Key Press")};
            Class[] colClasses = new Class[]{String.class, KeyStroke.class};
            this.d_editor = new guiTableEditor(guiTableUtil.fixedColumnTable(headers, colClasses, 16), 0);
            this.d_table = this.d_editor.getTable();
            this.d_table.setColumnEditable(0, false);
            this.d_table.setColumnEditable(1, false);
            this.d_table.getColumnModel().getSelectionModel().setSelectionMode(0);
            this.d_table.getSelectionModel().setSelectionMode(0);
            this.load();
            this.d_table.getColumnModel().getColumn(0).setCellEditor(new ActionNameCellEditor(this.d_actionMapAbstractor));
            this.d_table.getColumnModel().getColumn(0).setCellRenderer(new ActionNameCellRenderer(this.d_actionMapAbstractor));
            this.d_table.getColumnModel().getColumn(1).setCellEditor(new KeystrokeTableCellEditor());
            this.d_table.getColumnModel().getColumn(1).setCellRenderer(new KeystrokeTableCellRenderer());
            this.d_table.autoSizeColumns(300);
            this.d_table.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    this.handleCellChangeEvent();
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }
            });
            GridBagUtil.add(this, this.d_editor, 0, 0, 2, 1, 0, 0, 0, 0, 1, 1.0, 1.0, 17);
        }

        private void load() {
            this.d_table.clearRows();
            int row = 0;
            for (String actionKey : this.d_actionKeys) {
                KeyStroke ks = this.d_actionMapAbstractor.getKeyStrokeForID(actionKey);
                this.d_table.getModel().setValueAt(actionKey, row, 0);
                this.d_table.getModel().setValueAt(ks, row, 1);
                ++row;
            }
        }

        public void resetValues() {
            for (int i = 0; i < this.d_table.getModel().getRowCount(); ++i) {
                String actionIdKey = (String)this.d_table.getValueAt(i, 0);
                KeyStroke defKS = this.d_actionMapAbstractor.getDefaultKeyStrokeForID(actionIdKey);
                this.d_table.setValueAt(defKS, i, 1);
            }
        }

        private Map<String, KeyStroke> getKeyStrokes() {
            HashMap<String, KeyStroke> results = new HashMap<String, KeyStroke>();
            for (int i = 0; i < this.d_table.getModel().getRowCount(); ++i) {
                String actionIdKey = (String)this.d_table.getValueAt(i, 0);
                KeyStroke ks = (KeyStroke)this.d_table.getValueAt(i, 1);
                results.put(actionIdKey, ks);
            }
            return results;
        }

        public void invalidateCell(String actionId, boolean showWarn, boolean allowModify) {
            for (int i = 0; i < this.d_table.getRowCount(); ++i) {
                if (!actionId.equals(this.d_table.getValueAt(i, 0))) continue;
                this.d_table.flagInvalidCell(i, 1, showWarn, allowModify, Intl.intl("Multiple actions cannot be assigned the same key binding."));
            }
        }

        private void handleCellChangeEvent() {
            int col = this.d_table.getSelectedColumn();
            int row = this.d_table.getSelectedRow();
            if (col != 1) {
                return;
            }
            KeyInputDialog dlg = new KeyInputDialog((Window)this.d_parent);
            int dlgStatus = dlg.doModal();
            if (dlgStatus == 1) {
                KeyStroke newKS = dlg.getKeyStroke();
                this.d_table.setValueAt(newKS, row, col);
            } else if (dlgStatus == 4) {
                String actionStr = (String)this.d_table.getValueAt(row, 0);
                KeyStroke defaultKS = this.d_actionMapAbstractor.getDefaultKeyStrokeForID(actionStr);
                this.d_table.setValueAt(defaultKS, row, col);
            } else if (dlgStatus == Integer.MIN_VALUE) {
                this.d_table.setValueAt(null, row, col);
            }
        }

        private static class KeystrokeTableCellEditor
        extends DefaultCellEditor
        implements TableCellEditor {
            private static final long serialVersionUID = 1L;
            private KeyStroke d_ks;

            public KeystrokeTableCellEditor() {
                super(new JTextField());
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                this.d_ks = (KeyStroke)value;
                JTextField c = (JTextField)this.getComponent();
                c.setText(CustomKeyAcceleratorDlg.renderKeyStroke(this.d_ks));
                return c;
            }

            @Override
            public Object getCellEditorValue() {
                return this.d_ks;
            }
        }

        private static class KeystrokeTableCellRenderer
        extends DefaultTableCellRenderer {
            private static final long serialVersionUID = 1L;

            private KeystrokeTableCellRenderer() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                KeyStroke ks = (KeyStroke)value;
                this.setText(CustomKeyAcceleratorDlg.renderKeyStroke(ks));
                return comp;
            }
        }

        private static class ActionNameCellRenderer
        extends DefaultTableCellRenderer {
            private static final long serialVersionUID = 1L;
            private final ICustomKeyUIHelper d_actionHelper;

            public ActionNameCellRenderer(ICustomKeyUIHelper helper) {
                this.d_actionHelper = helper;
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                String actionId = (String)value;
                this.setText(this.d_actionHelper.getActionNameForID(actionId));
                return comp;
            }
        }

        private static class ActionNameCellEditor
        extends DefaultCellEditor
        implements TableCellEditor {
            private static final long serialVersionUID = 1L;
            private final ICustomKeyUIHelper d_actionMapHelper;
            private String d_actionKey;

            public ActionNameCellEditor(ICustomKeyUIHelper helper) {
                super(new JTextField());
                this.d_actionMapHelper = helper;
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                this.d_actionKey = (String)value;
                JTextField c = (JTextField)this.getComponent();
                c.setText(this.d_actionMapHelper.getActionNameForID(this.d_actionKey));
                return c;
            }

            @Override
            public Object getCellEditorValue() {
                return this.d_actionKey;
            }
        }
    }
}

