/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui.dialogs;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.JButton;
import thunderheadeng.Intl;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;

public abstract class AFindDlg<T, D>
extends guiDialog {
    private static Deque<String> QUERY_HISTORY = new ArrayDeque<String>();
    private Collection<? extends T> d_results;
    private Iterator<? extends T> d_iterator;
    private D d_domain;

    public AFindDlg(Window owner, D serialized) {
        super(owner, Intl.intl("Find"), 16);
        this.d_domain = serialized;
        this.d_results = Collections.emptyList();
        guiComboBox<String> findFld = new guiComboBox<String>();
        Dimension oldSize = findFld.getPreferredSize();
        findFld.setPreferredSize(new Dimension(230, oldSize.height));
        findFld.setEditable(true);
        findFld.setItems((Collection<String>)QUERY_HISTORY);
        findFld.getEditor().selectAll();
        findFld.requestFocusInWindow();
        guiPanel messagePanel = new guiPanel(new FlowLayout(0, 0, 0));
        guiLabel message = new guiLabel("MMMMMMMMMMMM");
        messagePanel.setPreferredSize(message.getPreferredSize());
        messagePanel.add(message);
        message.setText("");
        JButton btNext = new JButton(Intl.intl("Find/Next"));
        btNext.addActionListener(e -> this.perform(findFld, message, ActionAfterQuery.FINDNEXT));
        JButton btAll = new JButton(Intl.intl("Select All"));
        btAll.addActionListener(e -> this.perform(findFld, message, ActionAfterQuery.SELECTALL));
        this.buildPanel(findFld, messagePanel, btNext, btAll);
    }

    private void buildPanel(guiComboBox<String> findFld, guiPanel msgPnl, JButton btNext, JButton btAll) {
        GridBagHelper gbh = new GridBagHelper(this.getDialogPane());
        gbh.addRow(Intl.intl("Find:"), findFld);
        guiPanel buttonRow = new guiPanel(new FlowLayout(2, 0, 0));
        buttonRow.add(btNext);
        buttonRow.add(Box.createHorizontalStrut(12));
        buttonRow.add(btAll);
        gbh.addRow(new Object[]{buttonRow, 0, GridBagHelper.Anchor.RIGHT});
        gbh.addRow(msgPnl, 0);
        this.getRootPane().setDefaultButton(btNext);
        gbh.finalizeRows();
    }

    private void performQuery(guiComboBox<String> queryFld, String searchStr) {
        this.d_results = this.find(searchStr);
        this.d_iterator = this.d_results.iterator();
        AFindDlg.addToQueryHistory(queryFld, searchStr);
    }

    private void updateQueryAndWrapSearch(guiComboBox<String> findFld, guiLabel msgLbl) {
        msgLbl.setText("");
        if (findFld.isModified() || this.d_results.isEmpty()) {
            String str = findFld.getSelectedItem();
            if (str == null) {
                str = "";
            }
            String sanitaryStr = str.trim();
            msgLbl.setText(Intl.intl("Searching for \"" + sanitaryStr + "\""));
            this.performQuery(findFld, str);
            findFld.setModified(false);
        }
        String msgStr = String.format(Intl.intl("%d Results"), this.d_results.size());
        if (this.d_results.size() == 1) {
            msgStr = msgStr.replace("Results", "Result");
        }
        msgLbl.setText(msgStr);
        if (!this.d_results.isEmpty() && !this.d_iterator.hasNext()) {
            this.d_iterator = this.d_results.iterator();
            msgLbl.setText(Intl.intl("Search Wrapped"));
        }
    }

    private static void addToQueryHistory(guiComboBox<String> queryFld, String queryStr) {
        if (queryStr != null && !queryStr.trim().isEmpty()) {
            String sanitaryStr = queryStr.trim();
            QUERY_HISTORY.addFirst(sanitaryStr);
            while (5 < QUERY_HISTORY.size()) {
                QUERY_HISTORY.removeLast();
            }
            queryFld.setItems((Collection<String>)QUERY_HISTORY);
        }
    }

    public abstract void perform(guiComboBox<String> var1, guiLabel var2, ActionAfterQuery var3);

    protected void run(guiComboBox<String> findFld, guiLabel message, ActionAfterQuery action) {
        this.updateQueryAndWrapSearch(findFld, message);
        if (action == ActionAfterQuery.FINDNEXT) {
            this.selectNext();
        } else if (action == ActionAfterQuery.SELECTALL) {
            this.selectAll();
        }
    }

    protected abstract Collection<T> find(String var1);

    protected abstract void selectNext();

    protected abstract void selectAll();

    protected final Collection<? extends T> getSelection() {
        return this.d_results;
    }

    protected Iterator<? extends T> getIterator() {
        return this.d_iterator;
    }

    protected final D getDomain() {
        return this.d_domain;
    }

    protected static enum ActionAfterQuery {
        FINDNEXT,
        SELECTALL;

    }
}

