/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui.colorscheme;

import java.awt.Color;
import java.awt.GridBagLayout;
import java.awt.Window;
import javax.swing.JColorChooser;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import thunderheadeng.Intl;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.colorscheme.ColorHistory;
import thunderheadeng.gui.colorscheme.DoubleRGBChooser;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.util.ColorPool;

public class SimpleColorChooser
extends guiDialog {
    public static final int OPT_EXCLUDE_ALPHA = 1;
    private final JColorChooser d_chooser;
    private final int d_options;
    private static JColorChooser s_chooser;

    public SimpleColorChooser(Window owner, String title, int options) {
        this(owner, title, true, options);
    }

    public SimpleColorChooser(Window owner, String title, boolean sharedChooser, int options) {
        super(owner, title, 9);
        this.d_options = options;
        this.d_chooser = SimpleColorChooser.getChooser(sharedChooser);
        AbstractColorChooserPanel[] panels = this.d_chooser.getChooserPanels();
        JTabbedPane tabs = new JTabbedPane();
        tabs.add("RGB", panels[3]);
        tabs.add(Intl.intl("Palette"), panels[0]);
        tabs.add(Intl.intl("Sliders"), panels[2]);
        this.getDialogPane().setLayout(new GridBagLayout());
        int row = 0;
        GridBagUtil.add(this.getDialogPane(), tabs, 0, ++row, 2, 1, 0, 0, 11, 0);
        GridBagUtil.add(this.getDialogPane(), this.d_chooser.getPreviewPanel(), 0, ++row, 1, 1, 0, 0, 0, 0, 0, 1.0, 1.0, 10);
    }

    private static boolean testOption(int options, int option) {
        return (options & option) == option;
    }

    @Override
    public int doModal() {
        return super.doModal();
    }

    public Color getColor() {
        Color chooserColor = this.d_chooser.getColor();
        float[] comps = new float[3];
        chooserColor.getRGBColorComponents(comps);
        double alpha = 1.0;
        if (!SimpleColorChooser.testOption(this.d_options, 1)) {
            alpha = (double)chooserColor.getAlpha() / 255.0;
        }
        Color color = new Color(comps[0], comps[1], comps[2], (float)alpha);
        return ColorPool.get(color);
    }

    public void setColor(Color c) {
        this.d_chooser.setColor(c);
        float[] comps = new float[4];
        c.getComponents(comps);
    }

    private static JColorChooser getChooser(boolean shared) {
        if (!shared) {
            return SimpleColorChooser.createChooser();
        }
        if (s_chooser == null) {
            s_chooser = SimpleColorChooser.createChooser();
            s_chooser.getSelectionModel().addChangeListener(evt -> {
                SimpleColorChooser scc = (SimpleColorChooser)SwingUtilities.getAncestorOfClass(SimpleColorChooser.class, s_chooser);
                Color newColor = scc != null ? scc.getColor() : s_chooser.getColor();
                ColorHistory.add(newColor);
            });
        }
        return s_chooser;
    }

    private static JColorChooser createChooser() {
        JColorChooser chooser = new JColorChooser();
        chooser.addChooserPanel(new DoubleRGBChooser());
        return chooser;
    }
}

