/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui.colorscheme;

import java.awt.Color;
import java.awt.GridBagLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.Icon;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import thunderheadeng.Intl;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiDoubleField;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.util.ColorPool;
import thunderheadeng.util.DoubleVR;

public class DoubleRGBChooser
extends AbstractColorChooserPanel {
    private guiDoubleField d_red;
    private guiDoubleField d_green;
    private guiDoubleField d_blue;
    private boolean d_pauseUpdate = false;

    @Override
    public void updateChooser() {
        if (!this.d_pauseUpdate) {
            Color color = this.getColorFromModel();
            float[] rgb = color.getRGBColorComponents(null);
            this.d_red.setValue(rgb[0]);
            this.d_green.setValue(rgb[1]);
            this.d_blue.setValue(rgb[2]);
        }
    }

    @Override
    protected void buildChooser() {
        this.setLayout(new GridBagLayout());
        guiLabel redLabel = new guiLabel(Intl.intl("Red") + ":");
        guiLabel greenLabel = new guiLabel(Intl.intl("Green") + ":");
        guiLabel blueLabel = new guiLabel(Intl.intl("Blue") + ":");
        DoubleVR range = DoubleVR.between(0.0, 1.0, true, true);
        this.d_red = new guiDoubleField(range);
        this.d_green = new guiDoubleField(range);
        this.d_blue = new guiDoubleField(range);
        GridBagUtil.add(this, redLabel, 0, 0, 1, 1, 12, 12, 5, 11);
        GridBagUtil.add(this, greenLabel, 0, 1, 1, 1, 0, 12, 5, 11);
        GridBagUtil.add(this, blueLabel, 0, 2, 1, 1, 0, 12, 11, 11);
        GridBagUtil.add(this, this.d_red, 1, 0, 1, 1, 12, 0, 5, 11);
        GridBagUtil.add(this, this.d_green, 1, 1, 1, 1, 0, 0, 5, 11);
        GridBagUtil.add(this, this.d_blue, 1, 2, 1, 1, 0, 0, 11, 11);
        GridBagUtil.addGlue(this);
        KeyAdapter key = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                guiDoubleField f = (guiDoubleField)e.getSource();
                if (f.validateData(false, false)) {
                    DoubleRGBChooser.this.d_pauseUpdate = true;
                    Color color = new Color(DoubleRGBChooser.getValue(DoubleRGBChooser.this.d_red), DoubleRGBChooser.getValue(DoubleRGBChooser.this.d_green), DoubleRGBChooser.getValue(DoubleRGBChooser.this.d_blue));
                    color = ColorPool.get(color);
                    DoubleRGBChooser.this.getColorSelectionModel().setSelectedColor(color);
                    DoubleRGBChooser.this.d_pauseUpdate = false;
                }
            }
        };
        this.d_red.addKeyListener(key);
        this.d_green.addKeyListener(key);
        this.d_blue.addKeyListener(key);
    }

    private static float getValue(guiDoubleField field) {
        double val = (Double)field.getValue();
        return (float)val;
    }

    @Override
    public String getDisplayName() {
        return "RGB";
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return null;
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return null;
    }
}

