/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui.colorscheme;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButtonMenuItem;
import thunderheadeng.gui.colorscheme.ColorMgr;
import thunderheadeng.gui.guiMenu;

public class ColorMgrMenu
extends guiMenu {
    private ColorMgr d_mgr;

    public ColorMgrMenu(String text, ColorMgr mgr) {
        super(text);
        this.d_mgr = mgr;
        this.update();
    }

    @Override
    protected void fireMenuSelected() {
        this.update();
        super.fireMenuSelected();
    }

    private void update() {
        this.removeAll();
        Object[] schemes = this.d_mgr.getAvailableSchemes();
        String currScheme = this.d_mgr.getCurrentColorScheme().getName();
        Arrays.sort(schemes);
        ButtonGroup bg = new ButtonGroup();
        for (int i = 0; i < schemes.length; ++i) {
            JRadioButtonMenuItem item = new JRadioButtonMenuItem((String)schemes[i]);
            item.addActionListener(new ItemListener((String)schemes[i]));
            bg.add(item);
            this.add(item);
            if (!((String)schemes[i]).equals(currScheme)) continue;
            item.setSelected(true);
        }
    }

    private class ItemListener
    implements ActionListener {
        private String d_name;

        public ItemListener(String name) {
            this.d_name = name;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ColorMgrMenu.this.d_mgr.setCurrentColorScheme(this.d_name);
        }
    }
}

