/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui.colorscheme;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.LinkedList;
import java.util.List;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import thunderheadeng.Intl;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.Modifiable;
import thunderheadeng.gui.colorscheme.SimpleColorChooser;
import thunderheadeng.util.ColorPool;

public class ColorButton
extends JButton
implements Modifiable {
    private Color d_color;
    private boolean d_modified = false;
    private final List d_observers;
    private final int d_options;

    public ColorButton() {
        this(0);
    }

    public ColorButton(int colorChooserOptions) {
        super("MMM");
        this.d_options = colorChooserOptions;
        this.d_color = this.getBackground();
        this.d_observers = new LinkedList();
        this.setPreferredSize(this.getPreferredSize());
        this.setText("");
        this.setBorder(BorderFactory.createEmptyBorder(5, 6, 5, 6));
        this.addActionListener(evt -> this.editColor());
    }

    public void editColor() {
        SimpleColorChooser chooser = new SimpleColorChooser((Window)Application.getApp().getActiveFrame(), Intl.intl("Color"), this.d_options);
        Color c = this.d_color == null ? Color.WHITE : this.d_color;
        chooser.setColor(c);
        if (chooser.doModal() == 1) {
            this.setColor(chooser.getColor());
            this.yell();
            this.editingFinished(true);
        } else {
            this.editingFinished(false);
        }
    }

    protected void editingFinished(boolean committed) {
    }

    public void setColor(Color c) {
        this.d_color = c;
        this.d_modified = true;
        this.repaint();
    }

    public Color getColor() {
        return this.d_color;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Rectangle rect = this.getBounds();
        if (!this.isContentAreaFilled()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, rect.width, rect.height);
        }
        if (this.d_color == null) {
            return;
        }
        Insets insets = this.getInsets();
        int offsetX = insets.left;
        int offsetY = insets.top;
        rect.width = rect.width - insets.right - insets.left - 1;
        rect.height = rect.height - insets.top - insets.bottom - 1;
        Color fillColor = this.d_color.getAlpha() == 255 ? this.d_color : ColorPool.get(new Color(this.d_color.getRed(), this.d_color.getGreen(), this.d_color.getBlue(), 255));
        g.setColor(fillColor);
        g.fillRect(offsetX, offsetY, rect.width, rect.height);
        g.setColor(Color.black);
        g.drawRect(offsetX, offsetY, rect.width, rect.height);
    }

    @Override
    public boolean isModified() {
        return this.d_modified;
    }

    @Override
    public void setModified(boolean modified) {
        this.d_modified = modified;
    }

    public void yell() {
        for (Object o : this.d_observers) {
            ((Observer)o).update(null, null);
        }
    }

    public void addObserver(Observer o) {
        this.d_observers.add(o);
    }

    public void deleteObserver(Observer o) {
        this.d_observers.remove(o);
    }
}

