/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;

public class WaitCursorMgr {
    public static final int DEFAULT_DELAY = 250;
    private static final MouseListener MOUSE_TRAP = new MouseAdapter(){};
    private static final MouseMotionAdapter MOUSE_MOTION_TRAP = new MouseMotionAdapter(){};
    private static final KeyAdapter KEY_TRAP = new KeyAdapter(){};
    private static final ComponentListener FOCUS_TRAP = new ComponentAdapter(){

        @Override
        public void componentShown(ComponentEvent e) {
            e.getComponent().requestFocusInWindow();
        }
    };
    private List<Component> d_components;
    private int d_waitCursorCount = 0;
    private Timer d_waitTimer = null;
    private boolean d_showing = false;

    public WaitCursorMgr(Component ... comps) {
        this(Arrays.asList(comps));
    }

    public WaitCursorMgr(List<? extends Component> components) {
        this.d_components = new ArrayList<Component>(components);
    }

    public void beginWaitCursor() {
        this.beginWaitCursor(0);
    }

    public void beginWaitCursor(boolean delay) {
        int delayTime = delay ? 250 : 0;
        this.beginWaitCursor(delayTime);
    }

    public void beginWaitCursor(final int delay) {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WaitCursorMgr.this.forceBeginWaitCursor(delay);
                }
            });
        } else {
            this.forceBeginWaitCursor(delay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forceBeginWaitCursor(int delay) {
        WaitCursorMgr waitCursorMgr = this;
        synchronized (waitCursorMgr) {
            if (++this.d_waitCursorCount == 1) {
                this.beginEventTrap();
                if (delay <= 0) {
                    this.showWaitCursor();
                } else {
                    this.d_waitTimer = new Timer();
                    this.d_waitTimer.schedule(new TimerTask(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            WaitCursorMgr waitCursorMgr = WaitCursorMgr.this;
                            synchronized (waitCursorMgr) {
                                if (WaitCursorMgr.this.d_waitCursorCount > 0) {
                                    WaitCursorMgr.this.showWaitCursor();
                                }
                            }
                        }
                    }, delay);
                }
            }
        }
    }

    private void beginEventTrap() {
        for (Component comp : this.d_components) {
            if (!(comp instanceof RootPaneContainer)) continue;
            JRootPane root = ((RootPaneContainer)((Object)comp)).getRootPane();
            Component glass = root.getGlassPane();
            glass.addMouseListener(MOUSE_TRAP);
            glass.addMouseMotionListener(MOUSE_MOTION_TRAP);
            glass.addKeyListener(KEY_TRAP);
            glass.setFocusTraversalKeysEnabled(false);
            glass.setVisible(true);
        }
    }

    private void showWaitCursor() {
        if (this.d_showing) {
            return;
        }
        this.d_showing = true;
        Cursor waitCursor = Cursor.getPredefinedCursor(3);
        List<Component> comps = this.d_components;
        for (Component comp : comps) {
            if (comp instanceof RootPaneContainer) {
                JRootPane root = ((RootPaneContainer)((Object)comp)).getRootPane();
                root.setCursor(waitCursor);
                root.getGlassPane().setCursor(waitCursor);
                continue;
            }
            comp.setCursor(waitCursor);
        }
    }

    public void endWaitCursor() {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WaitCursorMgr.this.forceEndWaitCursor();
                }
            });
        } else {
            this.forceEndWaitCursor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forceEndWaitCursor() {
        WaitCursorMgr waitCursorMgr = this;
        synchronized (waitCursorMgr) {
            if (--this.d_waitCursorCount == 0) {
                if (this.d_waitTimer != null) {
                    this.d_waitTimer.cancel();
                    this.d_waitTimer = null;
                }
                this.hideWaitCursor();
                this.endEventTrap();
            }
        }
    }

    private void hideWaitCursor() {
        if (!this.d_showing) {
            return;
        }
        this.d_showing = false;
        Cursor defCursor = Cursor.getPredefinedCursor(0);
        List<Component> comps = this.d_components;
        for (Component comp : comps) {
            if (comp instanceof RootPaneContainer) {
                JRootPane root = ((RootPaneContainer)((Object)comp)).getRootPane();
                root.setCursor(defCursor);
                Component glass = root.getGlassPane();
                glass.setCursor(defCursor);
                continue;
            }
            comp.setCursor(defCursor);
        }
    }

    private void endEventTrap() {
        for (Component comp : this.d_components) {
            if (!(comp instanceof RootPaneContainer)) continue;
            JRootPane root = ((RootPaneContainer)((Object)comp)).getRootPane();
            Component glass = root.getGlassPane();
            glass.removeMouseListener(MOUSE_TRAP);
            glass.removeMouseMotionListener(MOUSE_MOTION_TRAP);
            glass.removeKeyListener(KEY_TRAP);
            glass.setFocusTraversalKeysEnabled(true);
            glass.setVisible(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInputBlocked() {
        WaitCursorMgr waitCursorMgr = this;
        synchronized (waitCursorMgr) {
            return this.d_waitCursorCount > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWaitCursorShowing(Component c) {
        WaitCursorMgr waitCursorMgr = this;
        synchronized (waitCursorMgr) {
            return this.d_waitCursorCount > 0 && this.d_showing;
        }
    }
}

