/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FocusTraversalPolicy;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import thunderheadeng.gui.RecursiveLinkStatusListener;
import thunderheadeng.gui.guiPanel;

public class Utils {
    public static void noToolBarFocus(JToolBar target) {
        Component[] c = target.getComponents();
        for (int i = 0; i < c.length; ++i) {
            c[i].setFocusable(false);
        }
    }

    public static void setEnabled(Component c, boolean enabled) {
        if (c instanceof AbstractButton) {
            c.setEnabled(enabled);
            if (enabled) {
                AbstractButton b = (AbstractButton)c;
                ItemListener[] listeners = b.getItemListeners();
                for (int n = 0; n < listeners.length; ++n) {
                    if (!(listeners[n] instanceof RecursiveLinkStatusListener)) continue;
                    RecursiveLinkStatusListener listener = (RecursiveLinkStatusListener)listeners[n];
                    listener.updateStatus();
                }
            }
        } else if (c instanceof guiPanel) {
            c.setEnabled(enabled);
        } else if (c instanceof Container) {
            c.setEnabled(enabled);
            Utils.setEnabled(((Container)c).getComponents(), enabled);
        } else {
            c.setEnabled(enabled);
        }
    }

    public static void setEnabled(Component[] comps, boolean enabled) {
        ArrayList<Component> buttons = new ArrayList<Component>();
        for (int m = comps.length - 1; m >= 0; --m) {
            Component comp = comps[m];
            if (comp instanceof AbstractButton) {
                buttons.add(comp);
                continue;
            }
            Utils.setEnabled(comp, enabled);
        }
        for (Component button : buttons) {
            Utils.setEnabled(button, enabled);
        }
    }

    public static void requestFocus(final Component comp) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                comp.requestFocus();
            }
        });
    }

    public static Component findParentWindow(Component c) {
        if (c instanceof Frame || c instanceof Window || c instanceof Dialog || c == null) {
            return c;
        }
        return Utils.findParentWindow(c.getParent());
    }

    public static FocusTraversalPolicy createFocusTraversalPolicy(Component ... focusOrder) {
        final List<Component> comps = Arrays.asList(focusOrder);
        return new FocusTraversalPolicy(){

            @Override
            public Component getComponentAfter(Container aContainer, Component aComponent) {
                int i = comps.indexOf(aComponent);
                return i < comps.size() - 1 ? (Component)comps.get(i + 1) : null;
            }

            @Override
            public Component getComponentBefore(Container aContainer, Component aComponent) {
                int i = comps.indexOf(aComponent);
                return 0 < i ? (Component)comps.get(i - 1) : null;
            }

            @Override
            public Component getDefaultComponent(Container aContainer) {
                return this.getFirstComponent(aContainer);
            }

            @Override
            public Component getFirstComponent(Container aContainer) {
                return (Component)comps.get(0);
            }

            @Override
            public Component getLastComponent(Container aContainer) {
                return (Component)comps.get(comps.size() - 1);
            }
        };
    }
}

