/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import thunderheadeng.gui.Application;

public class ResourcePaths {
    private final Application d_app;
    private final List<String> d_resourceDirs = new ArrayList<String>();

    public ResourcePaths(Application app, String ... dirs) {
        this.d_app = app;
        this.d_resourceDirs.addAll(Arrays.asList(dirs));
    }

    public String get(String relativeFile) {
        String idir = this.d_app.getInstallDir();
        File root = new File(idir, relativeFile);
        if (this.d_resourceDirs.isEmpty()) {
            return root.getAbsolutePath();
        }
        for (String dir : this.d_resourceDirs) {
            File f = new File(idir, dir);
            if (!(f = new File(f, relativeFile)).exists()) continue;
            return f.getAbsolutePath();
        }
        if (root.exists()) {
            return root.getAbsolutePath();
        }
        return new File(new File(idir, this.d_resourceDirs.get(0)), relativeFile).getAbsolutePath();
    }

    public void find(FilenameFilter filter, Consumer<File> result) {
        String idir = this.d_app.getInstallDir();
        boolean[] found = new boolean[]{false};
        for (String dir : this.d_resourceDirs) {
            File rdir = new File(idir, dir);
            Stream.of(rdir.listFiles(filter)).forEach(f -> {
                result.accept((File)f);
                blArray[0] = true;
            });
        }
        if (!found[0]) {
            Stream.of(new File(idir).listFiles(filter)).forEach(result);
        }
    }

    public void addDir(String dir) {
        if (!this.d_resourceDirs.contains(dir)) {
            this.d_resourceDirs.add(dir);
        }
    }

    public void addDirs(String ... dirs) {
        for (String dir : dirs) {
            this.addDir(dir);
        }
    }

    public void removeDir(String dir) {
        this.d_resourceDirs.remove(dir);
    }

    public List<String> getDirs() {
        return this.d_resourceDirs;
    }
}

