/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.io.File;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.Application;
import thunderheadeng.io.CopyFile;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.theUtil;

public class ModelBackup {
    public static final UnitDouble DEF_AUTOSAVE_PERIOD = new UnitDouble(10.0, NonSI.MINUTE);
    public static final String BACKUP_POSTFIX = "~";
    public static final String AUTOSAVE_PREFIX = "~";
    private final String d_appName;
    private final IHandler d_callback;
    private final String d_fileExtension;
    private boolean d_backupEnabled = true;
    private AutoSave d_autosave;
    private UnitDouble d_autosavePeriod = DEF_AUTOSAVE_PERIOD;
    private boolean d_modified = false;
    private String d_filename = "";

    public ModelBackup(String appName, String fileExtension, IHandler callback) {
        this.d_appName = appName;
        this.d_callback = callback;
        this.d_fileExtension = fileExtension;
    }

    public boolean isReservedPath(String path) {
        return AutoSave.isAutosavePath(path) || this.isBackupPath(path);
    }

    public boolean isAutosavePath(String path) {
        return AutoSave.isAutosavePath(path);
    }

    public boolean isBackupPath(String path) {
        String backupExt = this.d_fileExtension.substring(0, this.d_fileExtension.length() - 1) + "~";
        return FilenameManager.getExtension(path).equals(backupExt);
    }

    public void setBackupEnabled(boolean enabled) {
        this.d_backupEnabled = enabled;
    }

    public boolean isBackupEnabled() {
        return this.d_backupEnabled;
    }

    public void setModified(boolean modified) {
        this.d_modified = modified;
        if (this.d_autosave != null) {
            this.d_autosave.setModified(modified);
        }
    }

    public void setAutosavePeriod(UnitDouble period) {
        if (period.equals(this.d_autosavePeriod)) {
            return;
        }
        this.d_autosavePeriod = period;
        if (this.d_autosave != null) {
            this.d_autosave.stop();
            this.d_autosave.setTimerPeriod(period);
            this.d_autosave.start();
        }
    }

    public void setFilename(String filename) {
        if (theUtil.equal(filename, this.d_filename)) {
            return;
        }
        this.d_filename = filename;
        if (this.d_autosave != null) {
            this.d_autosave.stop();
            this.d_autosave.setFilename(filename);
            this.d_autosave.start();
        }
    }

    public boolean isAutosaveEnabled() {
        return this.d_autosave != null;
    }

    public void setAutosaveEnabled(boolean autosaveEnabled) {
        boolean enabled;
        boolean bl = enabled = this.d_autosave != null;
        if (autosaveEnabled == enabled) {
            return;
        }
        if (autosaveEnabled) {
            UnitDouble savePeriod = this.d_autosavePeriod;
            this.d_autosave = new AutoSave(this.d_callback, savePeriod, this.d_filename, this.d_fileExtension);
            if (this.d_modified) {
                this.d_autosave.setModified(this.d_modified);
            }
        } else {
            assert (this.d_autosave != null);
            this.d_autosave.end(true);
            this.d_autosave = null;
        }
    }

    public String cancelAutosave() {
        String path = this.getAutosavePath();
        if (this.d_autosave != null) {
            this.d_autosave.end(false);
            this.d_autosave = null;
        }
        return path;
    }

    public String getAutosavePath() {
        if (this.d_autosave != null && this.d_autosave.isSaved()) {
            return this.d_autosave.getFilePath();
        }
        return null;
    }

    private File[] getBackupPaths(File file) {
        String name = file.getName();
        String bakName = name.substring(0, name.length() - 1) + "~";
        File f1 = new File(file.getParentFile(), bakName);
        File f2 = new File(Application.getAppDataDir(this.d_appName) + "backup" + File.separator, bakName);
        return new File[]{f1, f2};
    }

    public void createBackupFile(String path) {
        if (!this.d_backupEnabled || this.isReservedPath(path)) {
            return;
        }
        File orig = new File(path);
        File[] bakFiles = this.getBackupPaths(orig);
        boolean result = false;
        for (File bakFile : bakFiles) {
            try {
                System.out.printf("Saving backup file: %s%n", bakFile);
                bakFile.getParentFile().mkdirs();
                CopyFile.copyFileStream(orig, bakFile);
                result = true;
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!result) {
            System.err.println("Failed to create backup on open.");
        }
    }

    public File getBackupFile(String path) {
        if (this.isBackupPath(path)) {
            return null;
        }
        File[] paths = this.getBackupPaths(new File(path));
        if (paths[0].exists()) {
            return paths[0];
        }
        if (paths[1].exists()) {
            return paths[1];
        }
        return null;
    }

    public static interface IHandler {
        public void save(File var1) throws Exception;
    }

    private static class AutoSave {
        private static final Random RAND = new Random();
        private final Thread d_shutdownHook;
        private Timer d_timer;
        private TimerTask d_tt;
        private volatile boolean d_modified;
        private File d_saveFile;
        private UnitDouble d_timerPeriod;
        private boolean d_hasSaved;
        private UnitDouble d_lastSaveTime;
        private final IHandler d_callback;
        private final String d_fileExtension;
        private String d_baseFilename;

        public AutoSave(IHandler callback, UnitDouble timerPeriod, String baseFilename, String extension) {
            this.d_fileExtension = extension;
            this.d_callback = callback;
            this.d_lastSaveTime = AutoSave.currTime();
            this.d_timerPeriod = timerPeriod;
            this.d_hasSaved = false;
            this.d_modified = false;
            this.d_timer = null;
            this.d_tt = null;
            this.d_shutdownHook = new Thread(){

                @Override
                public void run() {
                    this.deleteSaveFile();
                }
            };
            Runtime.getRuntime().addShutdownHook(this.d_shutdownHook);
            this.setFilename(baseFilename);
            this.start();
        }

        public static boolean isAutosavePath(String path) {
            File file = new File(path);
            String name = file.getName();
            return name.startsWith("~");
        }

        public boolean isRunning() {
            return this.d_timer != null && this.d_tt != null;
        }

        private static UnitDouble currTime() {
            return new UnitDouble(System.nanoTime(), SI.NANO((Unit)SI.SECOND));
        }

        private static long toMillis(UnitDouble time) {
            return Math.round(time.getValue(SI.MILLI((Unit)SI.SECOND)));
        }

        public void setFilename(String filename) {
            this.d_baseFilename = filename;
            File autoSaveDir = this.getSaveDir(this.d_baseFilename);
            String saveFn = this.getSaveFn(this.d_baseFilename);
            File newSaveFile = null;
            if (autoSaveDir != null) {
                newSaveFile = new File(autoSaveDir, saveFn);
            } else {
                File tempFile = null;
                try {
                    tempFile = File.createTempFile(saveFn, "." + this.d_fileExtension);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                newSaveFile = tempFile;
            }
            if (theUtil.equal(newSaveFile, this.d_saveFile)) {
                return;
            }
            boolean running = this.isRunning();
            if (running) {
                this.stop();
            }
            this.deleteSaveFile();
            this.d_saveFile = newSaveFile;
            if (running) {
                this.start();
            }
        }

        public void setTimerPeriod(UnitDouble period) {
            if (period.equals(this.d_timerPeriod)) {
                return;
            }
            boolean running = this.isRunning();
            if (running) {
                this.stop();
            }
            this.d_timerPeriod = period;
            if (running) {
                this.start();
            }
        }

        public void setModified(boolean modified) {
            this.d_modified = modified;
        }

        private String getSaveFn(String baseFilename) {
            String fn = baseFilename;
            if (fn != null) {
                String sPath = fn;
                int lastSep = sPath.lastIndexOf(File.separatorChar);
                if (lastSep != -1) {
                    return "~" + sPath.substring(lastSep + 1);
                }
                return "~" + sPath;
            }
            return "~untitled" + RAND.nextInt(9999) + "." + this.d_fileExtension;
        }

        private File getSaveDir(String baseFilename) {
            File folder;
            File curFile;
            String strCurFile = baseFilename;
            File file = curFile = strCurFile != null ? new File(strCurFile) : null;
            if (curFile != null && (folder = curFile.getParentFile()).exists()) {
                return curFile.getParentFile();
            }
            return new File(System.getProperty("java.io.tmpdir"));
        }

        public void end(boolean cleanup) {
            Runtime.getRuntime().removeShutdownHook(this.d_shutdownHook);
            this.stop();
            if (cleanup) {
                this.deleteSaveFile();
            }
        }

        public boolean start() {
            assert (this.d_tt == null && this.d_timer == null);
            if (this.d_saveFile == null) {
                return false;
            }
            this.d_tt = new TimerTask(){

                @Override
                public void run() {
                    this.save();
                }
            };
            this.d_timer = new Timer("Autosave Timer");
            UnitDouble timeSinceLastSave = AutoSave.currTime().sub(this.d_lastSaveTime);
            UnitDouble remaining = this.d_timerPeriod.sub(timeSinceLastSave);
            if (remaining.getValueNoUnit() <= 0.0) {
                remaining = new UnitDouble(0.0, (Unit)SI.SECOND);
            }
            this.d_timer.schedule(this.d_tt, AutoSave.toMillis(remaining), AutoSave.toMillis(this.d_timerPeriod));
            return true;
        }

        private void stop() {
            if (this.d_tt != null) {
                this.d_tt.cancel();
                this.d_tt = null;
            }
            if (this.d_timer != null) {
                this.d_timer.cancel();
                this.d_timer = null;
            }
        }

        public String getFilePath() {
            return this.d_saveFile != null ? this.d_saveFile.getAbsolutePath() : null;
        }

        public boolean isSaved() {
            return this.d_hasSaved;
        }

        private void deleteSaveFile() {
            if (this.d_saveFile == null) {
                return;
            }
            if (this.d_saveFile.exists()) {
                System.out.println("autosave: [normal close] deleting " + this.d_saveFile);
                this.d_saveFile.delete();
            }
            this.d_saveFile = null;
        }

        public void save() {
            if (!this.d_modified) {
                return;
            }
            assert (this.d_saveFile != null);
            boolean success = false;
            try {
                this.d_callback.save(this.d_saveFile);
                success = true;
                this.d_lastSaveTime = AutoSave.currTime();
                this.d_modified = false;
                System.out.println("autosave: " + this.d_saveFile);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            if (!success) {
                System.out.println("autosave: [failed!] deleting corrupted save file");
                this.d_saveFile.delete();
            }
            this.d_hasSaved = success;
        }
    }
}

