/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import thunderheadeng.gui.SelectableAction;
import thunderheadeng.gui.guiListBuilder;
import thunderheadeng.gui.guiUtil;

public class MenuBuilder {
    private final guiListBuilder<Object> d_listBuilder = new guiListBuilder();

    public void add(String label) {
        this.d_listBuilder.add(label);
    }

    public void add(Action action) {
        if (action != null && action.isEnabled()) {
            this.d_listBuilder.add(action);
        }
    }

    public void add(JMenuItem subMenu) {
        this.d_listBuilder.add(subMenu);
    }

    public void addMutuallyExclusive(SelectableAction ... actions) {
        this.d_listBuilder.add(Arrays.asList(actions));
    }

    public void addMutuallyExclusive(Collection<? extends SelectableAction> actions) {
        this.d_listBuilder.add(new ArrayList<SelectableAction>(actions));
    }

    public void addSeparator() {
        this.d_listBuilder.addSeparator();
    }

    public JMenu buildMenu(String name) {
        JMenu menu = new JMenu(name);
        List<Object> items = this.d_listBuilder.finalizeList();
        for (Object item : items) {
            if (item == null) {
                menu.addSeparator();
                continue;
            }
            if (item instanceof String) {
                menu.add((String)item);
                continue;
            }
            if (item instanceof SelectableAction) {
                guiUtil.addSelectableMenuItem(menu, (SelectableAction)item);
                continue;
            }
            if (item instanceof Action) {
                menu.add((Action)item);
                continue;
            }
            if (item instanceof JMenuItem) {
                menu.add((JMenuItem)item);
                continue;
            }
            if (!(item instanceof List)) continue;
            guiUtil.addMEMenuItems(menu, (Collection<? extends SelectableAction>)((List)item));
        }
        if (menu.getMenuComponentCount() == 0) {
            return null;
        }
        return menu;
    }

    public JPopupMenu buildPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        List<Object> items = this.d_listBuilder.finalizeList();
        for (Object item : items) {
            if (item == null) {
                menu.addSeparator();
                continue;
            }
            if (item instanceof String) {
                menu.add((String)item);
                continue;
            }
            if (item instanceof SelectableAction) {
                guiUtil.addSelectableMenuItem(menu, (SelectableAction)item);
                continue;
            }
            if (item instanceof Action) {
                menu.add((Action)item);
                continue;
            }
            if (item instanceof JMenuItem) {
                menu.add((JMenuItem)item);
                continue;
            }
            if (!(item instanceof List)) continue;
            guiUtil.addMEMenuItems(menu, (Collection<? extends SelectableAction>)((List)item));
        }
        if (menu.getComponentCount() == 0) {
            return null;
        }
        return menu;
    }
}

