/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import thunderheadeng.gui.MRUListener;
import thunderheadeng.gui.guiMenu;
import thunderheadeng.io.MRUFileList;

public class MRUMenu
extends guiMenu {
    private MRUFileList d_mru;
    private MRUListener d_listener;

    public MRUMenu(String text, MRUFileList mru, MRUListener listener) {
        super(text);
        this.d_mru = mru;
        this.d_listener = listener;
        this.update();
    }

    public void setNumMenuItems(int num) {
        this.d_mru.setMaxEntries(num);
    }

    public int getNumMenuItems() {
        return this.d_mru.getMaxEntries();
    }

    public void usedFile(String filename) {
        this.d_mru.usedFile(filename);
        this.update();
    }

    public void removeFile(String filename) {
        this.d_mru.removeFile(filename);
        this.update();
    }

    private void update() {
        this.removeAll();
        String[] files = this.d_mru.getFileList();
        for (int i = 0; i < files.length; ++i) {
            JMenuItem item = new JMenuItem(files[i]);
            item.addActionListener(new ItemListener(files[i], i));
            this.add(item);
        }
        this.setEnabled(files.length > 0);
    }

    private class ItemListener
    implements ActionListener,
    Runnable {
        private String d_name;
        protected int d_index;

        public ItemListener(String name, int index) {
            this.d_name = name;
            this.d_index = index;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EventQueue.invokeLater(this);
        }

        @Override
        public void run() {
            if (MRUMenu.this.d_listener != null) {
                if (MRUMenu.this.d_listener.itemSelected(this.d_index, this.d_name)) {
                    MRUMenu.this.usedFile(this.d_name);
                } else {
                    MRUMenu.this.removeFile(this.d_name);
                }
            }
        }
    }
}

