/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.awt.Color;
import java.io.Closeable;
import java.util.function.IntToDoubleFunction;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import thunderheadeng.gui.ASeries;
import thunderheadeng.gui.Series;

public class LWSeries
extends ASeries
implements Closeable {
    private Supplier<IntStream> d_indexesSrc;
    private Supplier<IntToDoubleFunction> d_xSrc;
    private Supplier<IntToDoubleFunction> d_ySrc;
    private IntToDoubleFunction d_x;
    private IntToDoubleFunction d_y;
    private int d_open;

    public LWSeries(Supplier<IntStream> indexes, Supplier<IntToDoubleFunction> x, Supplier<IntToDoubleFunction> y, String name, Color color, int markType, int lineType, int weight) {
        super(name, color, markType, lineType, weight);
        this.d_xSrc = x;
        this.d_ySrc = y;
        this.d_indexesSrc = indexes;
        this.d_open = 0;
    }

    public void setData(Supplier<IntStream> indexes, Supplier<IntToDoubleFunction> x, Supplier<IntToDoubleFunction> y) {
        boolean open = this.isOpen();
        if (open) {
            this.forceClose();
        }
        this.resetBounds();
        this.d_indexesSrc = indexes;
        this.d_xSrc = x;
        this.d_ySrc = y;
        if (open) {
            this.forceOpen();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Series toSeries() {
        boolean open = this.isOpen();
        if (!open) {
            this.open();
        }
        try {
            IntStream indexes = this.d_indexesSrc.get().limit(Integer.MAX_VALUE);
            int count = (int)indexes.count();
            double[] x = new double[count];
            double[] y = new double[count];
            int[] offset = new int[]{0};
            this.d_indexesSrc.get().limit(Integer.MAX_VALUE).sequential().forEachOrdered(i -> {
                int n = offset[0];
                nArray[0] = n + 1;
                int o = n;
                dArray[o] = this.d_x.applyAsDouble(i);
                dArray2[o] = this.d_y.applyAsDouble(i);
            });
            Series series = new Series(x, y, this.getName(), this.getColor(), this.getMarkType(), this.getLineType(), this.getWeight());
            return series;
        }
        finally {
            if (!open) {
                this.close();
            }
        }
    }

    public boolean isOpen() {
        return this.d_open > 0;
    }

    public void open() {
        if (++this.d_open == 1) {
            this.forceOpen();
        }
    }

    private void forceOpen() {
        this.d_x = this.d_xSrc.get();
        this.d_y = this.d_ySrc.get();
        this.updateBounds();
    }

    @Override
    public void close() {
        if (--this.d_open == 0) {
            this.forceClose();
        }
    }

    private void forceClose() {
        this.d_x = null;
        this.d_y = null;
    }

    public void makeBoundsValid() {
        if (!this.getBoundsValid() && !this.isOpen()) {
            this.open();
            this.close();
        }
    }

    @Override
    @OpenOnce
    public double getMinX() {
        return super.getMinX();
    }

    @Override
    @OpenOnce
    public double getMaxX() {
        return super.getMaxX();
    }

    @Override
    @OpenOnce
    public double getMinY() {
        return super.getMinY();
    }

    @Override
    @OpenOnce
    public double getMaxY() {
        return super.getMaxY();
    }

    public Supplier<IntStream> getIndexesSrc() {
        return this.d_indexesSrc;
    }

    public Supplier<IntToDoubleFunction> getXSrc() {
        return this.d_xSrc;
    }

    public Supplier<IntToDoubleFunction> getYSrc() {
        return this.d_ySrc;
    }

    @Override
    public IntStream getIndexes() {
        return this.d_indexesSrc.get();
    }

    @Override
    @Open
    public IntToDoubleFunction getX() {
        assert (this.isOpen());
        return this.d_x;
    }

    @Override
    @Open
    public IntToDoubleFunction getY() {
        assert (this.isOpen());
        return this.d_y;
    }

    public static @interface OpenOnce {
    }

    public static @interface Open {
    }
}

