/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JButton;
import thunderheadeng.gui.Modifiable;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.image.IImage;
import thunderheadeng.util.IObservable;
import thunderheadeng.util.IObserver;
import thunderheadeng.util.ObservableProxy;

public class ImageBtn
extends JButton
implements Modifiable,
IObservable {
    private final ObservableProxy d_helper;
    private boolean d_modified;
    private IImage d_img;

    public ImageBtn() {
        super("<empty>");
        Insets margin = this.getMargin();
        this.setMargin(new Insets(margin.top, 3, margin.bottom, 3));
        this.setPreferredSize(this.getPreferredSize());
        this.setText("");
        this.d_helper = new ObservableProxy(this);
        this.d_modified = false;
        this.d_img = null;
        this.updateInfo();
    }

    @Override
    public void addObserver(IObserver observer, boolean weakRef) {
        this.d_helper.addObserver(observer, weakRef);
    }

    @Override
    public void deleteObserver(IObserver observer) {
        this.d_helper.deleteObserver(observer);
    }

    @Override
    public boolean isModified() {
        return this.d_modified;
    }

    @Override
    public void setModified(boolean modified) {
        if (this.d_modified == modified) {
            return;
        }
        this.d_modified = modified;
        if (this.d_modified) {
            this.d_helper.setChanged(true);
        }
    }

    public IImage getImage() {
        return this.d_img;
    }

    public void setImage(IImage img) {
        if (img == this.d_img) {
            return;
        }
        this.d_img = img;
        this.updateInfo();
        this.setModified(false);
        this.repaint();
    }

    protected void updateInfo() {
        guiUtil.initButton(this, this.d_img);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (g != null) {
            Graphics scratchGraphics = g.create();
            try {
                Dimension size = this.getSize();
                Insets insets = this.getInsets();
                int inset = Math.min(insets.left, insets.bottom);
                scratchGraphics.setClip(inset, inset, size.width - inset * 2, size.height - inset * 2);
                guiUtil.paintComponent((Component)this, scratchGraphics, this.d_img);
            }
            finally {
                scratchGraphics.dispose();
            }
        }
    }
}

