/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;

public class HoverWindow
extends JWindow {
    private final Component d_parent;
    private final MouseAdapter d_mouseListener;
    private Point d_mousePos;

    public HoverWindow(Component parent) {
        this((Window)SwingUtilities.getAncestorOfClass(Window.class, parent), parent);
    }

    public HoverWindow(Window window, Component parent) {
        super(window);
        this.d_parent = parent;
        CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.getRootPane().setBorder(border);
        Color color = (Color)UIManager.get("ToolTip.background");
        this.getContentPane().setBackground(color);
        this.d_mouseListener = new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                HoverWindow.this.setCursorLocation(e.getLocationOnScreen());
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                HoverWindow.this.setCursorLocation(e.getLocationOnScreen());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                HoverWindow.this.setCursorLocation(new Point(-1, -1));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                HoverWindow.this.setCursorLocation(e.getLocationOnScreen());
            }
        };
        this.d_mousePos = new Point(-1, -1);
    }

    public Component getAttachedComponent() {
        return this.d_parent;
    }

    public void attach() {
        this.d_parent.addMouseMotionListener(this.d_mouseListener);
        this.d_parent.addMouseListener(this.d_mouseListener);
    }

    public void detach() {
        this.d_parent.removeMouseListener(this.d_mouseListener);
        this.d_parent.removeMouseMotionListener(this.d_mouseListener);
        this.setCursorLocation(new Point(-1, -1));
    }

    public void setVisible(boolean isVisible, boolean force) {
        if (force) {
            super.setVisible(isVisible);
        } else {
            this.setVisible(isVisible);
        }
    }

    @Override
    public void setVisible(boolean isVisible) {
        Window window;
        if (isVisible && (window = SwingUtilities.getWindowAncestor(this.d_parent)) != null && !window.isFocused()) {
            return;
        }
        super.setVisible(isVisible);
    }

    protected void setCursorLocation(Point p) {
        this.d_mousePos = p;
        this.updateLocation();
        this.setVisible(p.x >= 0 && p.y >= 0);
    }

    protected void updateLocation() {
        Point p = this.d_mousePos;
        int padding = 5;
        this.setLocation(p.x + padding, p.y - padding - this.getHeight());
    }

    @Override
    public void pack() {
        super.pack();
        this.updateLocation();
    }
}

