/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;

public class HTMLLabel
extends JEditorPane {
    private int d_width;
    private String d_text;
    private String d_formatted;
    private boolean d_openLinksAsWebpages;
    private static final OpenLinksListener OPEN_LINKS_LISTENER = new OpenLinksListener();

    public HTMLLabel(String text) {
        this(text, 0);
    }

    public HTMLLabel(String text, int desiredWidth) {
        super("text/html", HTMLLabel.format(text, desiredWidth));
        this.d_text = text;
        this.d_formatted = HTMLLabel.format(text, desiredWidth);
        this.d_width = desiredWidth;
        this.setOpenLinksAsWebpages(true);
        this.setHighlighter(null);
        this.setEditable(false);
        Font font = UIManager.getFont("Label.font");
        String bodyRule = String.format("body { font-family: %s; font-size: %dpt; }", font.getFamily(), font.getSize());
        ((HTMLDocument)this.getDocument()).getStyleSheet().addRule(bodyRule);
        this.setOpaque(false);
    }

    public void setWrapEnabled(boolean enabled) {
        String whitespace = enabled ? "initial" : "nowrap";
        String rule = String.format("body { white-space: %s }", whitespace);
        ((HTMLDocument)this.getDocument()).getStyleSheet().addRule(rule);
    }

    public int getPreferredWidth() {
        return this.d_width;
    }

    public void setPreferredWidth(int width) {
        if (width == this.d_width) {
            return;
        }
        this.d_width = width;
        if (this.d_width > 0) {
            this.setMinimumSize(new Dimension(this.d_width, this.getMinimumSize().height));
            this.setPreferredSize(new Dimension(this.d_width, this.getPreferredSize().height));
        }
        this.setText(this.d_text);
        this.invalidate();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        return size;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension size = super.getMinimumSize();
        return size;
    }

    @Override
    public void setText(String t) {
        String formatted = HTMLLabel.format(t, this.d_width);
        if (!formatted.equals(this.d_formatted)) {
            this.d_text = t;
            this.d_formatted = formatted;
            super.setText(formatted);
        }
    }

    @Override
    public String getText() {
        return this.d_text;
    }

    public String getFormattedText() {
        return super.getText();
    }

    private static String format(String text, int width) {
        if (width <= 0) {
            return "<html>" + text + "</html>";
        }
        return String.format("<html><body width='%d'>%s</html>", width, text);
    }

    public void setOpenLinksAsWebpages(boolean enabled) {
        if (enabled != this.d_openLinksAsWebpages) {
            this.d_openLinksAsWebpages = enabled;
            if (enabled) {
                this.addHyperlinkListener(OPEN_LINKS_LISTENER);
            } else {
                this.removeHyperlinkListener(OPEN_LINKS_LISTENER);
            }
        }
    }

    private static class OpenLinksListener
    implements HyperlinkListener {
        private OpenLinksListener() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent evt) {
            if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                String link = evt.getDescription();
                try {
                    Desktop.getDesktop().browse(new URL(link).toURI());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

