/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import thunderheadeng.gui.HTMLLabel;

public class HTMLBtn
extends HTMLLabel {
    private List<ActionListener> d_listeners = null;

    public HTMLBtn(String text) {
        super(HTMLBtn.escape(text));
        this.setOpenLinksAsWebpages(false);
        this.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (!HTMLBtn.this.isEnabled() || e.getEventType() != HyperlinkEvent.EventType.ACTIVATED || HTMLBtn.this.d_listeners == null) {
                    return;
                }
                ActionEvent evt = new ActionEvent(e.getSource(), 1001, e.getDescription(), System.currentTimeMillis(), 0);
                for (ActionListener listener : HTMLBtn.this.getListeners()) {
                    listener.actionPerformed(evt);
                }
            }
        });
    }

    public void addActionListener(ActionListener listener) {
        if (this.d_listeners == null) {
            this.d_listeners = new ArrayList<ActionListener>(1);
        }
        if (!this.d_listeners.contains(listener)) {
            this.d_listeners.add(listener);
        }
    }

    public void removeActionListener(ActionListener listener) {
        if (this.d_listeners == null) {
            return;
        }
        this.d_listeners.remove(listener);
        if (this.d_listeners.isEmpty()) {
            this.d_listeners = null;
        }
    }

    public ActionListener[] getListeners() {
        return this.d_listeners.toArray(new ActionListener[this.d_listeners.size()]);
    }

    @Override
    public void setText(String t) {
        super.setText(HTMLBtn.escape(t));
    }

    @Override
    public String getText() {
        return super.getText();
    }

    private static String escape(String text) {
        return "<a href='dmy'>" + text + "</a>";
    }
}

