/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.awt.Color;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.IllegalComponentStateException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import thunderheadeng.Intl;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.HTMLBtn;
import thunderheadeng.gui.ICrashHandler;
import thunderheadeng.gui.OutputLog;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiSeparator;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.util.BoundedStack;
import thunderheadeng.util.Win32Native;

public class CrashCatcher
implements Thread.UncaughtExceptionHandler {
    public static final int MAX_ACTIONLOG_SIZE = 20;
    public static final int OPT_AWT = 1;
    public static final int OPT_ALL_THREADS = 2;
    private static String s_appName;
    private static String s_version;
    private static ICrashHandler s_handler;
    private static String s_supportAddr;
    private static BoundedStack<ActionLogEntry> s_actionLog;
    private CrashCatcherDlg d_mainDlg;

    public static void install(String appName, String version, ICrashHandler handler) {
        CrashCatcher.install(appName, version, handler, 1, new Thread[0]);
    }

    public static void install(String appName, String version, ICrashHandler handler, int options, Thread ... threads) {
        CrashCatcher instance;
        s_appName = appName;
        s_version = version;
        s_handler = handler;
        s_supportAddr = "support@thunderheadeng.com";
        if (CrashCatcher.test(options, 1) && !CrashCatcher.test(options, 2)) {
            SwingUtilities.invokeLater(() -> {
                CrashCatcher instance = new CrashCatcher();
                Thread.currentThread().setUncaughtExceptionHandler(instance);
            });
        } else if (CrashCatcher.test(options, 2)) {
            instance = new CrashCatcher();
            Thread.setDefaultUncaughtExceptionHandler(instance);
        }
        if (threads.length > 0) {
            instance = new CrashCatcher();
            for (Thread t : threads) {
                t.setUncaughtExceptionHandler(instance);
            }
        }
    }

    private static boolean test(int bitfield, int bit) {
        return (bitfield & bit) == bit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logAction(String action) {
        BoundedStack<ActionLogEntry> boundedStack = s_actionLog;
        synchronized (boundedStack) {
            s_actionLog.push(new ActionLogEntry(action));
        }
    }

    @Override
    public synchronized void uncaughtException(Thread thread, Throwable t) {
        if (CrashCatcher.canSafelyIgnoreException(t)) {
            return;
        }
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(() -> this.uncaughtException(thread, t));
            return;
        }
        String title = String.format(Intl.intl("%s has encountered an unknown error and must shut down."), s_appName);
        Application app = Application.getApp();
        JFrame frame = null;
        try {
            if (app != null) {
                frame = app.getMainFrame();
            }
        }
        catch (Throwable e) {
            t.printStackTrace();
        }
        this.report(frame, title, thread, t);
        System.exit(0);
    }

    public static boolean canSafelyIgnoreException(Throwable t) {
        StackTraceElement[] trace = t.getStackTrace();
        if (trace.length > 3 && trace[0].getClassName().equals("javax.swing.JComponent") && trace[0].getMethodName().equals("repaint") && trace[1].getClassName().equals("sun.swing.FilePane$2") && trace[1].getMethodName().equals("repaintListSelection") && trace[2].getClassName().equals("sun.swing.FilePane$2") && trace[2].getMethodName().equals("repaintSelection") && trace[3].getClassName().equals("sun.swing.FilePane$2") && (trace[3].getMethodName().equals("focusLost") || trace[3].getMethodName().equals("focusGained"))) {
            System.out.println("Non fatal NPE: http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=6561072");
            System.out.println("trace[3]: " + trace[3].getClassName() + trace[3].getMethodName());
            return true;
        }
        int i = 0;
        if (t instanceof IllegalComponentStateException && t.getMessage().equals("component must be showing on the screen to determine its location") && (i = CrashCatcher.indexOf(trace, i, "java.awt.Component.getLocationOnScreen_NoTreeLock")) != -1 && (i = CrashCatcher.indexOf(trace, i, "java.awt.Component.getLocationOnScreen")) != -1 && (i = CrashCatcher.indexOf(trace, i, "javax.swing.text.JTextComponent$InputMethodRequestsHandler.getTextLocation")) != -1 && (i = CrashCatcher.indexOf(trace, i, "sun.awt.im.InputMethodContext.getTextLocation")) != -1 && (i = CrashCatcher.indexOf(trace, i, "sun.awt.windows.WInputMethod$1.run")) != -1 && (i = CrashCatcher.indexOf(trace, i, "java.awt.event.InvocationEvent.dispatch")) != -1 && (i = CrashCatcher.indexOf(trace, i, "java.awt.EventDispatchThread.run")) != -1 && i == trace.length - 1) {
            System.err.println("Non fatal Exception -- occurs when tab switch follows text component deactivate/reactivate");
            System.err.println(t.getClass() + ": " + t.getMessage());
            return true;
        }
        i = 0;
        if (t instanceof InternalError && t.getMessage().equals("HTHEME is null") && (i = CrashCatcher.indexOf(trace, i, "sun.awt.windows.ThemeReader.paintBackground")) != -1) {
            System.err.println("Non fatal Error -- can occur when changing Windows themes while the application is open");
            System.err.println(t.getClass() + ": " + t.getMessage());
            return true;
        }
        return false;
    }

    public static int indexOf(StackTraceElement[] trace, int startFrom, String startsWith) {
        try {
            for (int i = startFrom; i < trace.length; ++i) {
                if (!trace[i].toString().startsWith(startsWith)) continue;
                return i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return -1;
    }

    public synchronized void report(Window parent, String title, Thread thread, Throwable t) {
        ArrayList<String> messages = new ArrayList<String>();
        File logFile = this.writeLog(t);
        if (logFile != null) {
            messages.add(Intl.intl("Log File") + ": " + logFile.getAbsolutePath());
        }
        Application app = Application.getApp();
        s_handler.cleanup(app, messages);
        this.printStack(t, System.err);
        try {
            Win32Native.ProxyConfig proxyCfg = Win32Native.getProxyConfig();
            Win32Native.setJVMDefaultProxyProps(proxyCfg);
        }
        catch (Throwable tt) {
            t.printStackTrace();
        }
        if (System.getProperty("autoreport") != null) {
            try {
                CrashCatcher.sendReport(this.buildReport(t), "", "Generated with -Dautoreport");
            }
            catch (Throwable th) {
                System.out.println("Problem sending error report.");
            }
        } else {
            this.d_mainDlg = new CrashCatcherDlg(parent, title, messages, this.buildReport(t));
            this.d_mainDlg.doModal();
        }
    }

    private void printStack(Throwable t, PrintStream ps) {
        if (t != null) {
            t.printStackTrace(ps);
            this.printStack(t.getCause(), ps);
        }
    }

    private void printStack(Throwable t, PrintWriter pw) {
        if (t != null) {
            t.printStackTrace(pw);
            this.printStack(t.getCause(), pw);
        }
    }

    private void writeHeader(PrintWriter out) {
        DateFormat dfmt = DateFormat.getDateTimeInstance(1, 1, Locale.US);
        String date = dfmt.format(new Date());
        String os = System.getProperty("os.name");
        String arch = System.getProperty("os.arch");
        String javaver = System.getProperty("java.version");
        out.printf("%s Version: %s%n", s_appName, s_version);
        out.printf("Date: %s%n", date);
        out.printf("Operating System: %s (%s)%n", os, arch);
        out.printf("Java Version: %s%n", javaver);
    }

    private File writeLog(Throwable t) {
        try {
            File f;
            String name = String.format("%s_crash", s_appName.toLowerCase());
            String logDir = s_handler.getLogFileDir();
            if (logDir == null) {
                logDir = OutputLog.getDefaultLogDir(s_appName);
            }
            if ((f = OutputLog.createLogFile(logDir, name, ".log")).getParentFile() != null) {
                f.getParentFile().mkdirs();
            }
            PrintWriter out = new PrintWriter(f);
            this.writeHeader(out);
            out.println();
            this.printStack(t, out);
            out.close();
            return f;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    private String buildReport(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.writeHeader(pw);
        pw.println();
        pw.println("Stack Trace: ");
        t.printStackTrace(pw);
        return sw.toString();
    }

    private static String[] splitFileAndLbl(String msg) {
        int cix = msg.indexOf(58);
        if (cix != -1 && cix != 0 && cix != msg.length() - 1) {
            String lbl = msg.substring(0, cix).trim();
            String filepath = msg.substring(cix + 1).trim();
            if (!lbl.isEmpty() && !filepath.isEmpty()) {
                return new String[]{lbl, filepath};
            }
        }
        return new String[]{"", ""};
    }

    public static void sendReport(String report, String replyaddr, String comments) throws Throwable {
        String line;
        String data = URLEncoder.encode("to", "UTF-8") + "=" + URLEncoder.encode(s_supportAddr, "UTF-8");
        data = data + "&" + URLEncoder.encode("appname", "UTF-8") + "=" + URLEncoder.encode(s_appName, "UTF-8");
        data = data + "&" + URLEncoder.encode("msg", "UTF-8") + "=" + URLEncoder.encode(report, "UTF-8");
        data = data + "&" + URLEncoder.encode("comment", "UTF-8") + "=" + URLEncoder.encode(comments, "UTF-8");
        if (replyaddr != null) {
            data = data + "&" + URLEncoder.encode("from", "UTF-8") + "=" + URLEncoder.encode(replyaddr, "UTF-8");
        }
        URL url = new URL("http://thunderheadeng.net/bug_report.php");
        URLConnection conn = url.openConnection();
        conn.setDoOutput(true);
        OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
        wr.write(data);
        wr.flush();
        BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        while ((line = rd.readLine()) != null) {
            System.out.println(line);
        }
        wr.close();
        rd.close();
    }

    static {
        s_actionLog = new BoundedStack(20);
    }

    private static class ActionLogEntry {
        public final String action;
        public final long date;

        public ActionLogEntry(String action) {
            this.action = action;
            this.date = System.currentTimeMillis();
        }
    }

    private static class TopBanner
    extends guiPanel {
        private String d_title;
        private Icon d_icon;

        public TopBanner() {
            this.setOpaque(true);
            this.setBackground(Color.WHITE);
            this.setMinimumSize(new Dimension(460, 50));
            this.setPreferredSize(new Dimension(460, 50));
            this.setMaximumSize(new Dimension(460, 50));
            this.d_title = null;
            this.d_icon = null;
        }

        public void setTitle(String title) {
            this.d_title = title;
        }

        public void setIcon(Icon img) {
            this.d_icon = img;
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D gfx = (Graphics2D)g;
            if (this.d_icon != null) {
                int wid = this.d_icon.getIconWidth();
                int ht = this.d_icon.getIconHeight();
                int y = (this.getHeight() - ht) / 2;
                int x = wid / 2;
                this.d_icon.paintIcon(this, gfx, x, y);
            }
            gfx.setFont(this.getFont());
            FontMetrics fMets = gfx.getFontMetrics();
            Rectangle2D mRect = fMets.getStringBounds("M", gfx);
            gfx.setColor(Color.BLACK);
            int x = (int)(mRect.getWidth() * 2.0 + (double)this.d_icon.getIconWidth() * 1.5);
            int y = (int)mRect.getHeight() * 5 / 2;
            gfx.setFont(this.getFont().deriveFont(1));
            gfx.drawString(this.d_title, x, y);
        }
    }

    public class ShowErrorReportDlg
    extends guiDialog {
        public ShowErrorReportDlg(Window owner, String message) {
            super(owner, Intl.intl("Error Report"), 1);
            JTextArea textArea = new JTextArea();
            textArea.setText(message);
            textArea.setEditable(false);
            textArea.setCaretPosition(0);
            JScrollPane sp = new JScrollPane(textArea);
            this.setPreferredSize(new Dimension(700, 500));
            this.setResizable(true);
            GridBagHelper gb = new GridBagHelper(this.getDialogPane(), true, 1, 1);
            double[] full = new double[]{1.0, 1.0};
            gb.addRow(sp, full);
        }
    }

    public class CrashCatcherDlg
    extends JDialog {
        public static final int OK = 1;
        public static final int CANCEL = 8;
        private final Window d_owner;
        private JButton d_reportBtn;
        private JButton d_cancelBtn;
        private String d_comments;
        private String d_replyAddr;
        private String d_report;
        private final JTextArea d_commentBox;
        private final guiTextField d_replyTextField;
        private final guiCheckBox d_includeActionHistory;
        private int d_status;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CrashCatcherDlg(Window owner, String title, List<String> messages, String report) {
            super(owner, String.format(Intl.intl("%s Error"), s_appName));
            this.setResizable(true);
            this.d_owner = owner;
            this.d_report = report;
            this.d_status = -1;
            Container c = this.getContentPane();
            c.setLayout(new GridBagLayout());
            TopBanner banner = new TopBanner();
            banner.setTitle(title);
            banner.setIcon(UIManager.getIcon("OptionPane.errorIcon"));
            this.d_reportBtn = new JButton(Intl.intl("Send Error Report"));
            this.d_cancelBtn = new JButton(Intl.intl("Don't Send"));
            this.d_commentBox = new JTextArea();
            this.d_commentBox.setLineWrap(true);
            this.d_commentBox.setWrapStyleWord(true);
            this.d_commentBox.setRows(5);
            JScrollPane sp = new JScrollPane(this.d_commentBox);
            this.d_replyTextField = new guiTextField();
            this.d_includeActionHistory = new guiCheckBox(Intl.intl("Include action history"), true);
            HTMLBtn viewReport = new HTMLBtn(Intl.intl("click here."));
            viewReport.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String actionLog;
                    StringBuffer message = new StringBuffer();
                    String comment = CrashCatcherDlg.this.d_commentBox.getText();
                    String replyAddr = CrashCatcherDlg.this.d_replyTextField.getText();
                    if (!replyAddr.isEmpty()) {
                        message.append(Intl.intl("Reply Address: ") + replyAddr + "\n\n");
                    }
                    if (!comment.isEmpty()) {
                        message.append(Intl.intl("User Comment: ") + comment + "\n\n");
                    }
                    String string = actionLog = CrashCatcherDlg.this.d_includeActionHistory.isSelected() ? CrashCatcherDlg.this.formatActionLog() : "";
                    if (!actionLog.isEmpty()) {
                        message.append(actionLog);
                        message.append("\n\n");
                    }
                    message.append(CrashCatcherDlg.this.d_report);
                    ShowErrorReportDlg dlg = new ShowErrorReportDlg(CrashCatcherDlg.this.d_owner, message.toString());
                    dlg.doModal();
                }
            });
            guiPanel buttons = new guiPanel();
            GridBagHelper gb = new GridBagHelper(buttons);
            gb.addRow(this.d_reportBtn, this.d_cancelBtn);
            guiPanel contentPnl = new guiPanel();
            gb = new GridBagHelper(contentPnl);
            for (String msg : messages) {
                boolean added = false;
                String[] split = CrashCatcher.splitFileAndLbl(msg);
                if (!split[0].isEmpty() && !split[1].isEmpty()) {
                    String lbl = split[0] + ":";
                    String filepath = split[1];
                    File file = new File(filepath);
                    if (file.isFile() && file.getParentFile() != null) {
                        HTMLBtn fileBtn = new HTMLBtn(file.getName());
                        fileBtn.setToolTipText(file.getAbsolutePath());
                        String name = file.getName();
                        String ext = FilenameManager.splitFilename(name)[1];
                        File openFile = ext.equalsIgnoreCase("txt") || ext.equalsIgnoreCase("htm") || ext.equalsIgnoreCase("pdf") || ext.equalsIgnoreCase("html") || ext.equalsIgnoreCase("log") ? file : file.getParentFile();
                        fileBtn.addActionListener(evt -> this.openFile(openFile));
                        gb.addRow(lbl, fileBtn, 1.0, 0);
                        added = true;
                    }
                }
                if (added) continue;
                gb.addRow(msg, 0);
            }
            gb.addRowSpace(2);
            gb.addRow(Intl.intl("What were you doing at the time of the crash?"), 0);
            gb.addRow(sp, new double[]{1.0, 1.0}, new int[]{0, 1});
            BoundedStack boundedStack = s_actionLog;
            synchronized (boundedStack) {
                if (s_actionLog.size() > 0) {
                    gb.addRow(this.d_includeActionHistory, 0);
                }
            }
            gb.addRowSpace(2);
            gb.addRow(Intl.intl("Please enter your email address to help us fix this bug."), 0);
            gb.addRow(Intl.intl("Reply address:"), 3, this.d_replyTextField, 1.0, 0);
            gb.addRowSpace(2);
            gb.addRow(Intl.intl("To see what data this error report contains, "), 5, viewReport, 1.0, 0);
            guiPanel mainPanel = new guiPanel();
            gb = new GridBagHelper(mainPanel, true);
            gb.addRow(contentPnl, new double[]{1.0, 1.0});
            gb.addRowSpace(2);
            gb.addRow(new Object[]{buttons, GridBagHelper.Anchor.RIGHT});
            gb = new GridBagHelper(c);
            gb.addFilledRow(banner);
            gb.pushSpacing(0, 0);
            gb.addFilledRow(new guiSeparator());
            gb.popSpacing();
            gb.addRow(mainPanel, new double[]{1.0, 1.0});
            this.d_reportBtn.addActionListener(evt -> {
                try {
                    this.sendReport();
                    JOptionPane.showMessageDialog(this, Intl.intl("Error report sent."), Intl.intl("Reporting Finished"), 1);
                }
                catch (Throwable t) {
                    guiUtil.showError(this, Intl.intl("Error Reporting"), Intl.intl("Problem sending error report"), t);
                }
                finally {
                    this.d_status = 1;
                    this.setVisible(false);
                }
            });
            this.d_cancelBtn.addActionListener(evt -> {
                this.d_status = 8;
                this.setVisible(false);
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String formatActionLog() {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            PrintWriter writer = new PrintWriter(buffer);
            BoundedStack boundedStack = s_actionLog;
            synchronized (boundedStack) {
                if (s_actionLog.size() > 0) {
                    writer.println("Action History:");
                    Date date = new Date(0L);
                    DateFormat dateFormat = DateFormat.getTimeInstance();
                    List actionLog = s_actionLog.toList();
                    for (int m = actionLog.size() - 1; m >= 0; --m) {
                        ActionLogEntry entry = (ActionLogEntry)actionLog.get(m);
                        date.setTime(entry.date);
                        writer.printf("\t%s: %s", dateFormat.format(date), entry.action);
                        if (m == 0) continue;
                        writer.println();
                    }
                }
            }
            writer.flush();
            return buffer.toString();
        }

        public int doModal() {
            this.d_status = 8;
            this.setSize(this.getPreferredSize());
            this.setModal(true);
            this.setLocationRelativeTo(this.getParent());
            this.setVisible(true);
            return this.d_status;
        }

        public void sendReport() throws Throwable {
            String actionStr;
            this.d_comments = this.d_commentBox.getText();
            if (this.d_includeActionHistory.isSelected() && !(actionStr = this.formatActionLog()).isEmpty()) {
                if (!this.d_comments.isEmpty()) {
                    this.d_comments = this.d_comments + "\n\n";
                }
                this.d_comments = this.d_comments + actionStr;
            }
            if (this.d_replyTextField.getValue().trim().isEmpty()) {
                this.d_replyAddr = this.d_replyTextField.getText();
            }
            CrashCatcher.sendReport(this.d_report, this.d_replyAddr, this.d_comments);
        }

        private void openFile(File d_file) {
            try {
                if (!Desktop.isDesktopSupported()) {
                    throw new Exception(Intl.intl("Unable to open file."));
                }
                Desktop.getDesktop().open(d_file);
            }
            catch (Throwable t) {
                guiUtil.showError(this, Intl.intl("Error"), Intl.intl("Unable to open file"), t);
            }
        }
    }
}

