/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.util.Filters;

public class CollResult<ResT, CollT extends ResT>
implements IResult<ResT> {
    public final Class<CollT> type;
    public final Predicate<? super CollT> filter;
    public final Collection<CollT> coll;

    public CollResult() {
        this(new ArrayList());
    }

    public CollResult(Class<CollT> type) {
        this(new ArrayList(), type);
    }

    public CollResult(Class<CollT> type, Predicate<? super CollT> filter) {
        this(new ArrayList(), type, filter);
    }

    public CollResult(Collection<CollT> coll) {
        this(coll, null);
    }

    public CollResult(Collection<CollT> coll, Class<CollT> type) {
        this(coll, type, Filters.acceptAll());
    }

    public CollResult(Collection<CollT> coll, Class<CollT> type, Predicate<? super CollT> filter) {
        this.coll = coll;
        this.type = type;
        this.filter = filter;
    }

    @Override
    public void mark(ResT obj, Containment ctmt) {
        if (this.type == null || this.type.isInstance(obj) && this.filter.test(obj)) {
            this.coll.add(obj);
        }
    }
}

