/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs.transform;

import java.awt.geom.NoninvertibleTransformException;
import java.io.Serializable;
import javax.vecmath.Matrix4d;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.IdentityXform;

public class MirrorXform
implements ITransform,
Serializable {
    private static final long serialVersionUID = 1L;
    public final Plane3d plane;

    public MirrorXform(Plane3d plane) {
        this.plane = plane;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof MirrorXform && ((MirrorXform)obj).plane.equals(this.plane);
    }

    public int hashCode() {
        return 0x13BEA8F ^ this.plane.hashCode();
    }

    @Override
    public Matrix4d toMatrix(boolean modifiable) {
        double px2 = 2.0 * this.plane.x;
        double py2 = 2.0 * this.plane.y;
        double pz2 = 2.0 * this.plane.z;
        return new Matrix4d(1.0 - px2 * this.plane.x, -px2 * this.plane.y, -px2 * this.plane.z, -px2 * this.plane.w, -py2 * this.plane.x, 1.0 - py2 * this.plane.y, -py2 * this.plane.z, -py2 * this.plane.w, -pz2 * this.plane.x, -pz2 * this.plane.y, 1.0 - pz2 * this.plane.z, -pz2 * this.plane.w, 0.0, 0.0, 0.0, 1.0);
    }

    @Override
    public ITransform concatenate(ITransform xform) {
        if (xform instanceof MirrorXform) {
            MirrorXform mxform = (MirrorXform)xform;
            if (mxform.plane.equals(this.plane)) {
                return IdentityXform.INSTANCE;
            }
        }
        return ITransform.super.concatenate(xform);
    }

    @Override
    public ITransform invert() throws NoninvertibleTransformException {
        return this;
    }

    @Override
    public boolean isInvertible() {
        return true;
    }

    @Override
    public boolean isIdentity() {
        return false;
    }

    public String toString() {
        return String.format("Mirror: (%s, %s, %s, %s)", Double.toString(this.plane.x), Double.toString(this.plane.y), Double.toString(this.plane.z), Double.toString(this.plane.w));
    }
}

