/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs.transform;

import java.awt.geom.NoninvertibleTransformException;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.Intl;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.IdentityXform;

public class MatrixXform
implements ITransform {
    static final long serialVersionUID = 1L;
    public final Matrix4d xform;

    public MatrixXform(Matrix4d xform) {
        this.xform = xform;
    }

    @Override
    public Matrix4d toMatrix(boolean modifiable) {
        if (!modifiable) {
            return this.xform;
        }
        return new Matrix4d(this.xform);
    }

    @Override
    public ITransform concatenate(ITransform xform) {
        if (xform instanceof MatrixXform) {
            Matrix4d result = this.toMatrix(true);
            result.mul(((MatrixXform)xform).xform);
            return new MatrixXform(result);
        }
        return ITransform.super.concatenate(xform);
    }

    @Override
    public ITransform invert() throws NoninvertibleTransformException {
        Matrix4d mat = this.toMatrix(true);
        try {
            mat.invert();
        }
        catch (Throwable t) {
            throw new NoninvertibleTransformException(Intl.intl("Non-invertible transform matrix."));
        }
        return new MatrixXform(mat);
    }

    @Override
    public boolean isInvertible() {
        try {
            this.invert();
            return true;
        }
        catch (NoninvertibleTransformException e) {
            return false;
        }
    }

    @Override
    public ITransform optimize() {
        if (this.isIdentity()) {
            return IdentityXform.INSTANCE;
        }
        return ITransform.super.optimize();
    }

    @Override
    public ITransform.ITransformer getTransformer() {
        return new ITransform.ITransformer(){

            @Override
            public void transform(Point3d p) {
                MatrixXform.this.xform.transform(p);
            }

            @Override
            public void transform(Vector3d v) {
                MatrixXform.this.xform.transform(v);
            }
        };
    }

    @Override
    public boolean isIdentity() {
        return this.xform.equals(GeomConstants.IDENTITY4d);
    }

    public String toString() {
        return String.format("Matrix: %s", this.xform.toString());
    }
}

