/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs.transform;

import java.awt.geom.NoninvertibleTransformException;
import java.io.Serializable;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.objs.transform.ConcatTransform;
import thunderheadeng.geometry.objs.transform.TransformInfo;

public interface ITransform
extends Serializable {
    public Matrix4d toMatrix(boolean var1);

    default public ITransform concatenate(ITransform xform) {
        if (xform.isIdentity()) {
            return this;
        }
        return new ConcatTransform(this, xform);
    }

    default public ITransform optimize() {
        return this;
    }

    default public ITransformer getTransformer() {
        final Matrix4d mat = this.toMatrix(false);
        return new ITransformer(){

            @Override
            public void transform(Point3d p) {
                mat.transform(p);
            }

            @Override
            public void transform(Vector3d v) {
                mat.transform(v);
            }
        };
    }

    public boolean isIdentity();

    public ITransform invert() throws NoninvertibleTransformException;

    public boolean isInvertible();

    default public TransformInfo getInfo() {
        return new TransformInfo(this);
    }

    public static interface ITransformer {
        default public void transform(Point3d ... points) {
            for (Point3d p : points) {
                this.transform(p);
            }
        }

        public void transform(Point3d var1);

        default public void transform(Vector3d ... vectors) {
            for (Vector3d p : vectors) {
                this.transform(p);
            }
        }

        public void transform(Vector3d var1);
    }
}

