/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs.transform;

import java.awt.geom.NoninvertibleTransformException;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.objs.transform.ITransform;

public class ConcatTransform
implements ITransform {
    static final long serialVersionUID = 1L;
    public final ITransform left;
    public final ITransform right;

    public ConcatTransform(ITransform left, ITransform right) {
        this.left = left;
        this.right = right;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof ConcatTransform && ((ConcatTransform)obj).left.equals(this.left) && ((ConcatTransform)obj).right.equals(this.right);
    }

    public int hashCode() {
        return 0xB89B23FA ^ this.left.hashCode() + this.right.hashCode();
    }

    @Override
    public Matrix4d toMatrix(boolean newXform) {
        Matrix4d xform = this.left.toMatrix(true);
        xform.mul(this.right.toMatrix(false));
        return xform;
    }

    @Override
    public ITransform invert() throws NoninvertibleTransformException {
        return new ConcatTransform(this.right.invert(), this.left.invert());
    }

    @Override
    public boolean isInvertible() {
        return this.left.isInvertible() && this.right.isInvertible();
    }

    @Override
    public ITransform optimize() {
        ITransform oleft = this.left.optimize();
        ITransform oright = this.right.optimize();
        return oleft.concatenate(oright);
    }

    @Override
    public ITransform.ITransformer getTransformer() {
        final ITransform.ITransformer tright = this.right.getTransformer();
        final ITransform.ITransformer tleft = this.left.getTransformer();
        return new ITransform.ITransformer(){

            @Override
            public void transform(Point3d p) {
                tright.transform(p);
                tleft.transform(p);
            }

            @Override
            public void transform(Vector3d v) {
                tright.transform(v);
                tleft.transform(v);
            }
        };
    }

    @Override
    public boolean isIdentity() {
        return this.left.isIdentity() && this.right.isIdentity();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.left.toString());
        builder.append(" <- ");
        builder.append(this.right.toString());
        return builder.toString();
    }
}

