/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs.elem;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.vecmath.Point2d;
import thunderheadeng.geometry.objs.elem.ElementBuilder;
import thunderheadeng.geometry.objs.elem.ElementBuilders;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.ListMap;

public class ElementsBuilder {
    private final Map<Elements.ElemProp<?>, ElementBuilder<?>> d_elements = new HashMap();
    private final Map<String, ElementBuilder<Point2d>> d_uvElements = new ListMap<String, ElementBuilder<Point2d>>();
    private final int[] d_primsAdded = new int[]{0};
    private static final Function<Elements.ElemProp<?>, ElementBuilder<?>> s_newBuilder = el -> new ElementBuilder((IElemSource)el.defVal);
    private final Function<String, ElementBuilder<Point2d>> s_newUVBuilder = el -> ElementBuilders.uv();

    public void add(IPropertySet elements, int numPrims) {
        for (Elements.ElemProp<?> elemProp : Elements.FIXED) {
            this.add(elemProp, (IElemSource)elements.get(elemProp), numPrims);
        }
        for (Map.Entry entry : elements.get(Elements.UV).entrySet()) {
            this.addUV((String)entry.getKey(), (IElemSource)entry.getValue(), numPrims);
        }
        this.d_primsAdded[0] = this.d_primsAdded[0] + numPrims;
    }

    public void addRange(IPropertySet elements, int begin, int count) {
        for (Elements.ElemProp<?> elemProp : Elements.FIXED) {
            this.add(elemProp, ((IElemSource)elements.get(elemProp)).subset(begin, count), count);
        }
        for (Map.Entry entry : elements.get(Elements.UV).entrySet()) {
            this.addUV((String)entry.getKey(), ((IElemSource)entry.getValue()).subset(begin, count), count);
        }
        this.d_primsAdded[0] = this.d_primsAdded[0] + count;
    }

    private void matchPrimCount(ElementBuilder<Point2d> builder) {
        if (builder.getNumPrims() < this.d_primsAdded[0]) {
            builder.add(Elements.NO_UV, this.d_primsAdded[0] - builder.getNumPrims());
        }
    }

    public <ElemT> void add(Elements.ElemProp<ElemT> prop, IElemSource<ElemT> elems, int count) {
        this.d_elements.computeIfAbsent(prop, s_newBuilder).add(elems, count);
    }

    public void addUV(String uvSet, IElemSource<Point2d> elems, int count) {
        ElementBuilder<Point2d> builder = this.d_uvElements.computeIfAbsent(uvSet, this.s_newUVBuilder);
        this.matchPrimCount(builder);
        builder.add(elems, count);
    }

    public void next(int count) {
        this.d_primsAdded[0] = this.d_primsAdded[0] + count;
    }

    public IPropertySet finish() {
        IPropertySet elements = Elements.newElements();
        for (Map.Entry<Elements.ElemProp<?>, ElementBuilder<?>> entry : this.d_elements.entrySet()) {
            elements.setIfNotDefault((IPropertySet.Prop)entry.getKey(), entry.getValue().finish());
        }
        ListMap<String, IElemSource<Point2d>> uvs = new ListMap<String, IElemSource<Point2d>>();
        for (Map.Entry<String, ElementBuilder<Point2d>> entry : this.d_uvElements.entrySet()) {
            this.matchPrimCount(entry.getValue());
            uvs.put(entry.getKey(), entry.getValue().finish());
        }
        elements.setIfNotDefault(Elements.UV, uvs);
        return Elements.finalizeElements(elements);
    }
}

