/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs.elem;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.UnaryOperator;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.elem.ElementMesh;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.util.RepeatedList;
import thunderheadeng.util.theUtil;

public class ElementPoly<ElemT>
implements IElemSource<ElemT>,
Serializable {
    static final long serialVersionUID = 1L;
    public final ElemT[] elements;

    public ElementPoly(ElemT ... elements) {
        assert (elements.length > 0);
        this.elements = elements;
    }

    @Override
    public int getNumPrims() {
        return -1;
    }

    @Override
    public boolean isComposite() {
        return false;
    }

    @Override
    public IElemSource<ElemT> postConcatenate(IElemSource<ElemT> source) {
        return null;
    }

    @Override
    public IElemSource<ElemT> preConcatenate(IElemSource<ElemT> source) {
        return null;
    }

    @Override
    public IElemSource<ElemT> subset(int begin, int length) {
        return this;
    }

    @Override
    public IElemSource<ElemT> getPrimSource(int ix) {
        return this;
    }

    @Override
    public ElemT getPrimVertElement(int primix, int vix) {
        return this.elements[vix];
    }

    @Override
    public ElementMesh<ElemT> generate(Class<ElemT> type, List<? extends IPolygon> prims, IElemSource<Elements.Orient> primOrients, IPropsSrc props, int vertsPerPrim, boolean optimize) {
        assert (!prims.isEmpty() && vertsPerPrim == this.elements.length);
        if (prims.size() == 1) {
            return new ElementMesh<ElemT>(ElementMesh.Mapping.PER_PRIM_VERTEX, this.elements, vertsPerPrim);
        }
        int[] ixes = new int[vertsPerPrim * prims.size()];
        int m = 0;
        while (m < ixes.length) {
            int n = 0;
            while (n < vertsPerPrim) {
                ixes[m++] = n++;
            }
        }
        return new ElementMesh<ElemT>(ElementMesh.Mapping.PER_PRIM_VERTEX, this.elements, ixes, vertsPerPrim);
    }

    @Override
    public List<ElemT> generate(Class<ElemT> type, List<? extends IPolygon> prims, IElemSource<Elements.Orient> primOrients, IPropsSrc props) {
        if (prims.isEmpty()) {
            return Collections.emptyList();
        }
        assert (prims.stream().allMatch(p -> p instanceof IPolygon && this.elements.length == p.getNumVerts()));
        List<ElemT> elems = Arrays.asList(this.elements);
        if (prims.size() == 1) {
            return elems;
        }
        return new RepeatedList<ElemT>(elems, prims.size());
    }

    @Override
    public ElementPoly<ElemT> transform(Class<ElemT> type, UnaryOperator<ElemT> xform) {
        ElemT[] newElems = theUtil.lazyTransform(this.elements, type, xform);
        return newElems == this.elements ? this : new ElementPoly<ElemT>(newElems);
    }
}

