/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs.elem;

import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.UnaryOperator;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.elem.ElementSubList;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.util.FlattenedList;
import thunderheadeng.util.theUtil;

public class ElementGroup<ElemT>
implements IElemSource<ElemT>,
Serializable {
    static final long serialVersionUID = 1L;
    public final Entry<ElemT>[] entries;
    public final int numPrims;
    public final IElemSource<ElemT> defSrc;
    private transient SoftReference<int[]> d_entryOffsets = null;

    public ElementGroup(Entry[] entries, int numPrims, IElemSource<ElemT> defSrc) {
        assert (entries.length > 0);
        this.entries = entries;
        this.numPrims = numPrims;
        this.defSrc = defSrc;
    }

    protected int[] getEntryOffsets() {
        int[] offsets;
        if (this.d_entryOffsets != null && (offsets = this.d_entryOffsets.get()) != null) {
            return offsets;
        }
        offsets = this.calcEntryOffsets();
        this.d_entryOffsets = new SoftReference<int[]>(offsets);
        return offsets;
    }

    private int[] calcEntryOffsets() {
        ArrayList<Integer> offsets = new ArrayList<Integer>();
        Entry<ElemT> prevEntry = null;
        for (int m = 0; m < this.entries.length; ++m) {
            Entry<ElemT> entry = this.entries[m];
            if (prevEntry == null && entry.primBegin > 0 || prevEntry != null && entry.primBegin > prevEntry.primEnd) {
                offsets.add(-m - 1);
            }
            offsets.add(m);
            prevEntry = entry;
        }
        if (this.entries.length > 0 && this.numPrims > this.entries[this.entries.length - 1].primEnd) {
            offsets.add(-this.entries.length - 1);
        }
        return theUtil.toIntArray(offsets);
    }

    @Override
    public int getNumPrims() {
        return this.numPrims;
    }

    @Override
    public IElemSource<ElemT> postConcatenate(IElemSource<ElemT> source) {
        return null;
    }

    @Override
    public IElemSource<ElemT> preConcatenate(IElemSource<ElemT> source) {
        return null;
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    @Override
    public ElementGroup<ElemT> transform(Class<ElemT> type, UnaryOperator<ElemT> xform) {
        Entry[] newEntries = theUtil.lazyTransform(this.entries, Entry.class, entry -> entry.transform(type, xform));
        IElemSource<ElemT> newDefSrc = this.defSrc.transform(type, xform);
        return newEntries == this.entries && newDefSrc == this.defSrc ? this : new ElementGroup<ElemT>(newEntries, this.numPrims, newDefSrc);
    }

    private int findIx(int primIx) {
        assert (primIx >= 0);
        int result = Arrays.binarySearch(this.entries, (Object)primIx);
        if (result < 0) {
            result = -result - 2;
        }
        return result;
    }

    private Entry<ElemT> find(int primIx) {
        int ix = this.findIx(primIx);
        if (ix < 0) {
            return null;
        }
        Entry<ElemT> entry = this.entries[ix];
        return primIx >= entry.primEnd ? null : entry;
    }

    @Override
    public IElemSource<ElemT> getPrimSource(int ix) {
        int eix = this.findIx(ix);
        if (eix < 0) {
            return this.defSrc;
        }
        Entry<ElemT> entry = this.entries[eix];
        if (ix >= entry.primEnd) {
            return this.defSrc;
        }
        return entry.gen.getPrimSource(ix - entry.primBegin);
    }

    @Override
    public Iterator<IElemSource<ElemT>> getPrimIterator(int offset) {
        return new PrimIt(offset);
    }

    @Override
    public ElemT getPrimVertElement(int primix, int vix) {
        int eix = this.findIx(primix);
        if (eix < 0) {
            return this.defSrc.getPrimVertElement(0, vix);
        }
        Entry<ElemT> entry = this.entries[eix];
        if (primix >= entry.primEnd) {
            return this.defSrc.getPrimVertElement(0, vix);
        }
        return entry.gen.getPrimVertElement(primix - entry.primBegin, vix);
    }

    @Override
    public IElemSource<ElemT> subset(int begin, int length) {
        if (begin == 0 && length == this.numPrims) {
            return this;
        }
        int endIx = begin + length - 1;
        int entryix = this.findIx(begin);
        if (entryix < 0 || begin >= this.entries[entryix].primEnd) {
            if (entryix >= this.entries.length - 1) {
                return this.defSrc;
            }
            Entry<ElemT> nextEntry = this.entries[entryix + 1];
            if (endIx < nextEntry.primBegin) {
                return this.defSrc;
            }
        } else if (endIx < this.entries[entryix].primEnd) {
            Entry<ElemT> entry = this.entries[entryix];
            return entry.gen.subset(begin - entry.primBegin, length);
        }
        return new ElementSubList(this, begin, length);
    }

    @Override
    public List<ElemT> generate(Class<ElemT> type, List<? extends IPolygon> prims, IElemSource<Elements.Orient> primOrients, IPropsSrc props) {
        return new FlattenedList(new EList(type, prims, primOrients, props));
    }

    private class EList
    extends AbstractList<List<ElemT>> {
        private final Class<ElemT> type;
        private final List<? extends IPolygon> prims;
        private final IElemSource<Elements.Orient> primOrients;
        private final IPropsSrc props;

        public EList(Class<ElemT> type, List<? extends IPolygon> prims, IElemSource<Elements.Orient> primOrients, IPropsSrc props) {
            this.type = type;
            this.prims = prims;
            this.primOrients = primOrients;
            this.props = props;
        }

        @Override
        public int size() {
            return ElementGroup.this.getEntryOffsets().length;
        }

        @Override
        public List<ElemT> get(int index) {
            int offset = ElementGroup.this.getEntryOffsets()[index];
            if (offset >= 0) {
                Entry entry = ElementGroup.this.entries[offset];
                int nentries = entry.primEnd - entry.primBegin;
                return ElementGroup.this.entries[offset].gen.generate(this.type, this.prims.subList(entry.primBegin, entry.primEnd), this.primOrients.subset(entry.primBegin, nentries), this.props.subset(entry.primBegin, nentries));
            }
            int lb = -offset - 2;
            int ub = lb + 1;
            int pbegin = lb < 0 ? 0 : ElementGroup.this.entries[lb].primEnd;
            int pend = ub >= ElementGroup.this.entries.length ? ElementGroup.this.numPrims : ElementGroup.this.entries[ub].primBegin;
            int pcount = pend - pbegin;
            return ElementGroup.this.defSrc.generate(this.type, this.prims.subList(pbegin, pend), this.primOrients.subset(pbegin, pcount), this.props.subset(pbegin, pcount));
        }
    }

    private class PrimIt
    implements Iterator<IElemSource<ElemT>> {
        private int ix;
        private int eix;
        private Iterator<IElemSource<ElemT>> entryit;

        private PrimIt(int ix) {
            this.ix = ix;
            this.eix = ElementGroup.this.findIx(ix);
            this.entryit = this.eix < 0 || ix >= ElementGroup.this.entries[this.eix].primEnd ? null : ElementGroup.this.entries[this.eix].gen.getPrimIterator(ix - ElementGroup.this.entries[this.eix].primBegin);
        }

        @Override
        public boolean hasNext() {
            return this.ix < ElementGroup.this.numPrims;
        }

        @Override
        public IElemSource<ElemT> next() {
            IElemSource next;
            if (this.eix < 0) {
                next = ElementGroup.this.defSrc;
                ++this.ix;
                if (ElementGroup.this.entries.length > 0 && this.ix >= ElementGroup.this.entries[0].primBegin) {
                    this.eix = 0;
                    this.entryit = ElementGroup.this.entries[0].gen.getPrimIterator(0);
                }
            } else {
                Entry entry = ElementGroup.this.entries[this.eix];
                if (this.ix >= entry.primEnd) {
                    next = ElementGroup.this.defSrc;
                    ++this.ix;
                    this.tryEnterNextRange();
                } else {
                    next = this.entryit.next();
                    ++this.ix;
                    if (this.ix >= entry.primEnd && !this.tryEnterNextRange()) {
                        this.entryit = null;
                    }
                }
            }
            return next;
        }

        private boolean tryEnterNextRange() {
            if (this.eix < ElementGroup.this.entries.length - 1 && this.ix >= ElementGroup.this.entries[this.eix + 1].primBegin) {
                ++this.eix;
                this.entryit = ElementGroup.this.entries[this.eix].gen.getPrimIterator(0);
                return true;
            }
            return false;
        }
    }

    public static class Entry<ElemT>
    implements Serializable,
    Comparable<Integer> {
        static final long serialVersionUID = 1L;
        public final int primBegin;
        public final int primEnd;
        public IElemSource<ElemT> gen;

        public Entry(IElemSource<ElemT> gen, int primBegin, int primEnd) {
            this.primBegin = primBegin;
            this.primEnd = primEnd;
            this.gen = gen;
        }

        @Override
        public int compareTo(Integer o) {
            return this.primBegin - o;
        }

        public Entry<ElemT> transform(Class<ElemT> type, UnaryOperator<ElemT> op) {
            IElemSource<ElemT> newSource = this.gen.transform(type, op);
            return newSource == this.gen ? this : new Entry<ElemT>(newSource, this.primBegin, this.primEnd);
        }
    }
}

