/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs.elem;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import thunderheadeng.geometry.objs.elem.ElementFlattened;
import thunderheadeng.geometry.objs.elem.ElementGroup;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.util.theUtil;

public class ElementBuilder<ElemT> {
    private final IElemSource<ElemT> d_emptySrc;
    private final Deque<BEntry<ElemT>> d_entries;

    public ElementBuilder(IElemSource<ElemT> emptySrc) {
        this.d_emptySrc = emptySrc;
        this.d_entries = new ArrayDeque<BEntry<ElemT>>();
    }

    private static <ElemT> void addEntry(Deque<BEntry<ElemT>> entries, List<IElemSource<ElemT>> primList) {
        if (primList.isEmpty()) {
            return;
        }
        int offset = entries.isEmpty() ? 0 : entries.getLast().primEnd;
        IElemSource gen = primList.size() == 1 ? primList.get(0) : new ElementFlattened(theUtil.toArray(primList, IElemSource.class));
        entries.addLast(new BEntry(gen, offset, offset + primList.size()));
    }

    public IElemSource<ElemT> finish() {
        if (this.d_entries.isEmpty()) {
            return this.d_emptySrc;
        }
        ArrayDeque<BEntry<ElemT>> entries = new ArrayDeque<BEntry<ElemT>>();
        ArrayList<IElemSource<ElemT>> primList = new ArrayList<IElemSource<ElemT>>();
        for (BEntry<ElemT> entry : this.d_entries) {
            if (entry.primEnd - entry.primBegin == 1) {
                primList.add(entry.gen);
                continue;
            }
            if (!primList.isEmpty()) {
                ElementBuilder.addEntry(entries, primList);
                primList.clear();
            }
            entries.add(entry);
        }
        ElementBuilder.addEntry(entries, primList);
        if (entries.size() == 1) {
            return ((BEntry)entries.getFirst()).gen;
        }
        int numPrims = entries.isEmpty() ? 0 : ((BEntry)entries.getLast()).primEnd;
        ArrayList entriesList = new ArrayList(entries.size());
        for (BEntry bEntry : entries) {
            if (bEntry.gen == this.d_emptySrc) continue;
            entriesList.add(bEntry.toEntry());
        }
        return new ElementGroup<ElemT>(theUtil.toArray(entriesList, ElementGroup.Entry.class), numPrims, this.d_emptySrc);
    }

    public void add(Iterator<? extends IElemSource<ElemT>> it, int count) {
        for (int m = 0; m < count; ++m) {
            assert (it.hasNext());
            this.add(it.next(), 1);
        }
    }

    public void add(List<? extends IElemSource<ElemT>> list) {
        int count = list.size();
        for (int m = 0; m < count; ++m) {
            this.add(list.get(m), 1);
        }
    }

    public void add(IElemSource<ElemT> gen, int numPrims) {
        if (numPrims <= 0) {
            return;
        }
        assert (gen.isUnbounded() || gen.getNumPrims() >= numPrims);
        if (gen instanceof ElementGroup) {
            int count;
            int remaining = numPrims;
            ElementGroup group = (ElementGroup)gen;
            for (int m = 0; m < group.entries.length && remaining > 0; remaining -= count, ++m) {
                ElementGroup.Entry entry = group.entries[m];
                int poffset = numPrims - remaining;
                int numDef = Math.min(entry.primBegin - poffset, remaining);
                if (numDef > 0) {
                    this.add(group.defSrc, numDef);
                    if ((remaining -= numDef) == 0) break;
                }
                count = Math.min(entry.primEnd - entry.primBegin, remaining);
                this.add(entry.gen, count);
            }
            if (remaining > 0) {
                this.add(group.defSrc, remaining);
            }
            return;
        }
        if (gen.isComposite()) {
            Iterator<IElemSource<ElemT>> it = gen.getPrimIterator();
            for (int m = 0; m < numPrims; ++m) {
                this.add(it.next(), 1);
            }
            return;
        }
        if (!this.d_entries.isEmpty()) {
            BEntry<ElemT> prevEntry = this.d_entries.getLast();
            if (gen.isUnbounded() && prevEntry.gen.isUnbounded() && prevEntry.gen.equals(gen)) {
                prevEntry.primEnd += numPrims;
                return;
            }
            IElemSource concat = prevEntry.gen.postConcatenate(gen);
            if (concat != null) {
                prevEntry.gen = concat;
                prevEntry.primEnd += numPrims;
                return;
            }
            concat = gen.preConcatenate(prevEntry.gen);
            if (concat != null) {
                prevEntry.gen = concat;
                prevEntry.primEnd += numPrims;
                return;
            }
        }
        int primBegin = this.d_entries.isEmpty() ? 0 : this.d_entries.getLast().primEnd;
        int primEnd = primBegin + numPrims;
        this.d_entries.add(new BEntry<ElemT>(gen, primBegin, primEnd));
    }

    public int getNumPrims() {
        return this.d_entries.isEmpty() ? 0 : this.d_entries.getLast().primEnd;
    }

    private static class BEntry<ElemT> {
        public final int primBegin;
        public int primEnd;
        public IElemSource<ElemT> gen;

        public BEntry(IElemSource<ElemT> gen, int primBegin, int primEnd) {
            this.primBegin = primBegin;
            this.primEnd = primEnd;
            this.gen = gen;
        }

        public ElementGroup.Entry<ElemT> toEntry() {
            return new ElementGroup.Entry<ElemT>(this.gen, this.primBegin, this.primEnd);
        }
    }
}

