/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs;

import java.util.List;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.AFace;
import thunderheadeng.geometry.objs.IBoxCollector;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IIsectCollector;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.util.CancelledException;
import thunderheadeng.util.Pair;

public class Sphere
extends AFace {
    private static final long serialVersionUID = 1L;
    public final Point3d center;
    public final double radius;

    public Sphere(Point3d center, double radius) {
        this.center = center;
        this.radius = radius;
    }

    @Override
    public Sphere transform(TransformInfo ti, int options) {
        if (ti.isIdentity()) {
            return this;
        }
        Matrix4d xform = ti.getMatrix();
        Point3d newCenter = new Point3d(this.center);
        Point3d ref = new Point3d(this.center.x + this.radius, this.center.y, this.center.z);
        xform.transform(newCenter);
        xform.transform(ref);
        double newRadius = ref.distance(newCenter);
        if (newCenter.equals((Tuple3d)this.center) && newRadius == this.radius) {
            return this;
        }
        return new Sphere(newCenter, newRadius);
    }

    @Override
    public IFace optimize(IPointOptimizer pool) {
        Point3d c = pool.getExisting(this.center);
        if (c == this.center) {
            return this;
        }
        return new Sphere(c, this.radius);
    }

    @Override
    public Pair<Mesh, Boolean> triangulate(double errorTol, boolean ccw) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void getBoundary(List<ICurve> boundary) {
    }

    @Override
    public Point3d project(Point3d p) {
        Vector3d dir = Util3D.vector(this.center, p);
        double len = Util3D.safeNormalize(dir, 1.0E-9);
        if (len == 0.0) {
            return new Point3d(this.center.x + this.radius, this.center.y, this.center.z);
        }
        dir.scale(this.radius);
        return Util3D.add(this.center, (Tuple3d)dir);
    }

    @Override
    public IFace.PointClassify classify(Point3d p, double tol) {
        return IFace.PointClassify.INSIDE;
    }

    @Override
    public AABox getBoundingBox(AABox aabb) {
        aabb.add(new AABox(this.center.x - this.radius, this.center.y - this.radius, this.center.z - this.radius, this.center.x + this.radius, this.center.y + this.radius, this.center.z + this.radius));
        return aabb;
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    @Override
    public IDOF getRetainingDOF() {
        return IDOF.FREE;
    }

    @Override
    public Sphere flipOrient() {
        return this;
    }

    @Override
    public void pickPoints(IIsectCollector isects, IIsectFilter filter, Object source, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester) {
    }

    @Override
    public void pickBox(Object source, IIsectFilter filter, ConvexHull region, IBoxCollector isects) throws CancelledException {
    }
}

