/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.manip.APlaneHandle;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.manip.ManipException;
import thunderheadeng.geometry.objs.GeneralPoly;
import thunderheadeng.geometry.objs.IBoxCollector;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IIsectCollector;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.NGon;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.PolyLine;
import thunderheadeng.geometry.objs.Quad;
import thunderheadeng.geometry.objs.Triangle;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.picking.PlanarConstraint;
import thunderheadeng.util.CancelledException;
import thunderheadeng.util.Pair;

public class PolyUtil {
    public static IPolygon newPoly(Point3d ... points) {
        return PolyUtil.newPoly(false, points);
    }

    public static IPolygon newPoly(boolean copyPoints, Point3d ... points) {
        if (points.length == 3) {
            return new Triangle(points[0], points[1], points[2]);
        }
        if (points.length == 4 && Util3D.isConvex(1.0E-9, points)) {
            return new Quad(points[0], points[1], points[2], points[3]);
        }
        return new NGon(copyPoints ? Arrays.copyOf(points, points.length) : points);
    }

    public static IPolygon newPoly(boolean copyPoints, boolean isConvex, Point3d ... points) {
        if (points.length == 3) {
            return new Triangle(points[0], points[1], points[2]);
        }
        if (points.length == 4 && isConvex) {
            return new Quad(points[0], points[1], points[2], points[3]);
        }
        return new NGon(copyPoints ? Arrays.copyOf(points, points.length) : points);
    }

    public static IPolygon newPoly(Point3d[] points, int[] loopOffsets) {
        if (loopOffsets.length <= 1) {
            return PolyUtil.newPoly(points);
        }
        return new GeneralPoly(points, loopOffsets);
    }

    public static IPolygon newPoly(Point3d[][] points) {
        if (points.length == 0) {
            return new NGon(new Point3d[0]);
        }
        if (points.length == 1) {
            return PolyUtil.newPoly(points[0]);
        }
        return new GeneralPoly(points);
    }

    public static boolean polysEqual(IPolygon poly1, IPolygon poly2) {
        int loopCount = poly1.getNumLoops();
        if (loopCount != poly2.getNumLoops()) {
            return false;
        }
        for (int loopix = 0; loopix < loopCount; ++loopix) {
            int m;
            int count = poly1.getNumPoints(loopix);
            if (count != poly2.getNumPoints(loopix)) {
                return false;
            }
            if (count == 0) {
                return true;
            }
            int startIx2 = -1;
            Point3d p1 = poly1.getPoint(loopix, 0);
            for (m = 0; m < count; ++m) {
                if (!p1.equals((Tuple3d)poly2.getPoint(loopix, m))) continue;
                startIx2 = m;
                break;
            }
            if (startIx2 == -1) {
                return false;
            }
            int n = (startIx2 + 1) % count;
            for (m = 1; m < count; ++m) {
                Point3d ppoly2;
                Point3d ppoly1 = poly1.getPoint(loopix, m);
                if (!ppoly1.equals((Tuple3d)(ppoly2 = poly2.getPoint(loopix, n)))) {
                    return false;
                }
                n = (n + 1) % count;
            }
        }
        return true;
    }

    public static void getBoundary(List<ICurve> boundary, IPolygon poly) {
        for (int n = 0; n < poly.getNumLoops(); ++n) {
            Point3d[] verts = new Point3d[poly.getNumPoints(n) + 1];
            for (int o = 0; o < verts.length - 1; ++o) {
                verts[o] = poly.getPoint(n, o);
            }
            verts[verts.length - 1] = verts[0];
            boundary.add(new PolyLine(verts));
        }
    }

    public static Point3d[] getAllVerts(IPolygon poly, boolean copy) {
        if (!copy && poly instanceof NGon) {
            return ((NGon)poly).points;
        }
        if (!copy && poly instanceof GeneralPoly) {
            return ((GeneralPoly)poly).points;
        }
        int numPoints = PolyUtil.getNumVerts(poly);
        int ix = 0;
        Point3d[] points = new Point3d[numPoints];
        for (int m = 0; m < poly.getNumLoops(); ++m) {
            int numVerts = poly.getNumPoints(m);
            for (int n = 0; n < numVerts; ++n) {
                points[ix++] = poly.getPoint(m, n);
            }
        }
        return points;
    }

    public static int getNumVerts(IPolygon poly) {
        int count = 0;
        int numLoops = poly.getNumLoops();
        for (int m = 0; m < numLoops; ++m) {
            count += poly.getNumPoints(m);
        }
        return count;
    }

    public static Point3d[][] getLoops(IPolygon poly, boolean copy) {
        if (!copy && poly instanceof NGon) {
            return new Point3d[][]{((NGon)poly).points};
        }
        Point3d[][] loops = new Point3d[poly.getNumLoops()][];
        for (int m = 0; m < loops.length; ++m) {
            loops[m] = PolyUtil.getLoop(poly, m, copy);
        }
        return loops;
    }

    public static int[] getLoopOffsets(IPolygon poly, boolean copy) {
        if (!copy && poly instanceof GeneralPoly) {
            return ((GeneralPoly)poly).loopOffsets;
        }
        int[] offsets = new int[poly.getNumLoops()];
        int offset = 0;
        for (int m = 0; m < offsets.length; ++m) {
            offsets[m] = offset;
            offset += poly.getNumPoints(m);
        }
        return offsets;
    }

    public static Point3d[] getLoop(IPolygon poly, int loop, boolean copy) {
        if (!copy && poly instanceof NGon) {
            assert (loop == 0);
            return ((NGon)poly).points;
        }
        int numVerts = poly.getNumPoints(loop);
        Point3d[] verts = new Point3d[numVerts];
        for (int m = 0; m < numVerts; ++m) {
            verts[m] = poly.getPoint(loop, m);
        }
        return verts;
    }

    public static boolean isConvex(IPolygon poly) {
        if (poly.getNumLoops() != 1) {
            return false;
        }
        if (poly instanceof Triangle || poly.getNumPoints(0) == 3) {
            return true;
        }
        Point3d[] verts = PolyUtil.getLoop(poly, 0, false);
        return Util3D.isConvex(1.0E-6, verts);
    }

    public static void pickBox(Object source, int primIx, IPolygon poly, IIsectFilter filter, ConvexHull box, IBoxCollector isects) throws CancelledException {
        block12: {
            block10: {
                block11: {
                    if (!filter.acceptGeomType(source, GeomType.FACE)) break block10;
                    if (!PolyUtil.isConvex(poly)) break block11;
                    assert (poly.getNumLoops() == 1);
                    int numVerts = poly.getNumPoints(0);
                    Point3d[] verts = new Point3d[numVerts];
                    for (int m = 0; m < numVerts; ++m) {
                        verts[m] = poly.getPoint(0, m);
                    }
                    Plane3d plane = Util3D.simplePolygonPlane(Arrays.asList(verts), true);
                    if (plane == null || !box.intersectsConvexPoly(1.0E-6, plane, verts)) break block12;
                    isects.addFace(source, primIx, () -> new Pair<Point3d, Vector3d>(Util3D.simplePolygonCentroid(verts), plane.getNormal()));
                    break block12;
                }
                Mesh tris = poly.triangulate(1.0E-6);
                Point3d[] tri = new Point3d[3];
                Plane3d plane = new Plane3d();
                int m = 0;
                while (m < tris.indices.length) {
                    tri[0] = tris.vertices[tris.indices[m++]];
                    tri[1] = tris.vertices[tris.indices[m++]];
                    tri[2] = tris.vertices[tris.indices[m++]];
                    plane.set(true, tri);
                    if (!plane.isValid() || !box.intersectsConvexPoly(1.0E-6, plane, tri)) continue;
                    Vector3d normal = plane.getNormal();
                    isects.addFace(source, primIx, () -> new Pair<Point3d, Vector3d>(Util3D.simplePolygonCentroid(tri), normal));
                }
                break block12;
            }
            if (filter.acceptGeomType(source, GeomType.FACE_EDGE)) {
                int numLoops = poly.getNumLoops();
                for (int n = 0; n < numLoops; ++n) {
                    int numVerts = poly.getNumPoints(n);
                    for (int m = 0; m < numVerts; ++m) {
                        Point3d p2;
                        Point3d p1 = poly.getPoint(n, m);
                        if (!box.intersectsLineSeg(p1, p2 = poly.getPoint(n, (m + 1) % numVerts), 1.0E-6)) continue;
                        isects.addNonFace(source);
                    }
                }
            } else if (filter.acceptGeomType(source, GeomType.FACE_VERTEX)) {
                int numLoops = poly.getNumLoops();
                for (int n = 0; n < numLoops; ++n) {
                    int numVerts = poly.getNumPoints(n);
                    for (int m = 0; m < numVerts; ++m) {
                        if (!box.contains(poly.getPoint(n, m), 1.0E-6)) continue;
                        isects.addNonFace(source);
                    }
                }
            }
        }
    }

    public static void pickPoints(IPolygon poly, IIsectCollector isects, IIsectFilter filter, Object source, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester) {
        if (filter.acceptGeomType(source, GeomType.FACE)) {
            Plane3d plane = poly.getPlane(true);
            if (!plane.isValid()) {
                return;
            }
            Point3d isect = PolyUtil.getFaceIsect(poly, plane, source, rayBegin, rayEnd, rayDirN);
            if (isect != null) {
                isects.addFace(source, isect, 0, () -> poly, plane::getNormal);
            }
        }
        if (filter.acceptGeomType(source, GeomType.FACE_VERTEX)) {
            PolyUtil.getFaceVertices(poly, source, isects);
        }
        if (filter.acceptGeomType(source, GeomType.FACE_EDGE)) {
            PolyUtil.getClosestToEdges(poly, source, isects, rayBegin, rayEnd, rayDirN);
        }
    }

    private static void getFaceVertices(IPolygon poly, Object source, IIsectCollector isects) {
        int numLoops = poly.getNumLoops();
        for (int m = 0; m < numLoops; ++m) {
            int numVerts = poly.getNumPoints(m);
            for (int n = 0; n < numVerts; ++n) {
                Point3d p = poly.getPoint(m, n);
                isects.addNonFace(source, p, GeomType.FACE_VERTEX);
            }
        }
    }

    private static void getClosestToEdges(IPolygon poly, Object source, IIsectCollector isects, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN) {
        Point3d isect = new Point3d();
        int numLoops = poly.getNumLoops();
        for (int m = 0; m < numLoops; ++m) {
            int numVerts = poly.getNumPoints(m);
            if (numVerts == 0) continue;
            Point3d p1 = poly.getPoint(m, 0);
            for (int n = 1; n <= numVerts; ++n) {
                Point3d p2 = poly.getPoint(m, n % numVerts);
                boolean nonParallel = Inter3D.lineLineSegProximity(null, isect, rayBegin, rayDirN, p1, p2);
                if (nonParallel) {
                    isects.addNonFace(source, new Point3d(isect), GeomType.FACE_EDGE);
                }
                p1 = p2;
            }
        }
    }

    private static Point3d getFaceIsect(IPolygon poly, Plane3d plane, Object source, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN) {
        Point3d isect = Inter3D.lineSegPlaneIntersection(rayBegin, rayEnd, plane, 1.0E-6);
        if (isect == null) {
            return null;
        }
        return poly.classify((Point3d)isect, (double)1.0E-6).positive ? isect : null;
    }

    public static IPolygon reverse(IPolygon poly) {
        int numLoops = poly.getNumLoops();
        Point3d[][] loops = new Point3d[numLoops][];
        for (int m = 0; m < numLoops; ++m) {
            int numVerts = poly.getNumPoints(m);
            Point3d[] loop = new Point3d[numVerts];
            for (int n = 0; n < numVerts; ++n) {
                loop[numVerts - 1 - n] = poly.getPoint(m, n);
            }
            loops[m] = loop;
        }
        return PolyUtil.newPoly(loops);
    }

    protected static IFace.PointClassify classify(IPolygon poly, Point3d p, double tol) {
        int numVerts;
        if (poly.getNumLoops() == 0 || poly.getNumPoints(0) == 0) {
            return IFace.PointClassify.OUTSIDE;
        }
        if (poly.getNumLoops() == 1 && (numVerts = poly.getNumPoints(0)) == 3) {
            return PolyUtil.convert(Inter3D.classifyConvexPolyPoint(tol, p, poly.getPoint(0, 0), poly.getPoint(0, 1), poly.getPoint(0, 2)));
        }
        Plane3d plane = new Plane3d(poly.getNormal(true), poly.getPoint(0, 0));
        Point3d[][] loops = PolyUtil.getLoops(poly, false);
        return PolyUtil.convert(Inter3D.classifySimplePolyPoint(1.0E-6, p, plane, loops));
    }

    private static IFace.PointClassify convert(Inter3D.PointClassify pc) {
        switch (pc) {
            case INSIDE: {
                return IFace.PointClassify.INSIDE;
            }
            case ON_BOUNDARY: {
                return IFace.PointClassify.ON_BOUNDARY;
            }
        }
        return IFace.PointClassify.OUTSIDE;
    }

    public static Collection<? extends IHandle> generateManipHandles(IPolygon poly) {
        ArrayList<IHandle> handles = new ArrayList<IHandle>();
        int numLoops = poly.getNumLoops();
        for (int m = 0; m < numLoops; ++m) {
            int numVerts = poly.getNumPoints(m);
            for (int n = 0; n < numVerts; ++n) {
                handles.add(new VertHandle(poly, m, n));
            }
        }
        handles.add(new OffsetHandle(poly));
        return handles;
    }

    private static class OffsetHandle
    extends APlaneHandle<IPolygon> {
        public OffsetHandle(IPolygon geom) {
            super(geom);
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && obj instanceof OffsetHandle;
        }

        @Override
        public IGeomNode getGeom() {
            return GeomNodeUtil.newNode((IGeom)this.getManipGeom());
        }

        @Override
        protected Vector3d getPlaneNormal(IPolygon geom) {
            return geom.getNormal(true);
        }

        @Override
        protected IPolygon modify(IPolygon origGeom, double offset) {
            Vector3d normal = origGeom.getNormal(true);
            ITransform xform = TransformUtil.translate(normal.x * offset, normal.y * offset, normal.z * offset);
            return origGeom.transform(xform.getInfo(), 1);
        }
    }

    private static class VertHandle
    implements IHandle {
        private IPolygon geom;
        private final int loop;
        private final int vert;
        private Point3d[][] d_loops;

        public VertHandle(IPolygon geom, int loop, int vert) {
            this.geom = geom;
            this.loop = loop;
            this.vert = vert;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof VertHandle)) {
                return false;
            }
            VertHandle handle = (VertHandle)obj;
            return handle.loop == this.loop && handle.vert == this.vert;
        }

        @Override
        public Pair<SnapMode, IIsectFilter> getPickFilter() {
            return null;
        }

        @Override
        public IGeomNode getGeom() {
            return GeomNodeUtil.newNode(new Point(this.getLocation()));
        }

        protected Point3d getLocation() {
            return this.geom.getPoint(this.loop, this.vert);
        }

        @Override
        public ISnapConstraint getConstraint(Point3d handleLoc) {
            Plane3d editPlane = this.geom.getPlane(true);
            return new PlanarConstraint(editPlane);
        }

        @Override
        public void begin(Point3d handleLoc, ISnapConstraint constraint) {
            this.d_loops = PolyUtil.getLoops(this.geom, true);
        }

        @Override
        public IPolygon modify(Point3d newLoc) throws ManipException {
            this.d_loops[this.loop][this.vert] = newLoc;
            this.geom = PolyUtil.newPoly(this.d_loops);
            return this.geom;
        }

        @Override
        public Object end() {
            this.d_loops = null;
            return this.geom;
        }
    }
}

