/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs;

import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.manip.IManipulatable;
import thunderheadeng.geometry.objs.ACurve;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IBoxCollector;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IIsectCollector;
import thunderheadeng.geometry.objs.ILinearCurve;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.NullOptimizer;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.util.CancelledException;

public class PolyLine
extends ACurve
implements ILinearCurve,
IManipulatable {
    private static final long serialVersionUID = 1L;
    public final Point3d[] verts;

    public PolyLine(Point3d ... verts) {
        this.verts = verts;
        assert (verts.length > 1);
    }

    @Override
    public AABox getBoundingBox(AABox aabb) {
        aabb.add(this.verts);
        return aabb;
    }

    @Override
    public PolyLine reverse() {
        return new PolyLine(GeomUtil.reverse(this.verts, Point3d.class));
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    @Override
    public IDOF getRetainingDOF() {
        return IDOF.FREE;
    }

    @Override
    public int getNumVerts() {
        return this.verts.length;
    }

    @Override
    public Point3d getVert(int ix) {
        return this.verts[ix];
    }

    @Override
    public ILinearCurve optimize(IPointOptimizer pool) {
        if (pool instanceof NullOptimizer) {
            return this;
        }
        boolean modified = false;
        Point3d[] newVerts = new Point3d[this.verts.length];
        for (int m = 0; m < this.verts.length; ++m) {
            Point3d ov = this.verts[m];
            Point3d nv = pool.getExisting(ov);
            modified |= nv != ov;
            newVerts[m] = nv;
        }
        return modified ? new PolyLine(newVerts) : this;
    }

    @Override
    public ILinearCurve transform(TransformInfo ti, int options) {
        if (ti.isIdentity()) {
            return this;
        }
        return new PolyLine(GeomUtil.xformVerts(this.verts, ti.getMatrix()));
    }

    @Override
    public Mesh getSegments(double errorTol) {
        int[] indices = new int[(this.verts.length - 1) * 2];
        int indexix = 0;
        int m = 0;
        while (m < this.verts.length - 1) {
            indices[indexix++] = m++;
            indices[indexix++] = m;
        }
        return new Mesh(this.verts, indices, 1);
    }

    @Override
    public void pickBox(Object source, IIsectFilter filter, ConvexHull region, IBoxCollector isects) throws CancelledException {
        block3: {
            block2: {
                if (!filter.acceptGeomType(source, GeomType.EDGE)) break block2;
                for (int m = 0; m < this.verts.length - 1; ++m) {
                    Point3d p1 = this.verts[m];
                    Point3d p2 = this.verts[m + 1];
                    if (!region.intersectsLineSeg(p1, p2, 1.0E-6)) continue;
                    isects.addNonFace(source);
                }
                break block3;
            }
            if (!filter.acceptGeomType(source, GeomType.EDGE_VERTEX)) break block3;
            for (Point3d p : this.verts) {
                if (!region.contains(p, 1.0E-6)) continue;
                isects.addNonFace(source);
            }
        }
    }

    @Override
    public void pickPoints(IIsectCollector isects, IIsectFilter filter, Object source, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester) {
        if (filter.acceptGeomType(source, GeomType.EDGE_VERTEX)) {
            for (Point3d p : this.verts) {
                isects.addNonFace(source, p, GeomType.EDGE_VERTEX);
            }
        }
        if (filter.acceptGeomType(source, GeomType.EDGE)) {
            for (int m = 0; m < this.verts.length - 1; ++m) {
                Point3d p1 = this.verts[m];
                Point3d p2 = this.verts[m + 1];
                double[] isect = Inter3D.getNearestTLinesegLineSeg(rayBegin, rayEnd, p1, p2, 1.0E-6);
                if (isect == null || isect[1] == 1.0 && m < this.verts.length - 2) continue;
                isects.addNonFace(source, Util3D.linesegPoint(p1, p2, isect[1]), GeomType.EDGE);
            }
        }
    }

    @Override
    public Point3d project(Point3d p, double tol) {
        Point3d nearestp = null;
        double nearestDistSq = Double.MAX_VALUE;
        for (int m = 0; m < this.verts.length - 1; ++m) {
            Point3d p1 = this.verts[m];
            Point3d p2 = this.verts[m + 1];
            Point3d nearp = Inter3D.nearestPointOnLineSeg(p1, p2, p);
            double distsq = p.distanceSquared(nearp);
            if (!(distsq < nearestDistSq)) continue;
            nearestDistSq = distsq;
            nearestp = nearp;
        }
        return nearestp;
    }

    @Override
    public ILinearCurve newCurve(Point3d ... points) {
        return new PolyLine(points);
    }
}

