/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.manip.IManipulatable;
import thunderheadeng.geometry.manip.ManipException;
import thunderheadeng.geometry.objs.ACurve;
import thunderheadeng.geometry.objs.IBoxCollector;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IIsectCollector;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.util.CancelledException;
import thunderheadeng.util.Pair;

public class PolyCurve
extends ACurve
implements ICurve,
IManipulatable {
    private static final long serialVersionUID = 1L;
    public final ICurve[] curves;

    public PolyCurve(ICurve ... curves) {
        this.curves = curves;
    }

    @Override
    public AABox getBoundingBox(AABox aabb) {
        for (ICurve curve : this.curves) {
            curve.getBoundingBox(aabb);
        }
        return aabb;
    }

    @Override
    public PolyCurve reverse() {
        ICurve[] revCurves = new ICurve[this.curves.length];
        int end = this.curves.length - 1;
        for (int m = 0; m < this.curves.length; ++m) {
            revCurves[m] = this.curves[end - m].reverse();
        }
        return new PolyCurve(revCurves);
    }

    @Override
    public ICurve optimize(IPointOptimizer pool) {
        ICurve[] newCurves = new ICurve[this.curves.length];
        boolean modified = false;
        for (int m = 0; m < this.curves.length; ++m) {
            ICurve subCurve = this.curves[m];
            ICurve newSubCurve = subCurve.optimize(pool);
            modified |= subCurve != newSubCurve;
            newCurves[m] = newSubCurve;
        }
        return modified ? new PolyCurve(newCurves) : this;
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    @Override
    public IDOF getRetainingDOF() {
        return IDOF.FREE;
    }

    @Override
    public PolyCurve transform(TransformInfo ti, int options) {
        if (ti.isIdentity()) {
            return this;
        }
        ICurve[] newCurves = new ICurve[this.curves.length];
        for (int m = 0; m < this.curves.length; ++m) {
            newCurves[m] = this.curves[m].transform(ti, options);
        }
        return new PolyCurve(newCurves);
    }

    @Override
    public Mesh getSegments(double errorTol) {
        Mesh[] meshes = new Mesh[this.curves.length];
        for (int m = 0; m < this.curves.length; ++m) {
            meshes[m] = this.curves[m].getSegments(errorTol);
        }
        return Mesh.merge(meshes);
    }

    @Override
    public void pickBox(Object source, IIsectFilter filter, ConvexHull region, IBoxCollector isects) throws CancelledException {
        if (filter.acceptGeomType(source, GeomType.EDGE)) {
            for (ICurve geom : this.curves) {
                geom.pickBox(source, filter, region, isects);
            }
        }
    }

    @Override
    public void pickPoints(IIsectCollector isects, IIsectFilter filter, Object source, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester) {
        for (ICurve geom : this.curves) {
            isects.getProgress().check();
            geom.pickPoints(isects, filter, source, rayBegin, rayEnd, rayDirN, tester);
        }
    }

    @Override
    public Point3d project(Point3d p, double tol) {
        Point3d nearestp = null;
        double nearestDistSq = Double.MAX_VALUE;
        for (ICurve curve : this.curves) {
            Point3d nearp = curve.project(p, tol);
            double distsq = p.distanceSquared(nearp);
            if (!(distsq < nearestDistSq)) continue;
            nearestDistSq = distsq;
            nearestp = nearp;
        }
        return nearestp;
    }

    @Override
    public Collection<? extends IHandle> generateManipHandles() {
        ArrayList<Handle> handles = new ArrayList<Handle>();
        for (int m = 0; m < this.curves.length; ++m) {
            ICurve curve = this.curves[m];
            if (!(curve instanceof IManipulatable)) continue;
            for (IHandle iHandle : ((IManipulatable)((Object)curve)).generateManipHandles()) {
                handles.add(new Handle(this, m, iHandle));
            }
        }
        return handles;
    }

    private static class Handle
    implements IHandle {
        private PolyCurve d_geom;
        private final int d_curveIx;
        private final IHandle d_curveHandle;
        private ICurve[] t_curves;

        public Handle(PolyCurve geom, int curveIx, IHandle curveHandle) {
            this.d_geom = geom;
            this.d_curveIx = curveIx;
            this.d_curveHandle = curveHandle;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Handle && ((Handle)obj).d_curveIx == this.d_curveIx && ((Handle)obj).d_curveHandle.equals(this.d_curveHandle);
        }

        @Override
        public IGeomNode getGeom() {
            return this.d_curveHandle.getGeom();
        }

        @Override
        public Pair<SnapMode, IIsectFilter> getPickFilter() {
            return this.d_curveHandle.getPickFilter();
        }

        @Override
        public ISnapConstraint getConstraint(Point3d handleLoc) {
            return this.d_curveHandle.getConstraint(handleLoc);
        }

        @Override
        public void begin(Point3d handleLoc, ISnapConstraint constraint) {
            this.t_curves = Arrays.copyOf(this.d_geom.curves, this.d_geom.curves.length);
            this.d_curveHandle.begin(handleLoc, constraint);
        }

        @Override
        public Object modify(Point3d newLoc) throws ManipException {
            Object curveMod = this.d_curveHandle.modify(newLoc);
            this.d_geom = this.replace(curveMod);
            return this.d_geom;
        }

        @Override
        public Object end() {
            this.d_geom = this.replace(this.d_curveHandle.end());
            this.t_curves = null;
            return this.d_geom;
        }

        private PolyCurve replace(Object modified) {
            PolyCurve result = this.d_geom;
            if (modified instanceof ICurve) {
                this.t_curves[this.d_curveIx] = (ICurve)modified;
                result = new PolyCurve(this.t_curves);
            }
            return result;
        }
    }
}

