/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.delaunay.MeshBuilder;
import thunderheadeng.delaunay.TriangulatorInfo;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.AFace;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.NullOptimizer;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.util.Pair;

public class NGon
extends AFace
implements IPolygon {
    static final long serialVersionUID = 1L;
    public final Point3d[] points;

    public NGon(Collection<Point3d> points) {
        this(points.toArray(new Point3d[points.size()]));
    }

    public NGon(Point3d ... points) {
        assert (points.length >= 3);
        this.points = points;
    }

    @Override
    public NGon flipOrient() {
        return new NGon(GeomUtil.reverse(this.points, Point3d.class));
    }

    @Override
    public NGon optimize(IPointOptimizer pool) {
        if (pool instanceof NullOptimizer) {
            return this;
        }
        boolean changed = false;
        Point3d[] npoints = new Point3d[this.points.length];
        for (int m = 0; m < this.points.length; ++m) {
            npoints[m] = pool.getExisting(this.points[m]);
            changed |= npoints[m] != this.points[m];
        }
        return changed ? new NGon(npoints) : this;
    }

    @Override
    public AABox getBoundingBox(AABox aabb) {
        aabb.add(this.points);
        return aabb;
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    @Override
    public IDOF getRetainingDOF() {
        return IDOF.FREE;
    }

    @Override
    public NGon transform(TransformInfo ti, int options) {
        if (ti.isIdentity()) {
            return this;
        }
        Matrix4d xform = ti.getMatrix();
        Point3d[] newPoints = new Point3d[this.points.length];
        for (int m = 0; m < this.points.length; ++m) {
            newPoints[m] = Util3D.xform(xform, this.points[m]);
        }
        return new NGon(newPoints);
    }

    @Override
    public IPolygon toPoly(double edgeTol) {
        return this;
    }

    @Override
    public Plane3d getPlane(boolean ccw) {
        Plane3d plane = Util3D.simplePolygonPlane(Arrays.asList(this.points), ccw, 0.0);
        if (plane != null) {
            return plane;
        }
        if (this.points.length == 0) {
            return new Plane3d(0.0, 0.0, 1.0, 0.0);
        }
        return new Plane3d(GeomConstants.VEC3D_ZERO, this.points[0]);
    }

    @Override
    public Plane3d getPlaneIfValid(boolean ccw) {
        return Util3D.simplePolygonPlane(Arrays.asList(this.points), ccw, 0.0);
    }

    @Override
    public int getNumLoops() {
        return 1;
    }

    @Override
    public int getNumPoints(int loop) {
        return this.points.length;
    }

    @Override
    public Point3d getPoint(int loop, int ix) {
        return this.points[ix];
    }

    @Override
    public Vector3d getNormalIfValid(boolean ccw) {
        return Util3D.simplePolygonNormal(Arrays.asList(this.points), ccw, 0.0);
    }

    @Override
    public Pair<Mesh, Boolean> triangulate(double errorTol, boolean ccw) {
        int m;
        int m2;
        HashMap<Point2d, Point3d> localVertMap = new HashMap<Point2d, Point3d>();
        Plane3d plane = Util3D.simplePolygonPlane(Arrays.asList(this.points), true, 0.0);
        if (plane == null) {
            return new Pair<Mesh, Boolean>(new Mesh(new Point3d[0], new int[0], 2, 0), true);
        }
        Matrix4d wlXform = Util.getWorldToLocalXform(plane);
        Matrix4d lwXform = Util.getLocalToWorldXform(plane);
        Point2d[] p2ds = new Point2d[this.points.length];
        MeshBuilder mb = new MeshBuilder(1.0E-6);
        for (m2 = 0; m2 < this.points.length; ++m2) {
            Point2d xformed = Util3D.xform2d(wlXform, this.points[m2]);
            localVertMap.put(xformed, this.points[m2]);
            p2ds[m2] = xformed;
        }
        for (m2 = 0; m2 < this.points.length; ++m2) {
            Point2d p1 = p2ds[m2];
            Point2d p2 = p2ds[(m2 + 1) % this.points.length];
            mb.addEdge(p1, p2);
        }
        thunderheadeng.delaunay.Mesh mesh = mb.build();
        boolean triangulated = mesh.triangulateEvenOdd(0, 0.0);
        if (!triangulated) {
            return new Pair<Mesh, Boolean>(new Mesh(new Point3d[0], new int[0], 2, 0), true);
        }
        LinkedHashMap<Point3d, Integer> pointIxMap = new LinkedHashMap<Point3d, Integer>();
        TriangulatorInfo result = mesh.getOutput();
        int[] localWorldIxes = new int[result.points.length];
        for (m = 0; m < result.points.length; ++m) {
            Integer ix;
            Point2d p2d = result.points[m];
            Point3d p3d = (Point3d)localVertMap.get(p2d);
            if (p3d == null) {
                p3d = Util3D.xform(lwXform, new Point3d(p2d.x, p2d.y, 0.0));
            }
            if ((ix = (Integer)pointIxMap.get(p3d)) == null) {
                ix = pointIxMap.size();
                pointIxMap.put(p3d, ix);
            }
            localWorldIxes[m] = ix;
        }
        for (m = 0; m < result.triangles.length; ++m) {
            result.triangles[m] = localWorldIxes[result.triangles[m]];
        }
        Mesh resultMesh = new Mesh(pointIxMap.keySet().toArray(new Point3d[pointIxMap.size()]), result.triangles, 2);
        return new Pair<Mesh, Boolean>(resultMesh, true);
    }
}

