/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.ISearchVol;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.CatmullRomSpline;
import thunderheadeng.geometry.objs.EmptyGeom;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.PolyCurve;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.geometry.objs.Triangle;
import thunderheadeng.geometry.objs.transform.ConcatTransform;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.MatrixXform;
import thunderheadeng.geometry.objs.transform.MirrorXform;
import thunderheadeng.geometry.objs.transform.RotateXform;
import thunderheadeng.geometry.objs.transform.ScaleXform;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.objs.transform.TranslateXform;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class GeomUtil {
    public static final int[] PLUS1MOD3 = new int[]{1, 2, 0};
    public static final int[] PLUS2MOD3 = new int[]{2, 0, 1};
    public static final int[] PLUS1MOD4 = new int[]{1, 2, 3, 0};
    public static final int[] PLUS2MOD4 = new int[]{2, 3, 0, 1};
    public static final int[] PLUS3MOD4 = new int[]{3, 0, 1, 2};
    public static final int[] MINUS1MOD3 = PLUS2MOD3;
    public static final int[] MINUS1MOD4 = PLUS3MOD4;
    public static final int[] MINUS2MOD4 = PLUS2MOD4;
    public static final Vector3d[] AXIS_VECS = new Vector3d[]{new Vector3d(-1.0, 0.0, 0.0), new Vector3d(1.0, 0.0, 0.0), new Vector3d(0.0, -1.0, 0.0), new Vector3d(0.0, 1.0, 0.0), new Vector3d(0.0, 0.0, -1.0), new Vector3d(0.0, 0.0, 1.0)};

    public static List<IPrimitive> explodeToTypes(IGeom geom, int primTypes) {
        return GeomUtil.explodeToTypes(Arrays.asList(geom), primTypes);
    }

    public static List<IPrimitive> explodeToTypes(Collection<? extends IGeom> geomList, int primTypes) {
        Class<? extends IPrimitive>[] types = GeomUtil.getPrimClasses(primTypes);
        int primCount = 0;
        for (IGeom iGeom : geomList) {
            primCount += iGeom.getNumPrims(primTypes);
        }
        ArrayList<IPrimitive> prims = new ArrayList<IPrimitive>(primCount);
        GeomUtil.explodeToTypes(geomList, types, prims);
        assert (prims.size() == primCount);
        return prims;
    }

    public static <T extends IPrimitive> List<T> explode(IGeom geom, Class<? extends T> ... primTypes) {
        return GeomUtil.explode(Arrays.asList(geom), primTypes);
    }

    public static <T extends IPrimitive> List<T> explode(Collection<? extends IGeom> geomList, Class<? extends T> ... primTypes) {
        ArrayList prims = new ArrayList();
        GeomUtil.explodeToTypes(geomList, primTypes, prims);
        return prims;
    }

    private static <T extends IPrimitive> void explodeToTypes(Collection<? extends IGeom> geomList, Class<? extends T>[] types, List<T> prims) {
        for (IGeom iGeom : geomList) {
            if (GeomUtil.isType(iGeom, types)) {
                prims.add((IPrimitive)iGeom);
                continue;
            }
            if (!iGeom.canExplode()) continue;
            Collection<IGeom> subGeom = iGeom.explode(new ArrayList<IGeom>());
            GeomUtil.explodeToTypes(subGeom, types, prims);
        }
    }

    public static boolean isEmpty(IGeom geom) {
        return geom == EmptyGeom.INSTANCE || geom.getNumPrims(7) == 0;
    }

    private static Class<? extends IPrimitive>[] getPrimClasses(int primTypes) {
        int numTypes = Integer.bitCount(primTypes &= 7);
        Class[] types = new Class[numTypes];
        int ix = 0;
        if ((primTypes & 1) != 0) {
            types[ix++] = IFace.class;
        }
        if ((primTypes & 2) != 0) {
            types[ix++] = ICurve.class;
        }
        if ((primTypes & 4) != 0) {
            types[ix++] = Point.class;
        }
        return types;
    }

    public static <T> void reverse(T[] src, int srcOffset, T[] dest, int destOffset, int length) {
        int sendm1 = srcOffset + length - 1;
        for (int m = 0; m < length; ++m) {
            dest[destOffset + m] = src[sendm1 - m];
        }
    }

    public static <T> T[] reverse(T[] src, Class<T> type) {
        Object[] newArr = (Object[])Array.newInstance(type, src.length);
        GeomUtil.reverse(src, 0, newArr, 0, src.length);
        return newArr;
    }

    public static boolean isType(Object o, Class ... types) {
        for (int m = 0; m < types.length; ++m) {
            if (!types[m].isInstance(o)) continue;
            return true;
        }
        return false;
    }

    public static IPolygon newPoly(Point3d[] points) {
        return PolyUtil.newPoly(points);
    }

    public static IPolygon newPoly(Point3d[] points, int[] loopOffsets) {
        return PolyUtil.newPoly(points, loopOffsets);
    }

    public static IPolygon newPoly(Point3d[][] points) {
        return PolyUtil.newPoly(points);
    }

    public static boolean polysEqual(IPolygon poly1, IPolygon poly2) {
        return PolyUtil.polysEqual(poly1, poly2);
    }

    public static boolean test(int flags, int flag) {
        return (flags & flag) == flag;
    }

    public static boolean isTranslateScaleOnly(TransformInfo ti, double tol) {
        return GeomUtil.isTranslateScaleOnly(ti.xform, tol) || GeomUtil.isTranslateScaleOnly(ti.getMatrix(), tol);
    }

    public static boolean isTranslateScaleOnly(ITransform xform, double tol) {
        return GeomUtil.testTransforms(xform, t -> true, mir -> mir.isIdentity(), r -> r.isIdentity(), s -> s.x >= 0.0 && s.y >= 0.0 && s.z >= 0.0, mat -> GeomUtil.isTranslateScaleOnly(mat, tol), other -> other.isIdentity());
    }

    public static boolean isTranslateScaleOnly(Matrix4d xform, double tol) {
        return xform.m00 > 0.0 && xform.m01 == 0.0 && xform.m02 == 0.0 && xform.m10 == 0.0 && xform.m11 > 0.0 && xform.m12 == 0.0 && xform.m20 == 0.0 && xform.m21 == 0.0 && xform.m22 > 0.0 && xform.m30 == 0.0 && xform.m31 == 0.0 && xform.m32 == 0.0 && xform.m33 > 0.0;
    }

    public static boolean isAxisAligned(TransformInfo ti, double tol) {
        return GeomUtil.isAxisAligned(ti.xform, tol) || GeomUtil.isAxisAligned(ti.getMatrix(), tol);
    }

    public static boolean isAxisAligned(ITransform xform, double tol) {
        return GeomUtil.testTransforms(xform, x -> GeomUtil.isAxisAligned(x, tol), x -> GeomUtil.isAxisAligned(x, tol), x -> GeomUtil.isAxisAligned(x, tol), x -> GeomUtil.isAxisAligned(x, tol), x -> GeomUtil.isAxisAligned(x, tol), x -> x.isIdentity());
    }

    public static boolean isAxisAligned(TranslateXform xform, double tol) {
        return true;
    }

    public static boolean isAxisAligned(ScaleXform xform, double tol) {
        return true;
    }

    public static boolean isAxisAligned(MatrixXform xform, double tol) {
        return GeomUtil.isAxisAligned(xform.xform, tol);
    }

    public static boolean isAxisAligned(MirrorXform xform, double tol) {
        return GeomUtil.isAxisAligned(xform.plane, tol);
    }

    public static boolean isAxisAligned(RotateXform xform, double tol) {
        return GeomUtil.isAxisAligned(xform.getAxisAngle(), tol);
    }

    public static boolean isAxisAligned(ConcatTransform cxform, double tol) {
        return GeomUtil.isAxisAligned(cxform.left, tol) && GeomUtil.isAxisAligned(cxform.right, tol);
    }

    public static boolean isAxisAligned(Plane3d plane, double tol) {
        return GeomUtil.isAxisAligned(plane.x, plane.y, plane.z, tol);
    }

    public static boolean isAxisAligned(Vector3d vec, double tol) {
        return GeomUtil.isAxisAligned(vec.x, vec.y, vec.z, tol);
    }

    public static boolean isAxisAlignedAxis(AxisAngle4d aa, double tol) {
        return GeomUtil.isAxisAligned(aa.x, aa.y, aa.z, tol);
    }

    public static boolean isAxisAligned(double ax, double ay, double az, double tol) {
        ax = Math.abs(ax);
        ay = Math.abs(ay);
        az = Math.abs(az);
        if (ax > ay && ax > az) {
            double eps = ax * tol;
            return ay <= eps && az <= eps;
        }
        if (ay > ax && ay > az) {
            double eps = ay * tol;
            return ax <= eps && az <= eps;
        }
        if (az > ax && az > ay) {
            double eps = az * tol;
            return ax <= eps && ay <= eps;
        }
        return false;
    }

    public static boolean isAxisAligned(AxisAngle4d rotation, double tol) {
        if (!GeomUtil.isAxisAlignedAxis(rotation, tol)) {
            return false;
        }
        double num90s = Math.abs(rotation.angle / 1.5707963267948966);
        return theUtil.eq0(num90s - Math.floor(num90s), tol);
    }

    public static boolean isAxisAligned(Matrix4d xform, double tol) {
        if (xform.m00 == 0.0 || xform.m11 == 0.0 || xform.m22 == 0.0) {
            return true;
        }
        AxisAngle4d angle = GeomUtil.getRotation(xform);
        if (angle == null) {
            return false;
        }
        if (angle.angle == 0.0) {
            return true;
        }
        return GeomUtil.isAxisAligned(angle, tol);
    }

    public static List<Pair<ICurve, Integer>> getFaceOutlines(IGeom geom) {
        ArrayList<ICurve> curves = new ArrayList<ICurve>();
        ArrayList<Pair<ICurve, Integer>> lines = new ArrayList<Pair<ICurve, Integer>>(geom.getNumPrims(1));
        List<IPrimitive> polys = GeomUtil.explodeToTypes(geom, 1);
        for (int m = 0; m < polys.size(); ++m) {
            IFace face = (IFace)polys.get(m);
            if (face == null) continue;
            curves.clear();
            face.getBoundary(curves);
            for (ICurve curve : curves) {
                lines.add(new Pair<ICurve, Integer>(curve, m));
            }
        }
        return lines;
    }

    public static void getBoundary(List<ICurve> boundary, IPolygon poly) {
        PolyUtil.getBoundary(boundary, poly);
    }

    public static Point3d[] getAllVerts(IPolygon poly) {
        return PolyUtil.getAllVerts(poly, false);
    }

    public static Point3d[][] getLoops(IPolygon poly) {
        return PolyUtil.getLoops(poly, false);
    }

    public static int[] getLoopOffsets(IPolygon poly) {
        return PolyUtil.getLoopOffsets(poly, false);
    }

    public static void flatten(IGeom geom, List<IGeom> geoms) {
        if (geom instanceof GeomGroup) {
            for (IGeom child : ((GeomGroup)geom).children) {
                GeomUtil.flatten(child, geoms);
            }
        } else {
            geoms.add(geom);
        }
    }

    public static List<IGeom> flatten(IGeom geom) {
        ArrayList<IGeom> geoms = new ArrayList<IGeom>();
        GeomUtil.flatten(geom, geoms);
        return geoms;
    }

    public static boolean isZRotation(RotateXform xform, double tol) {
        return GeomUtil.isZRotation(xform.getAxisAngle(), tol);
    }

    public static boolean isZRotation(AxisAngle4d rot, double tol) {
        return theUtil.eq0(rot.angle, tol) || theUtil.eq0(rot.x, tol) && theUtil.eq0(rot.y, tol) && !theUtil.eq0(rot.z, tol);
    }

    public static boolean testTransforms(ITransform xform, Predicate<TranslateXform> tTest, Predicate<MirrorXform> mirTest, Predicate<RotateXform> rTest, Predicate<ScaleXform> sTest, Predicate<MatrixXform> mTest, Predicate<ITransform> otherTest) {
        if (xform instanceof TranslateXform) {
            return tTest.test((TranslateXform)xform);
        }
        if (xform instanceof MatrixXform) {
            return mTest.test((MatrixXform)xform);
        }
        if (xform instanceof MirrorXform) {
            return mirTest.test((MirrorXform)xform);
        }
        if (xform instanceof RotateXform) {
            return rTest.test((RotateXform)xform);
        }
        if (xform instanceof ScaleXform) {
            return sTest.test((ScaleXform)xform);
        }
        if (xform instanceof ConcatTransform) {
            ConcatTransform cxform = (ConcatTransform)xform;
            return GeomUtil.testTransforms(cxform.left, tTest, mirTest, rTest, sTest, mTest, otherTest) && GeomUtil.testTransforms(cxform.right, tTest, mirTest, rTest, sTest, mTest, otherTest);
        }
        return otherTest.test(xform);
    }

    public static boolean testTransforms(ITransform xform, Predicate<TranslateXform> tTest, Predicate<MirrorXform> mirTest, Predicate<RotateXform> rTest, Predicate<ScaleXform> sTest, Predicate<ITransform> otherTest) {
        return GeomUtil.testTransforms(xform, tTest, mirTest, rTest, sTest, m -> GeomUtil.testTransforms(m.xform, tTest, rTest, sTest), otherTest);
    }

    public static boolean testTransforms(Matrix4d matrix, Predicate<TranslateXform> tTest, Predicate<RotateXform> rTest, Predicate<ScaleXform> sTest) {
        int[] decomposeCount = new int[]{0};
        try {
            GeomUtil.decompose(matrix, 0.0, t -> {
                nArray[0] = decomposeCount[0] + 1;
                if (!tTest.test(new TranslateXform(t.x, t.y, t.z))) {
                    throw new CancellationException();
                }
            }, r -> {
                nArray[0] = decomposeCount[0] + 1;
                if (!rTest.test(new RotateXform((AxisAngle4d)r))) {
                    throw new CancellationException();
                }
            }, s -> {
                nArray[0] = decomposeCount[0] + 1;
                if (!sTest.test(new ScaleXform(s.x, s.y, s.z))) {
                    throw new CancellationException();
                }
            });
        }
        catch (CancellationException e) {
            return false;
        }
        return decomposeCount[0] == 3;
    }

    public static void decompose(Matrix4d xform, double tol, Consumer<Vector3d> translate, Consumer<AxisAngle4d> rotate, Consumer<Vector3d> scale) {
        if (translate != null) {
            translate.accept(new Vector3d(xform.m03, xform.m13, xform.m23));
        }
        if (scale == null && rotate == null) {
            return;
        }
        AxisAngle4d aa = GeomUtil.getRotation(xform);
        if (aa == null) {
            return;
        }
        if (rotate != null) {
            rotate.accept(aa);
        }
        if (scale != null) {
            Matrix4d tempXform = new Matrix4d();
            tempXform.setIdentity();
            tempXform.setRotation(aa);
            double sx1 = tempXform.m00 == 0.0 ? 0.0 : xform.m00 / tempXform.m00;
            double sx2 = tempXform.m10 == 0.0 ? 0.0 : xform.m10 / tempXform.m10;
            double sx3 = tempXform.m20 == 0.0 ? 0.0 : xform.m20 / tempXform.m20;
            double sy1 = tempXform.m01 == 0.0 ? 0.0 : xform.m01 / tempXform.m01;
            double sy2 = tempXform.m11 == 0.0 ? 0.0 : xform.m11 / tempXform.m11;
            double sy3 = tempXform.m21 == 0.0 ? 0.0 : xform.m21 / tempXform.m21;
            double sz1 = tempXform.m02 == 0.0 ? 0.0 : xform.m02 / tempXform.m02;
            double sz2 = tempXform.m12 == 0.0 ? 0.0 : xform.m12 / tempXform.m12;
            double sz3 = tempXform.m22 == 0.0 ? 0.0 : xform.m22 / tempXform.m22;
            double sx = GeomUtil.getScale(sx1, sx2, sx3, tol);
            double sy = GeomUtil.getScale(sy1, sy2, sy3, tol);
            double sz = GeomUtil.getScale(sz1, sz2, sz3, tol);
            if (!(Double.isNaN(sx) || Double.isNaN(sy) || Double.isNaN(sz))) {
                scale.accept(new Vector3d(sx, sy, sz));
            }
        }
    }

    private static double getScale(double s1, double s2, double s3, double tol) {
        boolean s10 = theUtil.eq0(s1, tol);
        boolean s20 = theUtil.eq0(s2, tol);
        boolean s30 = theUtil.eq0(s3, tol);
        if (s10 && s20 && s30) {
            return 0.0;
        }
        if (s10 && s20) {
            return s3;
        }
        if (s10 && s30) {
            return s2;
        }
        if (s20 && s30) {
            return s1;
        }
        if (s10) {
            return theUtil.eq(s2, s3, 1.0E-5) ? s2 : Double.NaN;
        }
        if (s20) {
            return theUtil.eq(s1, s3, 1.0E-5) ? s1 : Double.NaN;
        }
        if (s30) {
            return theUtil.eq(s1, s2, 1.0E-5) ? s1 : Double.NaN;
        }
        return theUtil.eq(s1, s2, 1.0E-5) && theUtil.eq(s1, s3, 1.0E-5) ? s1 : Double.NaN;
    }

    public static AxisAngle4d getRotation(Matrix4d xform) {
        AxisAngle4d aa = new AxisAngle4d();
        aa.set(xform);
        if (aa.x == 0.0 && aa.y == 1.0 && aa.z == 0.0 && aa.angle == 0.0) {
            double sig0 = Math.signum(xform.m00);
            double sig1 = Math.signum(xform.m11);
            double sig2 = Math.signum(xform.m22);
            if (sig0 != 0.0 && sig1 != 0.0 && sig2 != 0.0 && theUtil.eq0(xform.m01, 1.0E-12) && theUtil.eq0(xform.m10, 1.0E-12) && theUtil.eq0(xform.m20, 1.0E-12) && theUtil.eq0(xform.m02, 1.0E-12) && theUtil.eq0(xform.m21, 1.0E-12) && theUtil.eq0(xform.m12, 1.0E-12)) {
                if (sig0 != sig1 && sig1 == sig2) {
                    aa.set(1.0, 0.0, 0.0, Math.PI);
                } else if (sig0 != sig1 && sig0 == sig2) {
                    aa.set(0.0, 1.0, 0.0, Math.PI);
                } else if (sig0 == sig1 && sig1 != sig2) {
                    aa.set(0.0, 0.0, 1.0, Math.PI);
                } else {
                    aa.set(0.0, 0.0, 1.0, 0.0);
                }
            } else {
                return null;
            }
        }
        return aa;
    }

    public static Point3d[] xformVerts(Point3d[] vertices, Matrix4d xform) {
        Point3d[] newVerts = new Point3d[vertices.length];
        for (int m = 0; m < vertices.length; ++m) {
            newVerts[m] = Util3D.xform(xform, vertices[m]);
        }
        return newVerts;
    }

    public static Vector3d getClosestAxis(Vector3d vec) {
        double largestDot = 0.0;
        int bestVec = -1;
        Vector3d[] axes = new Vector3d[]{GeomConstants.VEC3D_XPOS, GeomConstants.VEC3D_YPOS, GeomConstants.VEC3D_ZPOS};
        for (int m = 0; m < axes.length; ++m) {
            double dot = vec.dot(axes[m]);
            if (!(Math.abs(dot) > Math.abs(largestDot))) continue;
            largestDot = dot;
            bestVec = m;
        }
        if (bestVec == -1) {
            return GeomConstants.VEC3D_XNEG;
        }
        if (largestDot < 0.0) {
            switch (bestVec) {
                case 0: {
                    return GeomConstants.VEC3D_XNEG;
                }
                case 1: {
                    return GeomConstants.VEC3D_YNEG;
                }
                case 2: {
                    return GeomConstants.VEC3D_ZNEG;
                }
            }
        }
        return axes[bestVec];
    }

    public static List<LineSeg> getLineSegs(double errorTol, ICurve ... curves) {
        return GeomUtil.getLineSegs(errorTol, Arrays.asList(curves));
    }

    public static List<LineSeg> getLineSegs(double errorTol, Collection<? extends ICurve> curves) {
        ArrayList<LineSeg> lineSegs = new ArrayList<LineSeg>();
        for (ICurve iCurve : curves) {
            Mesh mesh = iCurve.getSegments(errorTol);
            int m = 0;
            while (m < mesh.indices.length) {
                Point3d p1 = mesh.vertices[mesh.indices[m++]];
                Point3d p2 = mesh.vertices[mesh.indices[m++]];
                lineSegs.add(new LineSeg(p1, p2));
            }
        }
        return lineSegs;
    }

    public static List<LineSeg> convertToLineSegs(double errorTol, IGeom geom) {
        return GeomUtil.convertToLineSegs(errorTol, Arrays.asList(geom));
    }

    public static List<LineSeg> convertToLineSegs(double errorTol, Collection<? extends IGeom> geoms) {
        List<IPrimitive> curves = GeomUtil.explodeToTypes(geoms, 2);
        return GeomUtil.getLineSegs(errorTol, theUtil.filter(curves, ICurve.class));
    }

    public static List<Triangle> convertToTriangles(double errorTol, IGeom geom) {
        return GeomUtil.convertToTriangles(errorTol, Arrays.asList(geom));
    }

    public static List<Triangle> convertToTriangles(double errorTol, Collection<? extends IGeom> geoms) {
        List<IPrimitive> faces = GeomUtil.explodeToTypes(geoms, 1);
        return GeomUtil.getTriangles(errorTol, theUtil.filter(faces, IFace.class));
    }

    public static List<Triangle> getTriangles(double errorTol, IFace ... faces) {
        return GeomUtil.getTriangles(errorTol, Arrays.asList(faces));
    }

    public static List<Triangle> getTriangles(double errorTol, Collection<? extends IFace> faces) {
        ArrayList<Triangle> tris = new ArrayList<Triangle>();
        for (IFace iFace : faces) {
            Mesh mesh = iFace.triangulate(errorTol);
            int m = 0;
            while (m < mesh.indices.length) {
                Point3d p1 = mesh.vertices[mesh.indices[m++]];
                Point3d p2 = mesh.vertices[mesh.indices[m++]];
                Point3d p3 = mesh.vertices[mesh.indices[m++]];
                tris.add(new Triangle(p1, p2, p3));
            }
        }
        return tris;
    }

    public static IGeom group(IGeom ... geoms) {
        if (geoms.length == 0) {
            return EmptyGeom.INSTANCE;
        }
        if (geoms.length == 1) {
            return geoms[0];
        }
        return new GeomGroup(Arrays.asList(geoms));
    }

    public static IGeom group(Collection<? extends IGeom> geoms) {
        if (geoms.isEmpty()) {
            return EmptyGeom.INSTANCE;
        }
        if (geoms.size() == 1) {
            return geoms.iterator().next();
        }
        return new GeomGroup(geoms);
    }

    public static IGeom filter(IGeom geom, int primTypes) {
        List<IPrimitive> geoms = GeomUtil.explodeToTypes(geom, primTypes);
        return GeomUtil.group(geoms);
    }

    public static ICurve generatePathCatmullRom(List<Point3d> points, boolean loop, CatmullRomSpline.Type type) {
        Point3d pLast;
        Point3d pFirst;
        assert (points.size() >= 2);
        if (points.size() == 2) {
            return new LineSeg(points.get(0), points.get(1));
        }
        if (loop) {
            pFirst = points.get(points.size() - 1);
            pLast = points.get(0);
        } else {
            pFirst = points.get(0);
            pLast = points.get(points.size() - 1);
        }
        int numCurves = loop ? points.size() : points.size() - 1;
        ICurve[] curves = new ICurve[numCurves];
        Point3d p0 = pFirst;
        for (int m = 0; m < points.size() - 1; ++m) {
            Point3d p1 = points.get(m);
            Point3d p2 = points.get(m + 1);
            Point3d p3 = m == points.size() - 2 ? pLast : points.get(m + 2);
            curves[m] = new CatmullRomSpline(type, p0, p1, p2, p3);
            p0 = p1;
        }
        if (loop) {
            Point3d p1 = pFirst;
            Point3d p2 = pLast;
            Point3d p3 = points.get(1);
            curves[numCurves - 1] = new CatmullRomSpline(type, p0, p1, p2, p3);
        }
        return new PolyCurve(curves);
    }

    public static AABox getTransformedBounds(TransformInfo ti, IGeom geom, AABox aabb) {
        geom.getBoundingBox(GeomUtil.getBoundsTransformer(ti, aabb));
        return aabb;
    }

    public static AABox getBoundsTransformer(TransformInfo ti, final AABox aabb) {
        if (ti.isIdentity()) {
            return aabb;
        }
        final Matrix4d mat = ti.getMatrix();
        return new AABox(){

            @Override
            public void add(AABox box) {
                aabb.add(box.transform(mat));
            }

            @Override
            public void add(ISearchVol vol) {
                assert (false);
                aabb.add(vol);
            }

            @Override
            public void addPoint(double x, double y, double z) {
                Point3d p = new Point3d(x, y, z);
                mat.transform(p);
                aabb.addPoint(p.x, p.y, p.z);
            }
        };
    }
}

