/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.delaunay.MeshBuilder;
import thunderheadeng.delaunay.TriangulatorInfo;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.AFace;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.NullOptimizer;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.util.Pair;

public class GeneralPoly
extends AFace
implements IPolygon {
    static final long serialVersionUID = 1L;
    public final Point3d[] points;
    public final int[] loopOffsets;

    public GeneralPoly(Collection<Point3d> points, int ... loopOffsets) {
        this(points.toArray(new Point3d[points.size()]), loopOffsets);
    }

    public GeneralPoly(Point3d[] points, int ... loopOffsets) {
        assert (points.length >= 3);
        assert (GeneralPoly.checkLoopOffsets(points, loopOffsets));
        this.points = points;
        this.loopOffsets = loopOffsets;
    }

    public GeneralPoly(Point3d[][] points) {
        int totNumPoints = 0;
        for (int m = 0; m < points.length; ++m) {
            totNumPoints += points[m].length;
        }
        this.points = new Point3d[totNumPoints];
        int loopOffset = 0;
        this.loopOffsets = new int[points.length];
        for (int m = 0; m < points.length; ++m) {
            this.loopOffsets[m] = loopOffset;
            Point3d[] loop = points[m];
            for (int n = 0; n < loop.length; ++n) {
                this.points[loopOffset + n] = loop[n];
            }
            loopOffset += points[m].length;
        }
    }

    @Override
    public GeneralPoly flipOrient() {
        Point3d[] revPoints = new Point3d[this.points.length];
        int end = this.loopOffsets.length - 1;
        for (int m = 0; m < this.loopOffsets.length; ++m) {
            int offset1 = this.loopOffsets[m];
            int offset2 = m == end ? this.points.length : this.loopOffsets[m + 1];
            int length = offset2 - offset1;
            GeomUtil.reverse(this.points, offset1, revPoints, offset1, length);
        }
        return new GeneralPoly(revPoints, this.loopOffsets);
    }

    @Override
    public Plane3d getPlane(boolean ccw) {
        if (this.points.length == 0) {
            return new Plane3d(0.0, 0.0, 1.0, 0.0);
        }
        Vector3d normal = this.getNormal(ccw);
        return new Plane3d(normal, this.points[0]);
    }

    @Override
    public Plane3d getPlaneIfValid(boolean ccw) {
        if (this.points.length == 0) {
            return null;
        }
        Vector3d normal = this.getNormalIfValid(ccw);
        return normal != null ? new Plane3d(normal, this.points[0]) : null;
    }

    public static boolean checkLoopOffsets(Point3d[] points, int ... loopOffsets) {
        for (int offset : loopOffsets) {
            if (offset >= 0 && offset < points.length) continue;
            return false;
        }
        return true;
    }

    @Override
    public GeneralPoly optimize(IPointOptimizer pool) {
        if (pool instanceof NullOptimizer) {
            return this;
        }
        boolean changed = false;
        Point3d[] npoints = new Point3d[this.points.length];
        for (int m = 0; m < this.points.length; ++m) {
            npoints[m] = pool.getExisting(this.points[m]);
            changed |= npoints[m] != this.points[m];
        }
        return changed ? new GeneralPoly(npoints, this.loopOffsets) : this;
    }

    @Override
    public AABox getBoundingBox(AABox aabb) {
        aabb.add(this.points);
        return aabb;
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    @Override
    public IDOF getRetainingDOF() {
        return IDOF.FREE;
    }

    @Override
    public GeneralPoly transform(TransformInfo ti, int options) {
        if (ti.isIdentity()) {
            return this;
        }
        Point3d[] newPoints = GeomUtil.xformVerts(this.points, ti.getMatrix());
        return new GeneralPoly(newPoints, this.loopOffsets);
    }

    @Override
    public int getNumLoops() {
        return this.loopOffsets.length;
    }

    @Override
    public int getNumPoints(int loop) {
        assert (loop >= 0 && loop < this.loopOffsets.length);
        if (loop == this.loopOffsets.length - 1) {
            return this.points.length - this.loopOffsets[loop];
        }
        return this.loopOffsets[loop + 1] - this.loopOffsets[loop];
    }

    @Override
    public Point3d getPoint(int loop, int ix) {
        assert (loop >= 0 && loop < this.loopOffsets.length);
        return this.points[this.loopOffsets[loop] + ix];
    }

    @Override
    public Vector3d getNormal(boolean ccw) {
        Vector3d normal;
        List<Point3d> outerPoints = Arrays.asList(this.points);
        if (this.loopOffsets.length > 1) {
            outerPoints = outerPoints.subList(0, this.loopOffsets[1]);
        }
        return (normal = Util3D.simplePolygonNormal(outerPoints, ccw, 0.0)) == null ? GeomConstants.VEC3D_ZERO : normal;
    }

    @Override
    public Vector3d getNormalIfValid(boolean ccw) {
        List<Point3d> outerPoints = Arrays.asList(this.points);
        if (this.loopOffsets.length > 1) {
            outerPoints = outerPoints.subList(0, this.loopOffsets[1]);
        }
        return Util3D.simplePolygonNormal(outerPoints, ccw, 0.0);
    }

    @Override
    public Pair<Mesh, Boolean> triangulate(double errorTol, boolean ccw) {
        int m;
        int m2;
        HashMap<Point2d, Point3d> localVertMap = new HashMap<Point2d, Point3d>();
        Plane3d plane = Util3D.simplePolygonPlane(Arrays.asList(this.points), true, 0.0);
        if (plane == null) {
            return new Pair<Mesh, Boolean>(new Mesh(new Point3d[0], new int[0], 2, 0), true);
        }
        Matrix4d wlXform = Util.getWorldToLocalXform(plane);
        Matrix4d lwXform = Util.getLocalToWorldXform(plane);
        Point2d[] p2ds = new Point2d[this.points.length];
        MeshBuilder mb = new MeshBuilder(1.0E-6);
        for (m2 = 0; m2 < this.points.length; ++m2) {
            Point2d xformed = Util3D.xform2d(wlXform, this.points[m2]);
            localVertMap.put(xformed, this.points[m2]);
            p2ds[m2] = xformed;
        }
        for (m2 = 0; m2 < this.loopOffsets.length; ++m2) {
            int numVerts = this.getNumPoints(m2);
            int begin = this.loopOffsets[m2];
            for (int n = 0; n < numVerts; ++n) {
                Point2d p1 = p2ds[begin + n];
                Point2d p2 = p2ds[begin + (n + 1) % numVerts];
                mb.addEdge(p1, p2);
            }
        }
        thunderheadeng.delaunay.Mesh mesh = mb.build();
        boolean triangulated = mesh.triangulateEvenOdd(0, 0.0);
        if (!triangulated) {
            return new Pair<Mesh, Boolean>(new Mesh(new Point3d[0], new int[0], 2, 0), true);
        }
        LinkedHashMap<Point3d, Integer> pointIxMap = new LinkedHashMap<Point3d, Integer>();
        TriangulatorInfo result = mesh.getOutput();
        int[] localWorldIxes = new int[result.points.length];
        for (m = 0; m < result.points.length; ++m) {
            Integer ix;
            Point2d p2d = result.points[m];
            Point3d p3d = (Point3d)localVertMap.get(p2d);
            if (p3d == null) {
                p3d = Util3D.xform(lwXform, new Point3d(p2d.x, p2d.y, 0.0));
            }
            if ((ix = (Integer)pointIxMap.get(p3d)) == null) {
                ix = pointIxMap.size();
                pointIxMap.put(p3d, ix);
            }
            localWorldIxes[m] = ix;
        }
        for (m = 0; m < result.triangles.length; ++m) {
            result.triangles[m] = localWorldIxes[result.triangles[m]];
        }
        Mesh resultMesh = new Mesh(pointIxMap.keySet().toArray(new Point3d[pointIxMap.size()]), result.triangles, 2);
        return new Pair<Mesh, Boolean>(resultMesh, true);
    }
}

